/*
 * Decompiled with CFR 0.152.
 */
package sk.uniba.fmph.pocprak.ioutils;

public class SPrintF {
    private static int width;
    private static boolean isWith;
    private static int precision;
    private static boolean isPrecision;
    private static char type;

    public static String Double(String format, double x) {
        SPrintF.parseFormat(format);
        switch (type) {
            case 'g': {
                return SPrintF.DoubleG(x);
            }
            case 'G': {
                return SPrintF.DoubleG(x);
            }
            case 'e': {
                return SPrintF.DoubleE(x);
            }
            case 'E': {
                return SPrintF.DoubleE(x);
            }
        }
        return SPrintF.DoubleG(x);
    }

    public static String Integer(String format, int x) {
        SPrintF.parseFormat(format);
        switch (type) {
            case 'D': {
                break;
            }
            case 'd': {
                break;
            }
        }
        String retString = String.valueOf(x);
        while (retString.length() < width) {
            retString = new String(" ").concat(retString);
        }
        return retString;
    }

    private static String DoubleG(double x) {
        boolean over;
        boolean negative;
        double xloc = x;
        boolean bl = negative = xloc < 0.0;
        if (negative) {
            xloc = -xloc;
        }
        int n = 0;
        while (xloc >= 10.0) {
            ++n;
            xloc /= 10.0;
        }
        if (xloc == 0.0) {
            n = -2;
        } else {
            while (xloc < 1.0) {
                --n;
                xloc *= 10.0;
            }
        }
        double precisionFac = 1.0;
        for (int i = 1; i < precision; ++i) {
            precisionFac *= 10.0;
        }
        long lx = Math.round(precisionFac * xloc);
        long lxcut = (long)(precisionFac * xloc);
        String retStringcut = String.valueOf(lxcut);
        String retString = String.valueOf(lx);
        boolean bl2 = over = retString.length() > retStringcut.length();
        if (over) {
            retString = retString.substring(0, retString.length() - 1);
            ++n;
        }
        if (n > precision - 1 || n < -3) {
            retString = precision > 1 ? retString.substring(0, 1).concat(".").concat(retString.substring(1)) : retString.substring(0, 1).concat(".");
            retString = retString.concat("E").concat(String.valueOf(n));
        } else if (n != precision - 1) {
            if (n >= 0) {
                retString = retString.substring(0, n + 1).concat(".").concat(retString.substring(n + 1));
            } else if (n == -1) {
                retString = new String("0.").concat(retString);
            } else if (n == -2) {
                retString = new String("0.0").concat(retString);
            } else if (n == -3) {
                retString = new String("0.00").concat(retString);
            }
        }
        if (negative) {
            retString = new String("-").concat(retString);
        }
        while (retString.length() < width) {
            retString = new String(" ").concat(retString);
        }
        return retString;
    }

    private static String DoubleE(double x) {
        boolean over;
        boolean negative;
        double xloc = x;
        boolean bl = negative = xloc < 0.0;
        if (negative) {
            xloc = -xloc;
        }
        int n = 0;
        while (xloc > 10.0) {
            ++n;
            xloc /= 10.0;
        }
        while (xloc < 1.0) {
            --n;
            xloc *= 10.0;
        }
        double precisionFac = 1.0;
        for (int i = 1; i < precision; ++i) {
            precisionFac *= 10.0;
        }
        long lx = Math.round(precisionFac * xloc);
        long lxcut = (long)(precisionFac * xloc);
        String retString = String.valueOf(lx);
        String retStringcut = String.valueOf(lxcut);
        boolean bl2 = over = retString.length() > retStringcut.length();
        if (over) {
            retString = retString.substring(0, retString.length() - 1);
            ++n;
        }
        retString = precision > 1 ? retString.substring(0, 1).concat(".").concat(retString.substring(1)) : retString.substring(0, 1).concat(".");
        retString = retString.concat("E").concat(String.valueOf(n));
        if (negative) {
            retString = new String("-").concat(retString);
        }
        while (retString.length() < width) {
            retString = new String(" ").concat(retString);
        }
        return retString;
    }

    private static void parseFormat(String format) {
        int lastIndex = format.length() - 1;
        type = format.charAt(lastIndex);
        switch (type) {
            case 'g': {
                break;
            }
            case 'G': {
                break;
            }
            case 'e': {
                break;
            }
            case 'E': {
                break;
            }
            case 'd': {
                break;
            }
            case 'D': {
                break;
            }
            default: {
                SPrintF.setDefaultFormat();
                return;
            }
        }
        if (lastIndex < 1) {
            SPrintF.setDefaultFormat();
            return;
        }
        String wpString = format.substring(0, lastIndex);
        int dotindex = wpString.indexOf(46);
        try {
            if (dotindex != -1) {
                isPrecision = true;
                String wString = wpString.substring(0, dotindex);
                width = Integer.parseInt(wString);
                String pString = wpString.substring(dotindex + 1);
                precision = Integer.parseInt(pString);
            } else {
                isPrecision = true;
                precision = 3;
                String wString = wpString;
                width = Integer.parseInt(wString);
            }
        }
        catch (Exception e) {
            SPrintF.setDefaultFormat();
            return;
        }
    }

    private static void setDefaultFormat() {
        isPrecision = true;
        isWith = false;
        precision = 3;
        type = (char)103;
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println(SPrintF.Double("15.4g", 9.99E-64));
        System.out.println(SPrintF.Double("15.2g", 9.99E-64));
        System.out.println(SPrintF.Double("15.2g", 9.99E-5));
        System.out.println(SPrintF.Double("15.2g", 9.99E-4));
        System.out.println(SPrintF.Double("15.2g", 0.00999));
        System.out.println(SPrintF.Double("15.2g", 0.0999));
        System.out.println(SPrintF.Double("15.2g", 0.999));
        System.out.println(SPrintF.Double("15.2g", 9.99));
        System.out.println(SPrintF.Double("15.2g", 99.9));
        System.out.println(SPrintF.Double("15.2g", 999.0));
        System.out.println(SPrintF.Double("15.2g", 9990.0));
        System.out.println(SPrintF.Double("15.2g", 99900.0));
        System.out.println(SPrintF.Double("15.2g", 999000.0));
        System.out.println(SPrintF.Double("15.2g", 9990000.0));
        System.out.println(SPrintF.Double("15.2g", 9.99E7));
        System.out.println(SPrintF.Double("15.4e", 9.99E-64));
        System.out.println(SPrintF.Double("15.2e", 9.99E-64));
        System.out.println(SPrintF.Double("15.2e", 9.99E-5));
        System.out.println(SPrintF.Double("15.2e", 9.99E-4));
        System.out.println(SPrintF.Double("15.2e", 0.00999));
        System.out.println(SPrintF.Double("15.2e", 0.0999));
        System.out.println(SPrintF.Double("15.2e", 0.999));
        System.out.println(SPrintF.Double("15.2e", 9.99));
        System.out.println(SPrintF.Double("15.2e", 99.9));
        System.out.println(SPrintF.Double("15.2e", 999.0));
        System.out.println(SPrintF.Double("15.2e", 9990.0));
        System.out.println(SPrintF.Double("15.2e", 99900.0));
        System.out.println(SPrintF.Double("15.2e", 999000.0));
        System.out.println(SPrintF.Double("15.2e", 9990000.0));
        System.out.println(SPrintF.Double("15.2e", 9.99E7));
    }

    static {
        isWith = false;
        precision = 3;
        isPrecision = true;
        type = (char)103;
    }
}

