/*
 * Decompiled with CFR 0.152.
 */
package sk.uniba.fmph.pocprak.simplegraphics;

import sk.uniba.fmph.pocprak.simplegraphics.GrGraphics;

public class GrAxis {
    public double min = 0.0;
    public double max = 100.0;
    public double otherAxisPosition = 0.0;
    public boolean showLabeledTicks = true;
    public double baseLabeledTickPosition = 0.0;
    public double deltaLabeledTick = 20.0;
    public double hLabeledTick = 5.0;
    public String labelFormat = "4.2g";

    public GrAxis() {
    }

    public GrAxis(double min, double max, double otherAxisPosition) {
        this.min = min;
        this.max = max;
        this.otherAxisPosition = otherAxisPosition;
    }

    public void setLTicks(double basePosition, double delta) {
        this.baseLabeledTickPosition = basePosition;
        this.deltaLabeledTick = delta;
    }

    public void draw(GrGraphics gG) {
        this.drawAxisLine(gG);
        if (this.showLabeledTicks) {
            double tickPosition;
            for (tickPosition = this.baseLabeledTickPosition; tickPosition <= this.max; tickPosition += this.deltaLabeledTick) {
                if (Math.abs(tickPosition) < 0.1 * this.deltaLabeledTick) {
                    tickPosition = 0.0;
                }
                this.drawTick(gG, tickPosition, this.hLabeledTick);
            }
            for (tickPosition = this.baseLabeledTickPosition - this.deltaLabeledTick; tickPosition >= this.min; tickPosition -= this.deltaLabeledTick) {
                if (Math.abs(tickPosition) < 0.1 * this.deltaLabeledTick) {
                    tickPosition = 0.0;
                }
                this.drawTick(gG, tickPosition, this.hLabeledTick);
            }
        }
    }

    public void drawAxisLine(GrGraphics gG) {
    }

    public void drawTick(GrGraphics gG, double position, double size) {
    }
}

