/*
 * Decompiled with CFR 0.152.
 */
package sk.uniba.fmph.pocprak.simplegraphics;

import sk.uniba.fmph.pocprak.simplegraphics.GrAxisX;
import sk.uniba.fmph.pocprak.simplegraphics.GrAxisY;
import sk.uniba.fmph.pocprak.simplegraphics.GrFCN1;
import sk.uniba.fmph.pocprak.simplegraphics.GrGraphics;
import sk.uniba.fmph.pocprak.simplegraphics.SimpleGraphics;
import sk.uniba.fmph.pocprak.simplegraphics.testFCN1;

public class GrGraph1 {
    public static final int Gr_SIMPLE = 1;
    public GrFCN1 fcn;
    public double yMin = 0.0;
    public double yMax = 100.0;
    public double xMin = 0.0;
    public double xMax = 100.0;
    public int nBins = 100;
    public double xPosition = 0.0;
    public double yPosition = 0.0;
    public GrAxisX aX;
    public GrAxisY aY;
    public double[] xvals;
    public double[] yvals;
    public double[] ervals;
    public int grType = 1;

    public GrGraph1(GrFCN1 FCN) {
        this.aX = new GrAxisX(this.xMin, this.xMax, this.yPosition);
        this.aY = new GrAxisY(this.yMin, this.yMax, this.xPosition);
        this.fcn = FCN;
        this.recalculate();
    }

    public GrGraph1(GrFCN1 FCN, double xmin, double x0, double xmax, double ymin, double y0, double ymax) {
        this.xMin = xmin;
        this.xMax = xmax;
        this.yPosition = x0;
        this.yMin = ymin;
        this.yMax = ymax;
        this.xPosition = y0;
        this.aX = new GrAxisX(this.xMin, this.xMax, this.yPosition);
        this.aY = new GrAxisY(this.yMin, this.yMax, this.xPosition);
        this.aX.setLTicks(this.xMin, (this.xMax - this.xMin) / 10.0);
        this.aY.setLTicks(this.yMin, (this.yMax - this.yMin) / 10.0);
        this.fcn = FCN;
        this.recalculate();
    }

    public void setGrAxisX(GrAxisX aX) {
        this.aX = aX;
    }

    public void setGrAxisY(GrAxisY aY) {
        this.aY = aY;
    }

    public GrGraph1(double xmin, double x0, double xmax, double ymin, double y0, double ymax) {
        this.xMin = xmin;
        this.xMax = xmax;
        this.yPosition = x0;
        this.yMin = ymin;
        this.yMax = ymax;
        this.xPosition = y0;
        this.aX = new GrAxisX(this.xMin, this.xMax, this.yPosition);
        this.aY = new GrAxisY(this.yMin, this.yMax, this.xPosition);
    }

    public void setFCN(GrFCN1 FCN) {
        this.fcn = FCN;
    }

    public void resetBins(int nbins) {
        this.nBins = nbins;
        this.xvals = new double[this.nBins + 1];
        this.yvals = new double[this.nBins + 1];
        this.ervals = new double[this.nBins + 1];
    }

    public void recalculate() {
        double x;
        this.xvals = new double[this.nBins + 1];
        this.yvals = new double[this.nBins + 1];
        double delta = (this.xMax - this.xMin) / (double)this.nBins;
        this.xvals[0] = x = this.xMin + 0.001 * delta;
        this.yvals[0] = this.fcn.fcnvalue(x);
        x = this.xMin;
        for (int i = 1; i < this.nBins; ++i) {
            this.xvals[i] = x += delta;
            this.yvals[i] = this.fcn.fcnvalue(x);
        }
        this.xvals[this.nBins] = x = this.xMax - 0.001 * delta;
        this.yvals[this.nBins] = this.fcn.fcnvalue(x);
    }

    public void draw(GrGraphics gG) {
        this.aX.draw(gG);
        this.aY.draw(gG);
        switch (this.grType) {
            case 1: {
                for (int i = 0; i < this.nBins; ++i) {
                    gG.drawLine2D(this.xvals[i], this.yvals[i], this.xvals[i + 1], this.yvals[i + 1]);
                }
                break;
            }
        }
    }

    public static void main(String[] args) {
        GrGraphics gr = SimpleGraphics.CreateGrEnvironment();
        gr.setBasePoint(GrGraphics.CENTER);
        gr.setUserFrameSize(0.0, 0.0, 5.0, 1.0);
        testFCN1 fcn1 = new testFCN1();
        GrGraph1 graph1 = new GrGraph1(fcn1, -4.0, 0.0, 4.0, -1.0, 0.0, 1.0);
        graph1.draw(gr);
        gr.repaint();
    }
}

