/*
 * Decompiled with CFR 0.152.
 */
package sk.uniba.fmph.pocprak.simplegraphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class GrGraphics {
    public static int CENTER = 0;
    public static int LL = 1;
    public double margin = 40.0;
    public BufferedImage image;
    public Graphics2D displayG;
    public double displayWidth;
    public double displayHeight;
    public double basePointX;
    public double basePointY;
    public double userBasePointX;
    public double userBasePointY;
    public double userXmin;
    public double userYmin;
    public double userXmax;
    public double userYmax;
    public double scaleX;
    public double scaleY;
    public JComponent display;
    private Font defFont;

    public GrGraphics(int width, int height) {
        this.newImage(width, height);
    }

    public GrGraphics() {
        this(512, 512);
    }

    public void setDisplayComponent(JComponent jc) {
        this.display = jc;
    }

    public void repaint() {
        this.display.repaint();
    }

    public void newImage(int width, int height) {
        this.image = new BufferedImage(width, height, 1);
        this.displayG = this.image.createGraphics();
        this.defFont = this.displayG.getFont();
        this.displayG.setBackground(Color.white);
        this.displayWidth = this.image.getWidth();
        this.displayHeight = this.image.getHeight();
        this.clearImage();
        this.setBasePoint(LL);
        this.setUserFrameSize(0.0, 0.0, 1.0, 1.0);
    }

    public void clearImage() {
        this.displayG.clearRect(0, 0, (int)this.displayWidth, (int)this.displayHeight);
        this.displayG.setPaint(Color.black);
        this.displayG.setFont(this.defFont);
    }

    public void setBasePoint(double BX, double BY) {
        this.basePointX = BX;
        this.basePointY = BY;
    }

    public void setBasePoint(int option) {
        if (option == CENTER) {
            this.setBasePoint(this.displayWidth / 2.0, this.displayHeight / 2.0);
        }
        if (option == LL) {
            this.setBasePoint(this.margin, this.displayHeight - this.margin);
        }
    }

    public void setUserFrameSize(double uBPX, double uBPY, double uRX, double uRY) {
        this.userBasePointX = uBPX;
        this.userBasePointY = uBPY;
        this.userXmax = uRX;
        this.userYmax = uRY;
        this.scaleX = (this.displayWidth - this.margin - this.basePointX) / (this.userXmax - this.userBasePointX);
        this.scaleY = (this.basePointY - this.margin) / (this.userYmax - this.userBasePointY);
        this.userXmin = this.userBasePointX - (this.basePointX - this.margin) / this.scaleX;
        this.userYmin = this.userBasePointY - (this.displayHeight - this.basePointY - this.margin) / this.scaleY;
    }

    public double getLineAngle(double x1, double y1, double x2, double y2) {
        double dely = y2 - y1;
        double delx = x2 - x1;
        return Math.atan2(dely, delx);
    }

    public double getDisplayLineAngle(double x1, double y1, double x2, double y2) {
        double dely = (y2 - y1) * this.scaleY;
        double delx = (x2 - x1) * this.scaleX;
        return Math.atan2(dely, delx);
    }

    public void drawLine2D(double x1, double y1, double x2, double y2) {
        this.displayG.draw(new Line2D.Double(this.displayX(x1), this.displayY(y1), this.displayX(x2), this.displayY(y2)));
    }

    public void drawArrow2D(double x1, double y1, double x2, double y2) {
        this.displayG.draw(new Line2D.Double(this.displayX(x1), this.displayY(y1), this.displayX(x2), this.displayY(y2)));
        double theta = this.getDisplayLineAngle(x1, y1, x2, y2);
        this.drawArrowEnd2D(-theta, x2, y2);
    }

    public void drawArrowEnd2D(double x, double y) {
        this.displayG.draw(new Line2D.Double(this.displayX(x) - 6.0, this.displayY(y) + 3.0, this.displayX(x), this.displayY(y)));
        this.displayG.draw(new Line2D.Double(this.displayX(x) - 6.0, this.displayY(y) - 3.0, this.displayX(x), this.displayY(y)));
    }

    public void drawArrowEnd2D(double theta, double x, double y) {
        AffineTransform transform = this.displayG.getTransform();
        this.displayG.setTransform(AffineTransform.getRotateInstance(theta, this.displayX(x), this.displayY(y)));
        this.drawArrowEnd2D(x, y);
        this.displayG.setTransform(transform);
    }

    public void drawPoint(double x, double y) {
        this.displayG.drawOval((int)this.displayX(x), (int)this.displayY(y), 0, 0);
    }

    public void drawPoint(double x, double y, int size) {
        this.displayG.fillOval((int)this.displayX(x) - size, (int)this.displayY(y) - size, 2 * size, 2 * size);
    }

    public void drawEllipse2D(double x, double y, double width, double height) {
        this.displayG.draw(new Ellipse2D.Double(this.displayX(x), this.displayY(y), this.userWidthToDisplayWidth(width), this.userHeighToDisplayHeight(height)));
    }

    public void drawCircle2D(double x, double y, double r) {
        this.drawEllipse2D(x - r, y + r, 2.0 * r, 2.0 * r);
    }

    public void drawString(String s, double x, double y) {
        this.displayG.drawString(s, (float)this.displayX(x), (float)this.displayY(y));
    }

    public void drawStringTop(String s, double x, double y) {
        float size = this.displayG.getFont().getSize2D();
        this.displayG.drawString(s, (float)this.displayX(x), size + (float)this.displayY(y));
    }

    public void drawStringRight(String s, double x, double y) {
        FontRenderContext frc = this.displayG.getFontRenderContext();
        float width = (float)this.displayG.getFont().getStringBounds(s, frc).getWidth();
        this.displayG.drawString(s, (float)this.displayX(x) - width, (float)this.displayY(y));
    }

    public void drawStringTopRight(String s, double x, double y) {
        float size = this.displayG.getFont().getSize2D();
        FontRenderContext frc = this.displayG.getFontRenderContext();
        float width = (float)this.displayG.getFont().getStringBounds(s, frc).getWidth();
        this.displayG.drawString(s, (float)this.displayX(x) - width, size + (float)this.displayY(y));
    }

    public void drawStringCenter(String s, double x, double y) {
        FontRenderContext frc = this.displayG.getFontRenderContext();
        float width = (float)this.displayG.getFont().getStringBounds(s, frc).getWidth();
        this.displayG.drawString(s, (float)this.displayX(x) - 0.5f * width, (float)this.displayY(y));
    }

    public void drawStringTopCenter(String s, double x, double y) {
        float size = this.displayG.getFont().getSize2D();
        FontRenderContext frc = this.displayG.getFontRenderContext();
        float width = (float)this.displayG.getFont().getStringBounds(s, frc).getWidth();
        this.displayG.drawString(s, (float)this.displayX(x) - 0.5f * width, size + (float)this.displayY(y));
    }

    public void drawStringCenterCenter(String s, double x, double y) {
        float size = this.displayG.getFont().getSize2D();
        FontRenderContext frc = this.displayG.getFontRenderContext();
        float width = (float)this.displayG.getFont().getStringBounds(s, frc).getWidth();
        this.displayG.drawString(s, (float)this.displayX(x) - 0.5f * width, 0.5f * size + (float)this.displayY(y));
    }

    public void drawBGStringCenterCenter(String s, double x, double y) {
        float size = this.displayG.getFont().getSize2D();
        FontRenderContext frc = this.displayG.getFontRenderContext();
        float width = (float)this.displayG.getFont().getStringBounds(s, frc).getWidth();
        Rectangle2D box = this.displayG.getFont().getStringBounds(s, frc);
        box.setRect(this.displayX(x) - 0.5 * (double)width, -0.5 * box.getHeight() + this.displayY(y), box.getWidth(), box.getHeight());
        Paint oldpaint = this.displayG.getPaint();
        Color bkcolor = this.displayG.getBackground();
        this.displayG.setPaint(bkcolor);
        this.displayG.fill(box);
        this.displayG.setPaint(oldpaint);
        this.displayG.drawString(s, (float)this.displayX(x) - 0.5f * width, 0.5f * size + (float)this.displayY(y));
    }

    public void drawStringCenterCenter(double theta, String s, double x, double y) {
        AffineTransform transform = this.displayG.getTransform();
        this.displayG.setTransform(AffineTransform.getRotateInstance(-theta, this.displayX(x), this.displayY(y)));
        this.drawStringCenterCenter(s, x, y);
        this.displayG.setTransform(transform);
    }

    public void drawBGStringCenterCenter(double theta, String s, double x, double y) {
        AffineTransform transform = this.displayG.getTransform();
        this.displayG.setTransform(AffineTransform.getRotateInstance(-theta, this.displayX(x), this.displayY(y)));
        this.drawBGStringCenterCenter(s, x, y);
        this.displayG.setTransform(transform);
    }

    public void setPaint(Paint paint) {
        this.displayG.setPaint(paint);
    }

    public void setFont(Font font) {
        this.displayG.setFont(font);
    }

    public Font getFont() {
        return this.displayG.getFont();
    }

    public double displayX(double userX) {
        return this.basePointX + (userX - this.userBasePointX) * this.scaleX;
    }

    public double displayY(double userY) {
        return this.basePointY - (userY - this.userBasePointY) * this.scaleY;
    }

    public double userX(double dispX) {
        return this.userBasePointX + (dispX - this.basePointX) / this.scaleX;
    }

    public double userY(double dispY) {
        return this.userBasePointY + (this.basePointY - dispY) / this.scaleY;
    }

    public double pixToUserWidth(int pix) {
        return (double)pix * 1.0001 / this.scaleX;
    }

    public double pixToUserHeight(int pix) {
        return (double)pix * 1.0001 / this.scaleY;
    }

    public double userWidthToDisplayWidth(double UserWidth) {
        return UserWidth * this.scaleX;
    }

    public double userHeighToDisplayHeight(double UserHeight) {
        return UserHeight * this.scaleY;
    }
}

