package datalog_ra.base.TupleTransformation;

import datalog_ra.base.relation.Attribute;
import datalog_ra.base.relation.Tuple;
import java.util.Iterator;
import java.util.List;

/*
 * @author Jakub
*/
public class ProjectionTransformation implements TupleTransformation{
    private final List<Integer> net;
    
    public ProjectionTransformation(List<Integer> net) {
        this.net = net;
    }
    
    @Override
    public Tuple transform(Tuple tuple) {
        if (tuple == null)
            return null; 
        Tuple result = new Tuple();
        for (Integer index : net) {
            result.add(tuple.get(index));
        }
        return result;
    }
    
}
