% citatel(CitatelID, Meno, DatumPrihlasenia)
citatel(1,janko,2015-01-04).
citatel(2,misko,2015-01-06).
citatel(3,jurko,2015-01-07).
citatel(4,matko,2015-01-01).
citatel(5,lacko,2015-01-03).
citatel(6,kubko,2015-01-05).
citatel(7,lukasko,2015-01-02).

% kniha(KnihaID,Nazov,Autor)
kniha(40,inferno,danbrown).
kniha(60,digitalnapevnost,danbrown).
kniha(30,anjeliademoni,danbrown).
kniha(50,zlodejkaknih,markuszsusak).
kniha(10,sofiinavolba,williamstyron).
kniha(20,harrypotter,jkrowling).
kniha(100,olivertwist,charlesdickens).

% pozicka(CitatelID,KnihaID,DatumPozicania,DatumVratenia)
pozicka(2,50,2015-02-01,2015-02-18).
pozicka(2,40,2015-03-15,null).
pozicka(6,100,2015-10-10,2015-10-29).
pozicka(3,100,2015-03-15,2015-03-20).
pozicka(1,100,2015-03-01,null).
pozicka(3,100,2015-02-04,2015-08-26).
pozicka(7,40,2015-02-01,2015-05-05).
pozicka(7,30,2015-06-14,2015-07-07).
pozicka(7,60,2015-06-14,null).
pozicka(1,30,2015-02-01,null).
pozicka(3,60,2015-02-01,2015-02-26).
pozicka(4,40,2015-11-10,null).
pozicka(6,60,2015-02-01,2015-09-01).

% /*1. Vypiste vsetky trojice [meno_citatela, nazov_knihy, DatumPozicania], kde nazov_knihy je kniha, ktoru dany citatel este nevratil*/
ans1(M,K,D) :- citatel(IC,M,_), kniha(IK,K,_), pozicka(IC,IK,D,null).

% /*2. Vypiste nazvy knih, ktore si este nikto nepozical*/
pozicane(IK) :- pozicka(_,IK,_,_).
ans2(K) :- kniha(IK,K,_), \+ pozicane(IK).

% /*3. Najdite mena citatelov, ktori si este nic nepozicali*/
pozical(IC) :- pozicka(IC,_,_,_).
ans3(M) :- citatel(IC,M,_), \+ pozical(IC).

% /*4. Najdite mena citatelov, ktori maju vratene vsetky pozicane knihy*/
nevratil(IC) :- pozicka(IC,_,_,null).
ans4(M) :- citatel(IC,M,_), \+ nevratil(IC).

% /*5. Vypiste dvojice [meno_citatela, nazov_knihy], kde nazov_knihy je nazov knihy, ktoru si dany citatel pozical aspon 2x. */
ans5(M,K) :- citatel(IC,M,_), kniha(IK,K,_), pozicka(IC,IK,D1,_), pozicka(IC,IK,D2,_), \+ D1=D2.

% /*6. Vypiste dvojice [meno_citatela, nazov_knihy], kde nazov_knihy je nazov knihy, ktoru si dany citatel pozical prave 2x. */
inapozicka(IC,IK,D1,D2) :- pozicka(IC,IK,D1,D2), pozicka(IC,IK,D,_), \+ D=D1, \+ D=D2.
ans6(M,K) :- citatel(IC,M,_), kniha(IK,K,_), pozicka(IC,IK,D1,_), pozicka(IC,IK,D2,_), \+ D1=D2, \+inapozicka(IC,IK,D1,D2).

% /*7. Vypiste mena citatelov, ktori si pozicali aspon 2 rozne knihy, pricom vsetky pozicane knihy boli od toho isteho autora*/
dvajaautori(IC) :- kniha(IK1,_,A1), kniha(IK2,_,A2), pozicka(IC,IK1,_,_), pozicka(IC,IK2,_,_), \+ A1=A2. 
ans7(M) :- citatel(IC,M,_), pozicka(IC,IK1,_,_), pozicka(IC,IK2,_,_), \+ IK1=IK2, \+ dvajaautori(IC).

% /*8. Vypiste dvojice [meno_citatela, nazov_knihy], kde nazov_knihy je prva pozicana kniha daneho citatela*/
% skorpozicka(IC,D) :- pozicka(IC,_,Datum,_), Datum<D.
% ans8(M,K) :- citatel(IC,M,_), kniha(IK,K,_), pozicka(IC,IK,D,_), \+ skorpozicka(IC,D).

% /*9. Najdite meno autora, ktoreho si pozical kazdy citatel (aspon jednu jeho knihu)*/
ans9(A) :- kniha(_,_,A), \+necitany(A).
necitany(A) :- kniha(_, _, A), citatel(IC,_,_), \+ pozical(IC,A).
pozical(IC,A) :- citatel(IC,_,_), kniha(IK,_,A), pozicka(IC,IK,_,_).
