package datalog_ra.evaluation;

import java.util.List;
import java.util.ArrayList;

public final class Term {
    private final String term;
    private final boolean isVariable;

    public Term(String term, boolean isVariable) {
        this.term = term;
        this.isVariable = isVariable;
    }

    public Term(String term) {
        this(term, false);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) return false;
        if (other == this) return true;
        if (!(other instanceof Term)) return false;
        Term otherTerm = (Term) other;
        if (isVariable != otherTerm.isVariable) return false;
        // null represents anonymous variables
        if (term == null || otherTerm.term == null) return false;
        return term.equals(otherTerm.term);
    }

    public String getTerm() { return term; }
    public boolean isVariable() { return isVariable; }
    public boolean isConstant() { return !isVariable; }

    public static List<Term> termList(boolean variables, String... termNames) {
        ArrayList<Term> list = new ArrayList<>();
        for (String termName : termNames) {
            list.add(new Term(termName, variables));
        }
        return list;
    }
}
