package datalog_ra.Test;

import datalog_ra.base.dataStructures.Instance;
import datalog_ra.evaluation.Rule;
import datalog_ra.evaluation.Query;
import datalog_ra.evaluation.Term;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author Jakub
 */
public class wellf extends Query {

  public wellf(Instance source) {
    super(source);

    List<Term> termsX = Term.termList(true, "X");

    // answer(X):= m(X), not r(X)
    Rule a = new Rule("answer", termsX);
    a.addPositiveSubgoal("m", new ArrayList());
    a.addNegativeSubgoal("r", new ArrayList());
    addRule(a);

    // r(X):= answer(X)
    // r(X):= s(X)
    Rule r1 = new Rule("r", termsX);
    r1.addPositiveSubgoal("answer", termsX);
    addRule(r1);
    Rule r2 = new Rule("r", termsX);
    r2.addPositiveSubgoal("s", termsX);
    addRule(r2);

    // s(X):= answer(X)
    // s(X):= r(X)
    Rule s1 = new Rule("s", termsX);
    s1.addPositiveSubgoal("answer", termsX);
    addRule(s1);
    Rule s2 = new Rule("s", termsX);
    s2.addPositiveSubgoal("r", termsX);
    addRule(s2);

    // ?- answer(X).
    Rule query = new Rule("answer", termsX);
    setQuery(query);

    findWFModel();
    System.out.println(answer());
  }

}
