package datalog_ra.Test;

import datalog_ra.base.dataStructures.Instance;
import datalog_ra.evaluation.Rule;
import datalog_ra.evaluation.Query;
import datalog_ra.evaluation.Term;

import java.util.List;

/**
 *
 * @author Jakub
 */
public class winmove extends Query {
  
  public winmove(Instance source) {
    super(source);

    List<Term> termsX = Term.termList(true, "X");
    List<Term> termsY = Term.termList(true, "Y");
    List<Term> termsXY = Term.termList(true, "X", "Y");

    // win(X):= move(X, Y), not win(Y)
    Rule win = new Rule("win", termsX);
    win.addPositiveSubgoal("move", termsXY);
    win.addNegativeSubgoal("win", termsY);
    addRule(win);
    
    // ?- win(X).
    Rule query = new Rule("win", termsX);
    setQuery(query);
    
    findWFModel();
    System.out.println(answer());
  }
}
