package datalog_ra.base.TupleTransformation;

import datalog_ra.base.dataStructures.Tuple;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author Jakub
 */
public class TransformationSequence implements TupleTransformation {

  private final List<TupleTransformation> transformation;

  public TransformationSequence() {
    transformation = new LinkedList();
  }

  public TransformationSequence(List<? extends TupleTransformation> transformation) {
    this.transformation = new LinkedList(transformation);
  }

  public void add(TupleTransformation transformation) {
    this.transformation.add(transformation);
  }

  @Override
  public Tuple transform(Tuple tuple) {
    Tuple result = tuple;
    for (TupleTransformation tupleTrans : transformation) {
      result = tupleTrans.transform(result);
      if (result == null) {
        break;
      }
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    Iterator<TupleTransformation> iter = transformation.iterator();
    while(iter.hasNext()) {
      sb.append(iter.next());
      if(iter.hasNext()) {
        sb.append(", ");
      }
    }
    return sb.toString();
  }
}
