﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class Drop : MonoBehaviour, IDropHandler {
    public GameObject Item {
        get {
            if (transform.childCount == 1) {
                return null;
            }
            else if (transform.childCount > 0) {
                return transform.GetChild(0).gameObject;
            }
            return null;
        }
    }

    public void OnDrop(PointerEventData eventData)
    {
        if (!Item) {
            GameObject itemBeingDragged = DragHandler.itemBeingDragged; 
            //print(!itemBeingDragged.transform.parent.CompareTag("graf"));
            //print(transform.childCount);
            
            if (!itemBeingDragged.transform.parent.CompareTag("graf") && transform.childCount != 1) {
                //print("tu");
                if ("b" != itemBeingDragged.transform.GetChild(0).transform.GetComponentInChildren<Text>().text.ToString())
                {
                    GameObject newGameObject = Instantiate(itemBeingDragged, itemBeingDragged.transform.parent.position, Quaternion.identity);
                    newGameObject.transform.SetParent(itemBeingDragged.transform.parent, false);
                    newGameObject.GetComponent<CanvasGroup>().blocksRaycasts = true;
                }
                
            }
            if (transform.childCount != 1 ) {
                if ("b" != itemBeingDragged.transform.GetChild(0).transform.GetComponentInChildren<Text>().text.ToString())
                {
                    itemBeingDragged.transform.SetParent(transform);
                }
            }
            else {
                Text textFromParent = transform.GetChild(0).transform.GetChild(0).transform.GetComponentInChildren<Text>();
                Text textFromItemBeingDragged = itemBeingDragged.transform.GetChild(0).transform.GetComponentInChildren<Text>();
                print(transform.childCount);
                if (textFromParent.text.Length == 1 && textFromItemBeingDragged.text.ToString() != "b")
                {
                    textFromParent.text += textFromItemBeingDragged.text;
                }
                if (textFromParent.text.Length >= 1 && textFromItemBeingDragged.text.ToString() == "b")
                {
                    textFromParent.text = textFromParent.text.Substring(0, textFromParent.text.Length-1);
                    if (textFromParent.text.Length == 0)
                    {
                        Destroy(transform.GetChild(0).gameObject);
                    }
                }
            }
        }
    }
}
