import torch
import os
import json

class DataSetNeedleman(torch.utils.data.Dataset):
  def __init__(self, dir_path,num_files=10):
    files = os.listdir(dir_path)
    X = []
    Y = []
    counter=0
    for file in files:
      if counter ==num_files:
        break
      counter+=1
      file = file.strip()
      with open(dir_path+'\\'+file) as f:
        data = json.load(f)
        for d in data:
          X.append(d[:-1])
          Y.append(d[-1])
    
    self.X=torch.FloatTensor(X)
    self.Y=torch.FloatTensor([Y])
        

  def __len__(self):
    return len(self.X)

  def __getitem__(self, idx):
    device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
    sample =(self.X[idx].to(device),self.Y[:,idx].to(device))
    return sample




