from torch.nn import Module, Linear
from torch.nn.functional import relu, sigmoid

class OneCellNN(Module):
    def __init__(self):
        super(OneCellNN, self).__init__()
        self.fc1 = Linear(120, 128)
        self.fc2 = Linear(128, 128)
        self.fc3 = Linear(128, 32)
        self.fc4 = Linear(32, 1)
        
    def forward(self, x):
        x = self.fc1(x)
        x = relu(x)
        x = self.fc2(x)
        x = relu(x)
        x = self.fc3(x)
        x = relu(x)
        x = self.fc4(x)
        return x
