import torch
import os
import json

class DataSetNeedlemanConv(torch.utils.data.Dataset):
  def __init__(self, dir_path,num_files=10):
    files = os.listdir(dir_path)
    tab_X = []
    seq_X=[]
    Y = []
    counter=0
    for file in files:
      if counter ==num_files:
        break
      counter+=1
      file = file.strip()
      with open(dir_path+'\\'+file) as f:
        data = json.load(f)
        for d in data:
          tab_X.append(torch.FloatTensor(d[:-21]).reshape((1,10,10)))
          seq_X.append(d[-21:-1])
          Y.append(d[-1])
    
    self.tab_X=tab_X
    self.seq_X=torch.FloatTensor(seq_X)
    self.Y=torch.FloatTensor([Y])
        

  def __len__(self):
    return len(self.tab_X)

  def __getitem__(self, idx):
    device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
    sample =(self.tab_X[idx].to(device),self.seq_X[idx].to(device),self.Y[:,idx].to(device))
    return sample
