from torch.nn import Module, Linear,Conv2d,MaxPool2d
from torch.nn.functional import relu, sigmoid
import torch

class OneCellNNConv(Module):
    def __init__(self):
        super(OneCellNNConv, self).__init__()
        self.fc1 = Linear(120, 128)
        self.fc2 = Linear(128, 128)
        self.conv1=Conv2d(in_channels=1,out_channels=16,
                          kernel_size=3,padding='same')
        self.conv2=Conv2d(in_channels=16,out_channels=4,
                          kernel_size=3,padding='same')
        self.pool=MaxPool2d(2)
        self.fcFin = Linear(128, 1)
        
    def forward(self,table, seq):
        x = self.conv1(table)
        x=relu(x)
        x= self.conv2(x)
        x=relu(x)
        x=self.pool(x)
        
        x = self.fc1(torch.cat((torch.flatten(x,start_dim=1),seq),1))
        x = relu(x)
        x = self.fc2(x)
        x = relu(x)
        x = self.fcFin(x)
        return x
