import numpy as np
import numba
from numba import jit

@jit
def Needleman(a,b):
    medzera=-2
    zhoda=3
    nezhoda=-1
    A=np.zeros((len(a)+1,len(b)+1),dtype='int32')
    for i in range(len(A)):
        A[i][0]=i*medzera
    for i in range(len(A[0])):
        A[0][i]=i*medzera
    for i in range(1,len(A)):
        for j in range(1,len(A[0])):
            A[i,j]=max(A[i-1,j-1]+zhoda if a[i-1]==b[j-1] else A[i-1,j-1]+nezhoda,A[i-1,j]+medzera,A[i,j-1]+medzera)
    return A

def transform(seq,multiplier=1):
    ret=np.zeros(len(seq),dtype='int32').reshape((len(seq)))
    dc={'A':1,'T':2,'G':3,'C':4}
    for i in range(len(seq)):
        ret[i]=dc[seq[i]]*multiplier
    return ret
        
with open('data_fixed') as vstup:
        count=0
        size=10
        for row in vstup:
            print(count)
            count+=1
            akt=row.split()
            orig=akt[0]
            a=akt[1]
            b=akt[2]
            A=Needleman(orig,a)
            with open(f'NeedlemaFixed/out{count}a.txt','w') as vystup:
                rs=[]
                for i in range(1,len(orig)-size):
                    for j in range(1,len(a)-size):
                        if np.random.random()*1000>1:
                            continue
                        block=A[i:i+10,j:j+10]
                        score=block[-1,-1]
                        block[-1,-1]=0
                        aktArr=block.reshape((size*size)).tolist()
                        aktArr+=transform(orig[i-1:i-1+size]).tolist()
                        aktArr+=transform(a[j-1:j-1+size]).tolist()
                        aktArr.append(score)
                        rs.append(aktArr)
                vystup.write(str(rs))
            A=Needleman(orig,b)
            with open(f'NeedlemaFixed/out{count}b.txt','w') as vystup:
                rs=[]
                for i in range(1,len(orig)-size):
                    for j in range(1,len(b)-size):
                        if np.random.random()*1000>1:
                            continue
                        block=A[i:i+10,j:j+10]
                        score=block[-1,-1]
                        block[-1,-1]=0
                        aktArr=block.reshape((size*size)).tolist()
                        aktArr+=transform(orig[i-1:i-1+size]).tolist()
                        aktArr+=transform(b[j-1:j-1+size]).tolist()
                        aktArr.append(score)
                        rs.append(aktArr)
                vystup.write(str(rs))
            
            
        
