import torch
import os
import json

class DataSetAlligned(torch.utils.data.Dataset):
  def __init__(self, file_path):
    X = []
    Y = []
    size=1000
    with open(file_path,'r')as vstup:
        for row in vstup:
            row=row.split('] [')
            x=torch.zeros((size))
            y=torch.zeros((size))
            a=torch.FloatTensor(json.loads(row[0]+']'))
            b=torch.FloatTensor(json.loads('['+row[1]))
            x[:len(a)]+=a
            y[:len(b)]+=b
            X.append(x.reshape((1,-1)))
            Y.append(y.reshape((1,-1)))    
    self.X=X
    self.Y=Y
        

  def __len__(self):
    return len(self.X)

  def __getitem__(self, idx):
    device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
    sample =(self.X[idx].to(device),self.Y[idx].to(device))
    return sample
