from DataSetAlligned import DataSetAlligned
from torch.utils.data import  DataLoader
import torch
from torch.utils.data import random_split

dtst=DataSetAlligned('AllignedFixed/out.txt')
lngth=len(dtst)
dataset_train,dataset_eval=random_split(dtst,(round(0.8*lngth),round(0.2*lngth)),generator=torch.Generator().manual_seed(42))

dataloader_train = DataLoader(dataset_train, batch_size=32, shuffle=True)
dataloader_eval = DataLoader(dataset_eval, batch_size=32, shuffle=True)

model=torch.nn.Transformer(1000,10)
device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
model.to(device)
loss_func = torch.nn.MSELoss()
optimizer = torch.optim.Adam(model.parameters(), lr=1e-3)

for e in range(5):
  model.train()
  for i, batch in enumerate(dataloader_train):  
    x, y = batch
    optimizer.zero_grad()
    output = model(x,y)
    loss = loss_func(output, y) 
    loss.backward()
    optimizer.step()
    if i % 100 == 0:
      print("Loss at epoch: {} step {}: {}".format(e, i, loss.item()))

model.eval()
for i, batch in enumerate(dataloader_eval):  
    x, y = batch  
    output = model(x,torch.zeros(y.shape).to(device))
    loss = loss_func(output, y) 
    print("Loss step {}: {}".format(i, loss.item()))
    print("Mean {}".format(torch.mean(torch.abs(y-output))))
