import pandas as pd
import os
import numpy as np
from stl import mesh
from mpl_toolkits import mplot3d
from matplotlib import pyplot

#EXCEL HEADER
PIRADS_SCORE = 'UCLA Score (Similar to PIRADS v2)'
ROI_VOLUME = 'ROI Volume (cc)'
TARGET_NO = 'Target No.'
SERIES_UID_MRI = 'seriesInstanceUID_MR'
PATIENT_ID = 'Patient ID'

class TargetDataLoader:

    def __init__(self, root_path, stls):
        df = pd.read_csv(root_path, sep=';')
        self.data = df.to_dict(orient='records')
        self.stls_path = stls
        #print(type(self.data))
        #print(self.data)
        

    def get_for_patient(self, patient_id):
        patient_name = f'Prostate-MRI-US-Biopsy-{patient_id:04d}'
        stl_files = [x for x in self.data if x[PATIENT_ID] == patient_name]
        if len(stl_files) == 0:
            return None
        
        #print(stl_files)
        ids = [x[SERIES_UID_MRI] for x in stl_files]

        regions = []
        for file in os.listdir(self.stls_path):
            if not file.endswith('.STL'):
                continue
            if not file.startswith(patient_name):
                continue
            if any([idx in file for idx in ids]) and ('Target' in file):
                file_path = os.path.join(self.stls_path, file)
                #meshX = mesh.Mesh.from_file(file_path, remove_empty_areas=False)
                #np_arrayX = meshX.data
                #regions.append(meshX)
                regions.append(file_path)
        
        return regions
        


