/*
 * Decompiled with CFR 0.152.
 */
package gui;

import controller.Controller;
import gui.GraphFileFilter;
import gui.LightFileFilter;
import gui.form_panel.FormEvent;
import gui.form_panel.FormListener;
import gui.form_panel.FormPanel;
import gui.light_table.LightTablePanel;
import gui.results_table.ResultTablePanel;
import gui.text_panel.TextPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class MainFrame
extends JFrame {
    private LightTablePanel tablePanelInput;
    private ResultTablePanel tablePanelOutput;
    private FormPanel formPanel;
    private TextPanel textPanel;
    private JFileChooser configFileChooser;
    private JFileChooser graphFileChooser;
    private Controller controller;

    public MainFrame() {
        super("Spectrum Analyzer");
        final Cursor normalCursor = new Cursor(0);
        final Cursor hourglassCursor = new Cursor(3);
        this.setCursor(normalCursor);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        this.tablePanelInput = new LightTablePanel();
        this.tablePanelOutput = new ResultTablePanel();
        this.formPanel = new FormPanel();
        this.textPanel = new TextPanel();
        this.setJMenuBar(this.createMenuBar());
        this.configFileChooser = new JFileChooser();
        this.graphFileChooser = new JFileChooser();
        this.controller = new Controller();
        this.tablePanelInput.setData(this.controller.getLights());
        this.tablePanelOutput.setResults(this.controller.getResults());
        this.tablePanelInput.clearData();
        String workingDirectory = System.getProperty("user.dir");
        String filename = "list_of_lights_generic.txt";
        String absoluteFilePath = "";
        absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "input_data" + File.separator + filename;
        System.out.println("Final filepath : " + absoluteFilePath);
        this.controller.loadFromFile(new File(absoluteFilePath));
        this.tablePanelInput.refreshData();
        this.configFileChooser.addChoosableFileFilter(new LightFileFilter());
        this.graphFileChooser.addChoosableFileFilter(new GraphFileFilter());
        gc.gridy = 0;
        gc.weightx = 0.2;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.anchor = 10;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.formPanel, gc);
        gc.weightx = 3.0;
        gc.weighty = 1.0;
        gc.gridx = 1;
        gc.anchor = 10;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.tablePanelInput, gc);
        gc.gridy = 1;
        gc.weightx = 0.2;
        gc.weighty = 1.0;
        gc.gridx = 0;
        gc.anchor = 10;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.textPanel, gc);
        gc.weightx = 3.0;
        gc.weighty = 2.0;
        gc.gridx = 1;
        gc.anchor = 10;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.tablePanelOutput, gc);
        this.formPanel.setFormListener(new FormListener(){

            @Override
            public void formEventOccurred(FormEvent e) {
                block93: {
                    String absoluteProgramPath;
                    String programName;
                    String inputFileName;
                    String absoluteFilePath;
                    String workingDirectory;
                    if (e.isInputFileChanged()) {
                        MainFrame.this.tablePanelInput.clearData();
                        workingDirectory = System.getProperty("user.dir");
                        String filename = e.getInputFile();
                        absoluteFilePath = "";
                        absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "input_data" + File.separator + filename;
                        System.out.println("Final filepath : " + absoluteFilePath);
                        MainFrame.this.controller.loadFromFile(new File(absoluteFilePath));
                        MainFrame.this.tablePanelInput.refreshData();
                    }
                    if (e.isdoItForMeClicked()) {
                        Throwable throwable;
                        PrintWriter writer;
                        workingDirectory = System.getProperty("user.dir");
                        inputFileName = e.getInputFile();
                        absoluteFilePath = "";
                        absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "input_data" + File.separator + inputFileName;
                        System.out.println("Final filepath : " + absoluteFilePath);
                        MainFrame.this.controller.saveToFile(new File(absoluteFilePath));
                        String absoluteProgramPath2 = "";
                        String programName2 = "";
                        programName2 = "";
                        absoluteProgramPath2 = "";
                        if (System.getProperty("os.name").toUpperCase().indexOf("WIN") >= 0) {
                            programName2 = "run_hard_work.cmd";
                            absoluteProgramPath2 = workingDirectory + File.separator + "kernel" + File.separator + programName2;
                            System.out.println("Final filepath : " + absoluteProgramPath2);
                            try {
                                writer = new PrintWriter(absoluteProgramPath2, "UTF-8");
                                throwable = null;
                                try {
                                    writer.print("hard_work " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                    System.out.println("hard_work " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (writer != null) {
                                        if (throwable != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                        } else {
                                            writer.close();
                                        }
                                    }
                                }
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException ev) {
                                ev.printStackTrace();
                            }
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("NUX") >= 0) {
                            programName2 = "run_hard_work.sh";
                            absoluteProgramPath2 = workingDirectory + File.separator + "kernel" + File.separator + programName2;
                            System.out.println("Final filepath : " + absoluteProgramPath2);
                            try {
                                writer = new PrintWriter(absoluteProgramPath2, "UTF-8");
                                throwable = null;
                                try {
                                    writer.print("./hard_work " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                    System.out.println("./hard_work " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                }
                                catch (Throwable throwable4) {
                                    throwable = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (writer != null) {
                                        if (throwable != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            writer.close();
                                        }
                                    }
                                }
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException ev) {
                                ev.printStackTrace();
                            }
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
                            // empty if block
                        }
                        ProcessBuilder pb = new ProcessBuilder(absoluteProgramPath2);
                        pb.directory(new File(workingDirectory + "/kernel"));
                        if (MainFrame.this.textPanel.getExperimentSpectrum() != null) {
                            try {
                                MainFrame.this.textPanel.clear();
                                MainFrame.this.setCursor(hourglassCursor);
                                Process process = pb.start();
                                System.out.println("Program HARD_WORK started");
                                InputStream is = process.getInputStream();
                                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                                String aux = br.readLine();
                                while (aux != null) {
                                    System.out.println(aux);
                                    aux = br.readLine();
                                }
                                int result = process.waitFor();
                                if (result == 0) {
                                    MainFrame.this.setCursor(normalCursor);
                                    MainFrame.this.textPanel.appendText("SPECTRUM: \n" + MainFrame.this.textPanel.getExperimentSpectrum() + "\n*****************************************\n");
                                    MainFrame.this.textPanel.loadLogFileKernel();
                                    MainFrame.this.textPanel.loadLogFileAvg();
                                    MainFrame.this.tablePanelOutput.clearResults();
                                    String resultFileName = "percentage.txt";
                                    absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "results" + File.separator + resultFileName;
                                    System.out.println("Final filepath : " + absoluteFilePath);
                                    MainFrame.this.controller.loadResultsFromFile(new File(absoluteFilePath));
                                    MainFrame.this.tablePanelOutput.refreshResults();
                                    MainFrame.this.tablePanelInput.clearData();
                                    String filename = e.getInputFile();
                                    absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "input_data" + File.separator + filename;
                                    System.out.println("Final filepath : " + absoluteFilePath);
                                    MainFrame.this.controller.loadFromFile(new File(absoluteFilePath));
                                    MainFrame.this.tablePanelInput.refreshData();
                                    break block93;
                                }
                                JOptionPane.showMessageDialog(new JFrame(), "An error occured during task solving. Look into 'logFileKernel.txt' and logFileAvg.txt for more details.", "Result", 0);
                                System.out.println("An error occured during task solving");
                                MainFrame.this.setCursor(normalCursor);
                            }
                            catch (IOException | InterruptedException e1) {
                                e1.printStackTrace();
                            }
                        } else {
                            JOptionPane.showMessageDialog(new JFrame(), "Choose spectrum first: FILE -> Load Spectrum", "Warning", 0);
                            System.out.println("An error occured during task solving");
                        }
                    } else if (e.isStartClicked()) {
                        Throwable e1;
                        PrintWriter writer;
                        workingDirectory = System.getProperty("user.dir");
                        inputFileName = e.getInputFile();
                        absoluteFilePath = "";
                        absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "input_data" + File.separator + inputFileName;
                        System.out.println("Final filepath : " + absoluteFilePath);
                        MainFrame.this.controller.saveToFile(new File(absoluteFilePath));
                        String programName3 = "";
                        String absoluteProgramPath3 = "";
                        if (System.getProperty("os.name").toUpperCase().indexOf("WIN") >= 0) {
                            programName3 = "run.cmd";
                            absoluteProgramPath3 = workingDirectory + File.separator + "kernel" + File.separator + programName3;
                            System.out.println("Final filepath : " + absoluteProgramPath3);
                            try {
                                writer = new PrintWriter(absoluteProgramPath3, "UTF-8");
                                e1 = null;
                                try {
                                    writer.print("smog " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                    System.out.println("smog " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                }
                                catch (Throwable is) {
                                    e1 = is;
                                    throw is;
                                }
                                finally {
                                    if (writer != null) {
                                        if (e1 != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable is) {
                                                e1.addSuppressed(is);
                                            }
                                        } else {
                                            writer.close();
                                        }
                                    }
                                }
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException ev) {
                                ev.printStackTrace();
                            }
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("NUX") >= 0) {
                            programName3 = "run.sh";
                            absoluteProgramPath3 = workingDirectory + File.separator + "kernel" + File.separator + programName3;
                            System.out.println("Final filepath : " + absoluteProgramPath3);
                            try {
                                writer = new PrintWriter(absoluteProgramPath3, "UTF-8");
                                e1 = null;
                                try {
                                    writer.print("./smog " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                    System.out.println("./smog " + e.getMinLambda() + " " + e.getMaxLambda() + " " + e.getDeltaLambda() + " " + e.getInputFile() + " " + MainFrame.this.textPanel.getExperimentSpectrum());
                                }
                                catch (Throwable is) {
                                    e1 = is;
                                    throw is;
                                }
                                finally {
                                    if (writer != null) {
                                        if (e1 != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable is) {
                                                e1.addSuppressed(is);
                                            }
                                        } else {
                                            writer.close();
                                        }
                                    }
                                }
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException ev) {
                                ev.printStackTrace();
                            }
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
                            // empty if block
                        }
                        ProcessBuilder pb = new ProcessBuilder(absoluteProgramPath3);
                        pb.directory(new File(workingDirectory + "/kernel"));
                        if (MainFrame.this.textPanel.getExperimentSpectrum() != null) {
                            try {
                                MainFrame.this.setCursor(hourglassCursor);
                                Process process = pb.start();
                                System.out.println("Program SMOG started");
                                int result = process.waitFor();
                                if (result == 0) {
                                    MainFrame.this.setCursor(normalCursor);
                                    MainFrame.this.textPanel.clear();
                                    MainFrame.this.textPanel.appendText("SPECTRUM: \n" + MainFrame.this.textPanel.getExperimentSpectrum() + "\n*****************************************\n");
                                    MainFrame.this.textPanel.loadLogFileKernel();
                                    MainFrame.this.textPanel.loadLogFileAvg();
                                    MainFrame.this.tablePanelOutput.clearResults();
                                    String resultFileName = "percentage.txt";
                                    absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "results" + File.separator + resultFileName;
                                    System.out.println("Final filepath : " + absoluteFilePath);
                                    MainFrame.this.controller.loadResultsFromFile(new File(absoluteFilePath));
                                    MainFrame.this.tablePanelOutput.refreshResults();
                                    break block93;
                                }
                                JOptionPane.showMessageDialog(new JFrame(), "An error occured during task solving. Look into 'logFileKernel.txt' and logFileAvg.txt for more details.", "Result", 0);
                                System.out.println("An error occured during task solving");
                            }
                            catch (IOException | InterruptedException e12) {
                                e12.printStackTrace();
                            }
                        } else {
                            JOptionPane.showMessageDialog(new JFrame(), "Choose spectrum first: FILE -> Load Spectrum", "Warning", 0);
                            System.out.println("An error occured during task solving");
                        }
                    } else if (e.isShowGraphClicked()) {
                        workingDirectory = System.getProperty("user.dir");
                        programName = "";
                        absoluteProgramPath = "";
                        if (System.getProperty("os.name").toUpperCase().indexOf("WIN") >= 0) {
                            programName = "open_graph.cmd";
                            absoluteProgramPath = workingDirectory + File.separator + "kernel" + File.separator + programName;
                            System.out.println("Final filepath : " + absoluteProgramPath);
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("NUX") >= 0) {
                            programName = "open_graph.sh";
                            absoluteProgramPath = workingDirectory + File.separator + "kernel" + File.separator + programName;
                            System.out.println("Final filepath : " + absoluteProgramPath);
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
                            // empty if block
                        }
                        ProcessBuilder pb = new ProcessBuilder(absoluteProgramPath);
                        pb.directory(new File(workingDirectory + "/kernel"));
                        try {
                            Process absoluteProgramPath3 = pb.start();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else if (e.isShowGraphOrigClicked()) {
                        workingDirectory = System.getProperty("user.dir");
                        programName = "";
                        absoluteProgramPath = "";
                        if (System.getProperty("os.name").toUpperCase().indexOf("WIN") >= 0) {
                            programName = "open_original_graph.cmd";
                            absoluteProgramPath = workingDirectory + File.separator + "kernel" + File.separator + programName;
                            System.out.println("Final filepath : " + absoluteProgramPath);
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("NUX") >= 0) {
                            programName = "open_original_graph.sh";
                            absoluteProgramPath = workingDirectory + File.separator + "kernel" + File.separator + programName;
                            System.out.println("Final filepath : " + absoluteProgramPath);
                        }
                        if (System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0) {
                            // empty if block
                        }
                        ProcessBuilder pb = new ProcessBuilder(absoluteProgramPath);
                        pb.directory(new File(workingDirectory + "/kernel"));
                        try {
                            Process e1 = pb.start();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
        this.setMinimumSize(new Dimension(500, 600));
        this.setExtendedState(this.getExtendedState() | 6);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem loadSpectrumItem = new JMenuItem("Load Spectrum ...");
        JMenuItem loadResultsItem = new JMenuItem("Load Results...");
        JMenuItem loadGraphItem = new JMenuItem("Load Graph...");
        JMenuItem exitItem = new JMenuItem("Exit");
        fileMenu.add(loadSpectrumItem);
        fileMenu.addSeparator();
        fileMenu.add(loadResultsItem);
        fileMenu.add(loadGraphItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        JMenu editMenu = new JMenu("Edit");
        JMenuItem clearDataTableItem = new JMenuItem("Clear Database");
        JMenuItem clearResultsTableItem = new JMenuItem("Clear Results");
        JMenuItem clearStatusItem = new JMenuItem("Clear Status");
        editMenu.add(clearDataTableItem);
        editMenu.add(clearResultsTableItem);
        editMenu.addSeparator();
        editMenu.add(clearStatusItem);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem updatesItem = new JMenuItem("Check for Updates");
        JMenuItem aboutItem = new JMenuItem("About");
        helpMenu.add(updatesItem);
        helpMenu.add(aboutItem);
        fileMenu.setMnemonic(70);
        editMenu.setMnemonic(69);
        helpMenu.setMnemonic(72);
        exitItem.setMnemonic(88);
        loadSpectrumItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.configFileChooser.showOpenDialog(MainFrame.this) == 0) {
                    String workingDirectory = System.getProperty("user.dir");
                    String fileName = MainFrame.this.configFileChooser.getSelectedFile().getName();
                    String absoluteFilePath = "";
                    absoluteFilePath = workingDirectory + File.separator + "kernel" + File.separator + "input_data" + File.separator + fileName;
                    System.out.println("Final filepath : " + absoluteFilePath);
                    InputStream is = null;
                    OutputStream os = null;
                    try {
                        int length;
                        is = new FileInputStream(MainFrame.this.configFileChooser.getSelectedFile());
                        MainFrame.this.textPanel.setExperimentSpectrum(MainFrame.this.configFileChooser.getSelectedFile().getName());
                        MainFrame.this.textPanel.clear();
                        MainFrame.this.textPanel.appendText("Loaded spectrum: \n" + MainFrame.this.textPanel.getExperimentSpectrum());
                        os = new FileOutputStream(absoluteFilePath);
                        byte[] buffer = new byte[1024];
                        while ((length = is.read(buffer)) > 0) {
                            os.write(buffer, 0, length);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        try {
                            os.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        });
        loadResultsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.configFileChooser.showOpenDialog(MainFrame.this) == 0) {
                    MainFrame.this.controller.loadResultsFromFile(MainFrame.this.configFileChooser.getSelectedFile());
                    MainFrame.this.tablePanelOutput.refreshResults();
                }
            }
        });
        loadGraphItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.graphFileChooser.showOpenDialog(MainFrame.this) == 0) {
                    JFrame frame = new JFrame();
                    frame.setTitle("Graph");
                    ImageIcon icon = new ImageIcon(String.valueOf(MainFrame.this.graphFileChooser.getSelectedFile()));
                    JLabel label = new JLabel(icon);
                    frame.setExtendedState(MainFrame.this.getExtendedState() | 6);
                    label.setSize(icon.getIconWidth(), icon.getIconHeight());
                    frame.add(label);
                    frame.setDefaultCloseOperation(1);
                    frame.pack();
                    frame.setVisible(true);
                }
            }
        });
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int action = JOptionPane.showConfirmDialog(MainFrame.this, "Do you really want to exit the application?", "Confirm Exit", 2);
                if (action == 0) {
                    System.exit(0);
                }
            }
        });
        clearDataTableItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.tablePanelInput.clearData();
            }
        });
        clearResultsTableItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.tablePanelOutput.clearResults();
            }
        });
        clearStatusItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.textPanel.clear();
            }
        });
        updatesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MainFrame.this, "Your version is: 1.1\nThe latest version is: 1.1", "Update", 1);
            }
        });
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MainFrame.this, "Spectrum Analyzer\nVersion: 1.1\nAuthor: Ondrej Bily\nCopyright \u00a9 2019", "About", 1);
            }
        });
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        loadSpectrumItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        loadResultsItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        loadGraphItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        clearStatusItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        exitItem.setIcon(this.createIcon("/images/Stop16.gif"));
        loadSpectrumItem.setIcon(this.createIcon("/images/Open16.gif"));
        loadResultsItem.setIcon(this.createIcon("/images/Open16.gif"));
        loadGraphItem.setIcon(this.createIcon("/images/Open16.gif"));
        clearStatusItem.setIcon(this.createIcon("/images/Delete16.gif"));
        clearResultsTableItem.setIcon(this.createIcon("/images/Delete16.gif"));
        clearDataTableItem.setIcon(this.createIcon("/images/Delete16.gif"));
        updatesItem.setIcon(this.createIcon("/images/Server16.gif"));
        aboutItem.setIcon(this.createIcon("/images/Information16.gif"));
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private ImageIcon createIcon(String path) {
        URL url = this.getClass().getResource(path);
        if (url == null) {
            System.err.println("Unable to load image: " + path);
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }
}

