/*
 * Decompiled with CFR 0.152.
 */
package gui.form_panel;

import gui.form_panel.FormEvent;
import gui.form_panel.FormListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class FormPanel
extends JPanel {
    private JLabel minLambdaLabel;
    private JLabel maxLambdaLabel;
    private JLabel deltaLambdaLabel;
    private JTextField minLambdaField;
    private JTextField maxLambdaField;
    private JTextField deltaLambdaField;
    private JComboBox database;
    private JButton doItForMeBtn;
    private JButton startBtn;
    private JButton showGraphBtn;
    private JButton showGraphOrigBtn;
    private FormListener formListener;

    public FormPanel() {
        Dimension dim = this.getPreferredSize();
        dim.width = 250;
        this.setPreferredSize(dim);
        this.minLambdaLabel = new JLabel("\u03bb\u2098\u1d62\u2099: ");
        this.maxLambdaLabel = new JLabel("\u03bb\u2098\u2090\u2093: ");
        this.deltaLambdaLabel = new JLabel("\u0394\u03bb: ");
        this.minLambdaField = new JTextField(10);
        this.maxLambdaField = new JTextField(10);
        this.deltaLambdaField = new JTextField(10);
        this.database = new JComboBox();
        DefaultComboBoxModel<String> databaseModel = new DefaultComboBoxModel<String>();
        databaseModel.addElement("list_of_lights_generic.txt");
        databaseModel.addElement("list_of_lights_one.txt");
        databaseModel.addElement("list_of_lights_all.txt");
        databaseModel.addElement("list_of_lights_custom.txt");
        this.database.setModel(databaseModel);
        this.doItForMeBtn = new JButton("Find Optimum");
        this.startBtn = new JButton("Run");
        this.showGraphBtn = new JButton("Plot INT");
        this.showGraphOrigBtn = new JButton("Plot NON");
        this.doItForMeBtn.setMnemonic(68);
        this.startBtn.setMnemonic(82);
        this.showGraphBtn.setMnemonic(65);
        this.showGraphOrigBtn.setMnemonic(83);
        this.doItForMeBtn.setToolTipText("Runs program for every combination of selected lights");
        this.startBtn.setToolTipText("Starts external program that calculates percentage of each light");
        this.showGraphBtn.setToolTipText("Shows comparison graph with both experiment and calculated spectra (integrated)");
        this.showGraphOrigBtn.setToolTipText("Shows comparison graph with both experiment and calculated spectra (non-integrated)");
        this.minLambdaField.setText("400");
        this.maxLambdaField.setText("700");
        this.deltaLambdaField.setText("20");
        this.database.setSelectedIndex(0);
        TitledBorder innerBorder = BorderFactory.createTitledBorder("Set parameters");
        Border outerBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        this.doItForMeBtn.setIcon(this.createIcon("/images/Edit16.gif"));
        this.startBtn.setIcon(this.createIcon("/images/Play16.gif"));
        this.showGraphBtn.setIcon(this.createIcon("/images/Find16.gif"));
        this.showGraphOrigBtn.setIcon(this.createIcon("/images/Find16.gif"));
        this.database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String minLambda = FormPanel.this.minLambdaField.getText();
                String maxLambda = FormPanel.this.maxLambdaField.getText();
                String deltaLambda = FormPanel.this.deltaLambdaField.getText();
                String inputFile = (String)FormPanel.this.database.getSelectedItem();
                System.out.println("inputFile: " + inputFile);
                boolean inputFileChanged = true;
                boolean showLightsClicked = false;
                boolean startClicked = false;
                boolean showGraphClicked = false;
                boolean showGraphOrigClicked = false;
                FormEvent ev = new FormEvent(this, minLambda, maxLambda, deltaLambda, inputFile, inputFileChanged, showLightsClicked, startClicked, showGraphClicked, showGraphOrigClicked);
                if (FormPanel.this.formListener != null) {
                    FormPanel.this.formListener.formEventOccurred(ev);
                }
            }
        });
        this.doItForMeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String minLambda = FormPanel.this.minLambdaField.getText();
                String maxLambda = FormPanel.this.maxLambdaField.getText();
                String deltaLambda = FormPanel.this.deltaLambdaField.getText();
                String inputFile = (String)FormPanel.this.database.getSelectedItem();
                System.out.println("inputFile: " + inputFile);
                boolean inputFileChanged = false;
                boolean doItForMeBtnClicked = true;
                boolean startClicked = false;
                boolean showGraphClicked = false;
                boolean showGraphOrigClicked = false;
                FormEvent ev = new FormEvent(this, minLambda, maxLambda, deltaLambda, inputFile, inputFileChanged, doItForMeBtnClicked, startClicked, showGraphClicked, showGraphOrigClicked);
                if (FormPanel.this.formListener != null) {
                    FormPanel.this.formListener.formEventOccurred(ev);
                }
            }
        });
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String minLambda = FormPanel.this.minLambdaField.getText();
                String maxLambda = FormPanel.this.maxLambdaField.getText();
                String deltaLambda = FormPanel.this.deltaLambdaField.getText();
                String inputFile = (String)FormPanel.this.database.getSelectedItem();
                System.out.println("inputFile: " + inputFile);
                boolean inputFileChanged = false;
                boolean doItForMeBtnClicked = false;
                boolean startClicked = true;
                boolean showGraphClicked = false;
                boolean showGraphOrigClicked = false;
                FormEvent ev = new FormEvent(this, minLambda, maxLambda, deltaLambda, inputFile, inputFileChanged, doItForMeBtnClicked, startClicked, showGraphClicked, showGraphOrigClicked);
                if (FormPanel.this.formListener != null) {
                    FormPanel.this.formListener.formEventOccurred(ev);
                }
            }
        });
        this.showGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String minLambda = FormPanel.this.minLambdaField.getText();
                String maxLambda = FormPanel.this.maxLambdaField.getText();
                String deltaLambda = FormPanel.this.deltaLambdaField.getText();
                String inputFile = (String)FormPanel.this.database.getSelectedItem();
                System.out.println("inputFile: " + inputFile);
                boolean inputFileChanged = false;
                boolean doItForMeBtnClicked = false;
                boolean startClicked = false;
                boolean showGraphClicked = true;
                boolean showGraphOrigClicked = false;
                FormEvent ev = new FormEvent(this, minLambda, maxLambda, deltaLambda, inputFile, inputFileChanged, doItForMeBtnClicked, startClicked, showGraphClicked, showGraphOrigClicked);
                if (FormPanel.this.formListener != null) {
                    FormPanel.this.formListener.formEventOccurred(ev);
                }
            }
        });
        this.showGraphOrigBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String minLambda = FormPanel.this.minLambdaField.getText();
                String maxLambda = FormPanel.this.maxLambdaField.getText();
                String deltaLambda = FormPanel.this.deltaLambdaField.getText();
                String inputFile = (String)FormPanel.this.database.getSelectedItem();
                System.out.println("inputFile: " + inputFile);
                boolean inputFileChanged = false;
                boolean doItForMeBtnClicked = false;
                boolean startClicked = false;
                boolean showGraphClicked = false;
                boolean showGraphOrigClicked = true;
                FormEvent ev = new FormEvent(this, minLambda, maxLambda, deltaLambda, inputFile, inputFileChanged, doItForMeBtnClicked, startClicked, showGraphClicked, showGraphOrigClicked);
                if (FormPanel.this.formListener != null) {
                    FormPanel.this.formListener.formEventOccurred(ev);
                }
            }
        });
        this.layoutComponents();
    }

    private ImageIcon createIcon(String path) {
        URL url = this.getClass().getResource(path);
        if (url == null) {
            System.err.println("Unable to load image: " + path);
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    public void setFormListener(FormListener listener) {
        this.formListener = listener;
    }

    public void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.1;
        gc.gridx = 0;
        gc.anchor = 22;
        gc.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.minLambdaLabel, gc);
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.minLambdaField, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 0.1;
        gc.gridx = 0;
        gc.anchor = 22;
        gc.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.maxLambdaLabel, gc);
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.maxLambdaField, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 0.1;
        gc.gridx = 0;
        gc.anchor = 22;
        gc.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.deltaLambdaLabel, gc);
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.deltaLambdaField, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 0.1;
        gc.gridx = 0;
        gc.insets = new Insets(0, 0, 0, 5);
        gc.anchor = 22;
        this.add((Component)new JLabel("Database: "), gc);
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.database, gc);
        Dimension btnSize = this.doItForMeBtn.getPreferredSize();
        this.doItForMeBtn.setPreferredSize(btnSize);
        this.startBtn.setPreferredSize(btnSize);
        this.showGraphBtn.setPreferredSize(btnSize);
        this.showGraphOrigBtn.setPreferredSize(btnSize);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 0.2;
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.doItForMeBtn, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 0.2;
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.startBtn, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 0.2;
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.showGraphBtn, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 0.2;
        gc.gridx = 1;
        gc.anchor = 21;
        gc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.showGraphOrigBtn, gc);
    }
}

