/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import model.Light;

public class ConfigFile {
    private List<Light> lights = new LinkedList<Light>();

    public List<Light> getLights() {
        return this.lights;
    }

    public void loadFromFile(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                String[] arr = line.split("\t");
                if (arr[1].equals("1")) {
                    this.lights.add(new Light(arr[0], true));
                } else {
                    this.lights.add(new Light(arr[0], false));
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveToFile(File file) {
        try {
            PrintWriter writer = new PrintWriter(file, "UTF-8");
            for (Light light : this.lights) {
                String line;
                if (light.getParticipation().booleanValue()) {
                    line = String.format("%s\t1\n", light.getName());
                    writer.print(line);
                    continue;
                }
                line = String.format("%s\t0\n", light.getName());
                writer.print(line);
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

