/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class Fraktal
extends Frame {
    private Vector baselist = new Vector();
    private Vector fractlist = new Vector();
    private Line actline = new Line(0, 0, 0, 0);
    private boolean start = false;
    private boolean isNotCalculated = true;
    private boolean dontRepaint = false;
    private int reklevel = 8;

    public static void main(String[] stringArray) {
        Fraktal fraktal = new Fraktal();
        fraktal.setLocation(200, 200);
        fraktal.setSize(400, 300);
        fraktal.setVisible(true);
        fraktal.setBackground(Color.white);
    }

    public Fraktal() {
        super("Frakt\u00e1ly");
        this.addWindowListener(new MyWindowListener());
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseMotionListener());
    }

    public void paint(Graphics graphics) {
        if (this.dontRepaint) {
            return;
        }
        graphics.setColor(Color.black);
        if (this.start) {
            if (this.isNotCalculated) {
                this.dontRepaint = true;
                graphics.setColor(Color.blue);
                this.drawRecursive(graphics, (Line)this.baselist.firstElement(), this.reklevel);
                this.dontRepaint = false;
            }
            Enumeration enumeration = this.fractlist.elements();
            while (enumeration.hasMoreElements()) {
                Line line = (Line)enumeration.nextElement();
                graphics.setColor(line.color);
                graphics.drawLine(line.x1, line.y1, line.x2, line.y2);
            }
            this.isNotCalculated = false;
        } else {
            Enumeration enumeration = this.baselist.elements();
            while (enumeration.hasMoreElements()) {
                Line line = (Line)enumeration.nextElement();
                graphics.drawLine(line.x1, line.y1, line.x2, line.y2);
            }
        }
        graphics.drawLine(this.actline.x1, this.actline.y1, this.actline.x2, this.actline.y2);
    }

    private void drawRecursive(Graphics graphics, Line line, int n) {
        if (n <= 0) {
            return;
        }
        line.color = this.getColor(n);
        this.fractlist.addElement(line);
        graphics.drawLine(line.x1, line.y1, line.x2, line.y2);
        Enumeration enumeration = this.baselist.elements();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            Line line2 = (Line)this.baselist.firstElement();
            Line line3 = (Line)enumeration.nextElement();
            double d = line2.x2 - line2.x1;
            double d2 = line2.y2 - line2.y1;
            double d3 = -d2;
            double d4 = d;
            double d5 = line3.x1 - line2.x1;
            double d6 = line3.y1 - line2.y1;
            double d7 = line3.x2 - line2.x2;
            double d8 = line3.y2 - line2.y2;
            double d9 = (d5 * d + d6 * d2) / (d * d + d2 * d2);
            double d10 = (d5 * d3 + d6 * d4) / (d3 * d3 + d4 * d4);
            double d11 = (d7 * d + d8 * d2) / (d * d + d2 * d2);
            double d12 = (d7 * d3 + d8 * d4) / (d3 * d3 + d4 * d4);
            double d13 = line.x2 - line.x1;
            double d14 = line.y2 - line.y1;
            double d15 = -d14;
            double d16 = d13;
            double d17 = d9 * d13 + d10 * d15;
            double d18 = d9 * d14 + d10 * d16;
            double d19 = d11 * d13 + d12 * d15;
            double d20 = d11 * d14 + d12 * d16;
            Line line4 = new Line(0, 0, 0, 0);
            line4.x1 = (int)(d17 + (double)line.x1);
            line4.y1 = (int)(d18 + (double)line.y1);
            line4.x2 = (int)(d19 + (double)line.x2);
            line4.y2 = (int)(d20 + (double)line.y2);
            this.drawRecursive(graphics, line4, n - 1);
        }
    }

    private Color getColor(int n) {
        double d = (double)(this.reklevel - n) / (double)this.reklevel;
        if ((d -= 0.4) < 0.0) {
            d = 0.0;
        }
        Color color = new Color((int)(1.6 * (d *= 255.0)), (int)(d + 100.0), 0);
        return color;
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Fraktal.this.setVisible(false);
            Fraktal.this.dispose();
            System.exit(0);
        }
    }

    class MyMouseMotionListener
    extends MouseMotionAdapter {
        MyMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!Fraktal.this.start) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                ((Fraktal)Fraktal.this).actline.x2 = n;
                ((Fraktal)Fraktal.this).actline.y2 = n2;
                Fraktal.this.repaint();
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (!Fraktal.this.start) {
                    Fraktal.this.start = true;
                    Fraktal.this.repaint();
                } else {
                    Fraktal.this.start = false;
                    Fraktal.this.baselist = new Vector();
                    Fraktal.this.fractlist = new Vector();
                    Fraktal.this.actline = new Line(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getX(), mouseEvent.getY());
                    Fraktal.this.isNotCalculated = true;
                    Fraktal.this.repaint();
                }
            } else {
                Fraktal.this.actline = new Line(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (((Fraktal)Fraktal.this).actline.x1 != ((Fraktal)Fraktal.this).actline.x2 | ((Fraktal)Fraktal.this).actline.y1 != ((Fraktal)Fraktal.this).actline.y2) {
                Fraktal.this.baselist.addElement(Fraktal.this.actline);
            }
        }
    }

    public class Line {
        public int x1;
        public int y1;
        public int x2;
        public int y2;
        public Color color;

        Line(int n, int n2, int n3, int n4) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
        }
    }
}

