/* TestPohybuMysi.java */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class Fraktal extends Frame
{
  public class Line{
	public int x1,y1,x2,y2;
	public Color color;
	Line(int x1, int y1, int x2, int y2){
		this.x1=x1;
		this.y1=y1;
		this.x2=x2;
		this.y2=y2;
	}
  }	  
	
  private Vector baselist;		// zoznam nakreslenych objektov
  private Vector fractlist;		// zoznam nakreslenych objektov fraktalu
  private Line actline;	// suradnice (!) ciary
  private boolean start=false; //koniec inicializacie fraktalu, nasleduje rekurzivne vykreslovanie
  private boolean isNotCalculated=true; // zatial sa fraktal nevypocital
  private boolean dontRepaint=false; //pocas pocitania fraktalu neprekreslovat!
  private int reklevel=8;

  public static void main(String[] args)
  {
    Fraktal wnd = new Fraktal();
    wnd.setLocation(200,200);
    wnd.setSize(400,300);
    wnd.setVisible(true);
    wnd.setBackground(new Color(240,247,255));
 }

  public Fraktal()
  {
    super("Fraktly");
    baselist = new Vector();			// inicializacia zoznamu
    fractlist = new Vector();			// inicializacia zoznamu
    actline = new Line(0,0,0,0);	// inicializacia suradnic
    addWindowListener(new MyWindowListener());
    addMouseListener(new MyMouseListener());
    addMouseMotionListener(new MyMouseMotionListener());
  }

  public void paint(Graphics g)
  {
   if(dontRepaint) return; //fraktal sa pocita, nesmie sa spustit druhykrat rekurzivny vypocet 
	   
    Line line;	// suradnice, NIE ciara
    Enumeration e;	// pocitadlo v zozname objektov
   g.setColor(Color.black);
   if(start) { //fraktal je uz zadefinovany
	if(isNotCalculated){ 
	dontRepaint=true;
	g.setColor(Color.blue);
	drawRecursive(g,(Line)baselist.firstElement(),reklevel); //vypocitame a priebezne vykreslujeme fraktal
	dontRepaint=false;
	}
 		for (e = fractlist.elements(); e.hasMoreElements(); ) {
			line = (Line)e.nextElement();
			g.setColor(line.color);
			g.drawLine(line.x1, line.y1, line.x2, line.y2);
		}
	isNotCalculated=false; // odteraz uz iba vykreslovat bez vypoctu
   }
   else { //este definujeme fraktal
		// prechod zoznamom objektov, vykreslenie kazdeho objektu
		// trosku nesikovne - prekresluje sa vzdy - blika
		for (e = baselist.elements(); e.hasMoreElements(); ) {
			line = (Line)e.nextElement();
			g.drawLine(line.x1, line.y1, line.x2, line.y2);
		}
	}
	// vykreslenie novej ciary
     g.drawLine(actline.x1,actline.y1,actline.x2,actline.y2);
    }
    
    private void drawRecursive(Graphics g, Line newBase, int level){
	    if(level<=0) return;
	    Enumeration e;
	    newBase.color=getColor(level);
	    fractlist.addElement(newBase);
	    g.drawLine(newBase.x1, newBase.y1, newBase.x2, newBase.y2);

//	    repaint();
	    for(e=baselist.elements(),e.nextElement(); e.hasMoreElements();){
		    Line base0=(Line)baselist.firstElement();
		    
		    Line base=(Line)e.nextElement(); // ??? netreba sa posunut este o jeden dalej?
		    double base0x=base0.x2-base0.x1;
		    double base0y=base0.y2-base0.y1;
		    double base0kx=-base0y; //vektor kolmy na [a,b] je [-b,a]
		    double base0ky=base0x;
		    //suradnice elementu vzoru relativne voci pociatku base0
		    double baseRelx1=base.x1-base0.x1;
		    double baseRely1=base.y1-base0.y1;
		    double baseRelx2=base.x2-base0.x2;
		    double baseRely2=base.y2-base0.y2;
		    //suradnice elementu v suradnicovej sustave base0 (skalovacie koeficienty)
		    double baseScalex1=(baseRelx1*base0x+baseRely1*base0y)/(base0x*base0x+base0y*base0y);
		    double baseScaley1=(baseRelx1*base0kx+baseRely1*base0ky)/(base0kx*base0kx+base0ky*base0ky);
		    double baseScalex2=(baseRelx2*base0x+baseRely2*base0y)/(base0x*base0x+base0y*base0y);
		    double baseScaley2=(baseRelx2*base0kx+baseRely2*base0ky)/(base0kx*base0kx+base0ky*base0ky);
		    //tieto skalovacie koeficienty z dovodu samopodobnosti umoznuju najst suradnice zodpovedajuceho elementu patriaceho k newBase
		    //najprv vektory osi sustavy spojenej s newBase
		    double newBasex=newBase.x2-newBase.x1;
		    double newBasey=newBase.y2-newBase.y1;
		    double newBasekx=-newBasey; //vektor kolmy na [a,b] je [-b,a]
		    double newBaseky=newBasex;
		    //teraz suradnice elementu v tejto sustave
		    double newBaseRelx1=baseScalex1*newBasex+baseScaley1*newBasekx;
		    double newBaseRely1=baseScalex1*newBasey+baseScaley1*newBaseky;
		    double newBaseRelx2=baseScalex2*newBasex+baseScaley2*newBasekx;
		    double newBaseRely2=baseScalex2*newBasey+baseScaley2*newBaseky;
		    //a nakoniec absolutne suradnice
		    Line newElement = new Line(0,0,0,0);
		    newElement.x1=(int)(newBaseRelx1+newBase.x1);
		    newElement.y1=(int)(newBaseRely1+newBase.y1);
		    newElement.x2=(int)(newBaseRelx2+newBase.x2);
		    newElement.y2=(int)(newBaseRely2+newBase.y2);
		    //Uff! Konecne mozeme vyvolat rekurzivne novy subfraktal na mieste noveho elementu
		    drawRecursive(g,newElement,level-1);
		}
	}
	
  private Color getColor(int level){
	  double colorlevel=(double)(reklevel-level)/reklevel;  // jas 0-1
	  colorlevel=colorlevel-0.4;  // prah - preve urovne vsetky bey zvysenia jasu
	  if(colorlevel<0) colorlevel=0.;
//	  colorlevel *= colorlevel;  //uprava gamma stvrtou mocninou cisla <0-1>
//	  colorlevel *= colorlevel;
	  colorlevel *=255;
	  Color color = new Color((int)(1.6*colorlevel),(int)(colorlevel+100),0);
	 return color; 
  }

  class MyMouseListener extends MouseAdapter
  {
    public void mousePressed(MouseEvent event)
    {
     if (event.getClickCount() == 2) { 
	if(start==false){
		start=true;
		repaint();
	}
	else{
		start=false;
		baselist = new Vector();			// inicializacia zoznamu
		fractlist = new Vector();			// inicializacia zoznamu
		actline = new Line(event.getX(),event.getY(),event.getX(),event.getY());	// inicializacia suradnic
		isNotCalculated=true;
		repaint();	
 	}
    }
     else  actline = new Line(event.getX(),event.getY(),event.getX(),event.getY());
    }

    public void mouseReleased(MouseEvent event)
    {
	if((actline.x1!=actline.x2)|(actline.y1!=actline.y2)) //nie bod pri dvojkliku
		baselist.addElement(actline);
//	repaint();
    }
  }

  class MyMouseMotionListener extends MouseMotionAdapter
  {
    public void mouseDragged(MouseEvent event)
    {
	if(start==false){
		int x = event.getX();
		int y = event.getY();
		actline.x2 = x;
		actline.y2 = y;
		repaint();
	}
    }
  }

  class MyWindowListener extends WindowAdapter
  {
    public void windowClosing(WindowEvent event)
    {
      setVisible(false);
      dispose();
      System.exit(0);
    }
  }
}