/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;

public class GrafickyViewer
extends Canvas {
    int sizeY = 500;
    int sizeX = 500;
    double cursorX = 0.0;
    double cursorY = 0.0;
    double rangeX = 0.0;
    double rangeY = 0.0;
    double minX = 0.0;
    double minY = 0.0;
    double maxX = 0.0;
    double maxY = 0.0;
    double originX = 0.0;
    double originY = 0.0;
    Graphics2D g2;
    Prostredie miska;
    boolean isNotPlotted = false;

    GrafickyViewer(String string, Prostredie prostredie) {
        this.miska = prostredie;
        this.sizeX = prostredie.xSize + 100;
        this.sizeY = prostredie.ySize + 100;
        this.setSize(this.sizeX, this.sizeY);
        this.setScale(-50.0, prostredie.xSize + 50, -50.0, prostredie.ySize + 50);
        this.setBackground(Color.white);
    }

    @Override
    public void paint(Graphics graphics) {
        this.g2 = (Graphics2D)graphics;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.plot();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setScale(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d2;
        this.minY = d4;
        this.maxY = d3;
        this.rangeX = this.maxX - this.minX;
        this.rangeY = this.maxY - this.minY;
        this.originX = -this.minX * (double)this.sizeX / this.rangeX;
        this.originY = -this.minY * (double)this.sizeY / this.rangeY;
    }

    public void drawAxis() {
        this.g2.draw(new Line2D.Double(this.originX, 0.0, this.originX, this.sizeY));
        this.g2.draw(new Line2D.Double(0.0, this.originY, this.sizeY, this.originY));
    }

    public void drawGrid() {
        double d;
        this.g2.setColor(Color.cyan);
        for (d = 0.0; d <= (double)this.sizeX; d += 10.0) {
            this.g2.draw(new Line2D.Double(d, 0.0, d, this.sizeY));
        }
        for (d = 0.0; d <= (double)this.sizeY; d += 10.0) {
            this.g2.draw(new Line2D.Double(0.0, d, this.sizeX, d));
        }
    }

    public void moveTo(double d, double d2) {
        this.cursorX = (d - this.minX) * (double)this.sizeX / this.rangeX;
        this.cursorY = (d2 - this.minY) * (double)this.sizeY / this.rangeY;
    }

    public void lineTo(double d, double d2) {
        double d3 = (d - this.minX) * (double)this.sizeX / this.rangeX;
        double d4 = (d2 - this.minY) * (double)this.sizeY / this.rangeY;
        this.g2.draw(new Line2D.Double(this.cursorX, this.cursorY, d3, d4));
        this.cursorX = d3;
        this.cursorY = d4;
    }

    public void drawPoint() {
        this.g2.drawRect((int)this.cursorX, (int)this.cursorY, 1, 1);
    }

    public void setColor(Color color) {
        this.g2.setColor(color);
    }

    public void drawText(String string) {
        this.g2.drawString(string, (float)this.cursorX, (float)this.cursorY);
    }

    public void plot() {
        this.isNotPlotted = true;
        for (int i = 0; i < this.miska.xSize; ++i) {
            for (int j = 0; j < this.miska.ySize; ++j) {
                int n;
                this.moveTo(i, j);
                int n2 = 255 * this.miska.getValue(i, j) / this.miska.levels;
                if (n2 > 255) {
                    n2 = 255;
                }
                if ((n = 0) > 255) {
                    n2 = 255;
                }
                int n3 = 255;
                if (n2 > 255) {
                    n2 = 255;
                }
                this.setColor(new Color(n2, n, n3));
                this.drawPoint();
            }
        }
        this.isNotPlotted = false;
    }
}

