import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*; 
import javax.swing.*; 

// vlastnosti tlacitka

public class GrafickySimulator extends JFrame implements ActionListener
{
  public static void main(String[] args)
  {
    GrafickySimulator okno = new GrafickySimulator();
    okno.setVisible(true);
  }

  boolean stavTlacitka = false;
  Button button1;
  Button button2;
  Button button3;
  Button button4;
  Label label1;
  Label label2;
  Label label3;
  TextField text1;
  TextField text2;
  TextField text3;
 
  GrafickyViewer viewer;
  Prostredie miska;
  TxtSimulator simulator;
  
  Thread th;
  
   
  public GrafickySimulator()
  {
    super("Life Simulator");
    
	// spracovanie udalosti - uzatvorenia okna
	addWindowListener(new WindowClosingAdapter(true));
	  
        // nastavenie parametrov pracovnej plochy
        setSize(550,550);
        getContentPane().setLayout(null);
	  
	// vytvorenie tlacitka na ploche okna
	button1 = new Button("Tlacitko1");
	button1.setBounds(400,40,100,30);
	button1.setLabel("Start");
	getContentPane().add(button1);
	button1.addActionListener(this);
	button1.setActionCommand("Start");

	  // vytvorenie tlacitka na ploche okna
	button2 = new Button("Tlacitko2");
	button2.setBounds(400,140,100,30);
	button2.setLabel("Load");
	getContentPane().add(button2);
	button2.addActionListener(this);
	button2.setActionCommand("Load");

        // vytvorenie tlacitka na ploche okna
	button3 = new Button("Tlacitko3");
	button3.setBounds(400,180,100,30);
	button3.setLabel("Save");
	getContentPane().add(button3);
	button3.addActionListener(this);
	button3.setActionCommand("Save");

       // vytvorenie tlacitka na ploche okna
	button4 = new Button("Tlacitko4");
	button4.setBounds(400,250,100,30);
	button4.setLabel("Reset");
	getContentPane().add(button4);
	button4.addActionListener(this);
	button4.setActionCommand("Reset");

        label1 = new Label("Number of levels:");
	label1.setBounds(50,40,150,20);  
	getContentPane().add(label1);
	  
	text1 = new TextField("1");  //levels default
	text1.setBounds(200,40,50,30);
	getContentPane().add(text1);
	
	label2 = new Label("Low - limit:");
	label2.setBounds(50,80,150,20);  
	getContentPane().add(label2);

        text2 = new TextField("0.1");  //lowDeadLimit default
	text2.setBounds(200,80,50,30);
	getContentPane().add(text2);

	label3 = new Label("High - limit:");
	label3.setBounds(50,120,150,20);  
	getContentPane().add(label3);

        text3 = new TextField("0.4"); //highDeadLimit default
	text3.setBounds(200,120,50,30);
	getContentPane().add(text3);

	miska=new Prostredie(201,201,1,0.1,0.4);  // rozmer okna grafickeho viewera a ostatne parametre
        miska.hodnota[miska.xSize/2][miska.ySize/2]=miska.levels;  //nasada
 	viewer=new GrafickyViewer("Life Simulator", miska);
	viewer.isNotPlotted=true;
	viewer.setBounds(20,200,300,300);
	viewer.setBackground(Color.white);
	getContentPane().add(viewer);
	simulator=new TxtSimulator(miska,viewer);
	
	//graficu simulaciu spustime ako samostatny thread
	th = new Thread(simulator);
	th.start();
	
  }
  
  public void actionPerformed(ActionEvent event){
	  
	String cmd=event.getActionCommand();
	
	// reakcia na stlacenie stlacitka 
	// simulujeme prepinac
	if(cmd.equals("Start")){
		if(stavTlacitka==false){
			button1.setLabel("Stop");
			stavTlacitka=true;
			miska.levels=(new Integer (text1.getText())).intValue();
			miska.lowDeadLimit=(new Double (text2.getText())).doubleValue();
			miska.highDeadLimit=(new Double (text3.getText())).doubleValue();
			simulator.wait=false;
		}
		else{
			button1.setLabel("Start");
			stavTlacitka = false;
			simulator.wait=true;
		}
	}
	
	if(cmd.equals("Load")){
		miska.nacitajStav();
		viewer.repaint();
	}
	
	if(cmd.equals("Save")){
		miska.ulozStav();
	}
	
 	if(cmd.equals("Reset")){
		simulator.wait=true;
		button1.setLabel("Start");
		stavTlacitka = false;
		for(int x=0;x<miska.xSize;x++)
			for(int y=0;y<miska.xSize;y++)
				miska.hodnota[x][y]=0;
		miska.hodnota[miska.xSize/2][miska.ySize/2]=miska.levels;  //nasada
		viewer.repaint();
	}
	
 }
 }

