import java.io.*;
import java.util.*;

public class Prostredie{
	//podmienky rozmnozovania a zaniku; bakterie v pixli sa alebo rozmnozuju, alebo hynu
	public double lowDeadLimit=0.1; //pokles poctu bakterii, ak je malo susedov, 0<= lowDeadLimit <= 9 
	public double highDeadLimit=0.4; //pokles poctu bakterii, ak je privela susedov, 0<= highDeadLimit <= 9 
	//rozmery Petriho misky a farebne rozlisenie (maximalny pocet bakterii v jednom pixli)
	public int xSize=30;
	public int ySize=15;
	public int levels=1; //maximalny pocet bakterii v jednom pixli
	public int [][] hodnota; //matica hodnot
	int [][] novaHodnota; //matica hodnot
	
	//konstruktor
	public Prostredie (int xSize, int ySize, int levels, double lowDeadLimit, double highDeadLimit){
		this.xSize=xSize;
		this.ySize=ySize;
		this.levels=levels;
		this.lowDeadLimit=lowDeadLimit;
		this.highDeadLimit=highDeadLimit;
		hodnota = new int [xSize][ySize];
		novaHodnota = new int [xSize][ySize];
	}
	
	//vrati pocet bakterii v pixli, hodnoty mimo Petriho misky vrati nulu
	public int getValue(int x, int y){
		if(x<0) return 0; if(x>=xSize) return 0;
		if(y<0) return 0; if(y>=ySize) return 0;
		return this.hodnota[x][y];
	}
	
	//vypocita novy pocet buniek v pixlov podla pravidiel pre mnozenie a zanik
	public void urobKrok(){
		//zapamatat  hodnoty
		for(int x=0;x<xSize;x++)
			for(int y=0;y<ySize;y++)
				novaHodnota[x][y]=hodnota[x][y]; 
		//zistit pocet bakterii v klastri 3x3 pixle
		//pre kazdy bod
		for(int x=0;x<xSize;x++)
			for(int y=0;y<ySize;y++){
				int count=0; //pocet bakterii v klastri 3x3 pixle
				for(int i=-1;i<=1;i++)
					for(int j=-1;j<=1;j++)
						count+=getValue(x+i,y+j);
				//mnozenie alebo zanik
				if((count<9*lowDeadLimit*levels)||(count>9*highDeadLimit*levels)) novaHodnota[x][y]--;
				else novaHodnota[x][y]++;
				if(novaHodnota[x][y]<0) novaHodnota[x][y]=0;
				if(novaHodnota[x][y]>levels) novaHodnota[x][y]=levels;
				}
		//aktualizovat  hodnoty
		for(int x=0;x<xSize;x++)
			for(int y=0;y<ySize;y++)
				hodnota[x][y]=novaHodnota[x][y]; 
		
	}
	
	//ulozi stav vypoctu na disk
	public void ulozStav(){
		BufferedWriter subor;
		try{
			//otvorit subor na disku pre zapis, otvorime ho cez buffer - urychli sa cely proces 
			subor=new BufferedWriter(new FileWriter("dump.txt"));
			// write(int) zapise binarne cislo integer; preto trik na konverziu int na text operatorom +
			subor.write(xSize+"\n");
			subor.write(ySize+"\n");
			subor.write(levels+"\n");
			subor.write(lowDeadLimit+"\n");
			subor.write(highDeadLimit+"\n");
			for(int x=0;x<xSize;x++){
				for(int y=0;y<ySize;y++)
					subor.write(getValue(x,y)+"\t");
				subor.newLine();            //ina moznost - subor.write("\n"); 
			}
			//na konci urcite nezabudnut uzavriet subor - tym sa splachne buffer a urobi poriadok na disku!!!!
			subor.close();
		}
		catch(IOException e)
		{
			System.out.println("Neda sa otvorit subor dump.txt pre zapis");
		}
	}

	//nacita stav vypoctu z disku
	public void nacitajStav(){
		BufferedReader subor;
		String s;
		StringTokenizer st;  //vyzaduje java.util.* !!!!
		try{
			//otvorit subor na disku pre citanie, otvorime ho cez buffer, aby sme mohli nacitat cely riadok 
			subor=new BufferedReader(new FileReader("dump.txt"));
			//nacitat riadok
			s=subor.readLine();
			//nacitat integer z riadku, vyuzijeme Wrapper-triedu Integer, ktora ma v sebe vsetky konverzne funkcie
			xSize=(new Integer(s)).intValue(); //chybu formatu cisla osetri NumbverFormaException
			//to iste s ostatnymi 4-mi cislami
			s=subor.readLine();
			ySize=(new Integer(s)).intValue();
			s=subor.readLine();
			levels=(new Integer(s)).intValue();
			s=subor.readLine();
			lowDeadLimit=(new Double(s)).doubleValue();
			s=subor.readLine();
			highDeadLimit=(new Double(s)).doubleValue();
			//a teraz celu maticu
			for(int x=0;x<xSize;x++){
				s=subor.readLine();
				st=new StringTokenizer(s);
				for(int y=0;y<ySize;y++)
					hodnota[x][y]=(new Integer(st.nextToken())).intValue();
			}
			//na konci  nezabudnut uzavriet subor, aj ked pri otvoreni na citanie nic vazne nehrozi
			subor.close();
		}
		catch(IOException e)
		{
			System.out.println("Neda sa otvorit subor dump.txt na citanie");
		}
		catch(NumberFormatException e)
		{
			System.out.println("Chybny format udajov v subore");
		}
	}
}