/* WindowClosingAdapter.java */

import java.awt.*;
import java.awt.event.*;

public class WindowClosingAdapter extends WindowAdapter
{
  private boolean exitSystem;

  /**
   * Vytvorenie adapteru pre zatvorenie okna
   * Ak je exitSystem true, ukonci sa kompletne cely program   
   */
  public WindowClosingAdapter(boolean exitSystem)
  {
    this.exitSystem = exitSystem;
  }
  
  /**
   * Vytvorenie adapteru pre zatvorenie okna
   * Nezatvara okno a neukoncuje program
   */
  public WindowClosingAdapter()
  {
    this(false);
  }
  
  public void windowClosing(WindowEvent event)
  {
    event.getWindow().setVisible(false);
    event.getWindow().dispose();
    if (exitSystem) {
      System.exit(0);
    }
  }
}
