import cv2
import numpy as np
from matplotlib import pyplot as plt

def find_shift(img, obj):

    n_img = img / 255
    height, width = len(img) , len(img[0])

 
    pad_obj = obj / 255

    
    pad_obj = np.pad(pad_obj, ((0,height-len(obj)),(0,width-len(obj[0]))), 'constant')
      
    
    f1 = np.fft.fft2(n_img)
    f2 = np.fft.fft2(pad_obj)

    f_res = np.multiply(f1, np.conj(f2))

    res = np.fft.ifft2(f_res)
    
    idx = np.argmax(np.real(res))

    x, y = idx % width, idx // width

    return y, x
    

dom = cv2.imread('dom.png',0)
okno = cv2.imread('okno.png',0)

print(find_shift(img, obj))


##f = np.fft.fft2(img)
##fshift = np.fft.fftshift(f)
##magnitude_spectrum = 20*np.log(np.abs(fshift))
##
##plt.subplot(121),plt.imshow(img, cmap = 'gray')
##plt.title('Input Image'), plt.xticks([]), plt.yticks([])
##plt.subplot(122),plt.imshow(magnitude_spectrum, cmap = 'gray')
##plt.title('Magnitude Spectrum'), plt.xticks([]), plt.yticks([])
##plt.show()
