/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;

public class GroupVelocity
extends Applet {
    WavePacketCanvas sines;
    TextSlide slideField;
    TextSlide freqField;
    double minVal;
    double maxVal = 2.0;

    public void init() {
        this.setLayout(new BorderLayout(15, 15));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1, 0, 4));
        this.slideField = new TextSlide(this, "Group Velocity: ", this.minVal, this.maxVal);
        panel.add(this.slideField);
        this.freqField = new TextSlide(this, "Frequency: ", 5.0, 25.0);
        panel.add(this.freqField);
        this.add("South", panel);
        this.sines = new WavePacketCanvas();
        this.add("Center", this.sines);
        this.slideField.setValue(0.6);
        this.freqField.setValue(12.0);
        this.validate();
    }

    public void start() {
        this.sines.enable();
    }

    public void stop() {
        this.sines.disable();
    }

    public void changeParam(TextSlide textSlide) {
        if (textSlide == this.slideField) {
            this.sines.setVelocity(this.slideField.getValue());
            return;
        }
        if (textSlide == this.freqField) {
            this.sines.setFrequency(this.freqField.getValue());
        }
    }

    public void paint(Graphics graphics) {
    }

    public static void main(String[] stringArray) {
        GroupVelocity groupVelocity = new GroupVelocity();
        Frame frame = new Frame("GroupVelocity");
        frame.add("Center", groupVelocity);
        frame.resize(500, 300);
        ((Component)frame).setBackground(Color.lightGray);
        frame.show();
        ((Applet)groupVelocity).init();
        ((Applet)groupVelocity).start();
    }
}

