/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;

public class TextSlide
extends Panel {
    TextField textField;
    Scrollbar slider;
    GroupVelocity owner;
    double theVal;
    int scrollmin;
    int scrollmax = 1000;
    double minVal;
    double maxVal = 5.0;

    TextSlide(GroupVelocity groupVelocity, String string, double d, double d2) {
        this.owner = groupVelocity;
        this.minVal = d;
        this.maxVal = d2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        Label label = new Label(string);
        this.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        this.textField = new TextField("0.6", 10);
        this.add(this.textField);
        gridBagLayout.setConstraints(this.textField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        this.slider = new Scrollbar(0, 1, 100, this.scrollmin, this.scrollmax);
        this.add(this.slider);
        gridBagLayout.setConstraints(this.slider, gridBagConstraints);
        this.setValue(0.6);
        this.validate();
    }

    public boolean action(Event event, Object object) {
        double d;
        if (event.target == this.textField && (d = this.getTextValue()) >= this.minVal) {
            this.theVal = d;
            this.setSliderValue(d);
            this.owner.changeParam(this);
        }
        return true;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.slider) {
            double d;
            this.theVal = d = this.getSliderValue();
            this.setTextValue(d);
            this.owner.changeParam(this);
        }
        return super.handleEvent(event);
    }

    public void setValue(double d) {
        if (d < this.minVal) {
            d = this.minVal;
        } else if (d > this.maxVal) {
            d = this.maxVal;
        }
        this.theVal = d;
        this.setTextValue(d);
        this.setSliderValue(d);
    }

    public double getValue() {
        return this.theVal;
    }

    private void setSliderValue(double d) {
        this.slider.setValue((int)((double)this.scrollmin + (d - this.minVal) / (this.maxVal - this.minVal) * (double)(this.scrollmax - this.scrollmin)));
    }

    private double getTextValue() {
        double d;
        try {
            d = Double.valueOf(this.textField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d = this.minVal - 1.0;
        }
        if (d > this.maxVal) {
            d = this.maxVal;
            this.setTextValue(d);
        } else if (d < this.minVal) {
            d = this.minVal;
            this.setTextValue(d);
        }
        return d;
    }

    private void setTextValue(double d) {
        ((TextComponent)this.textField).setText(String.valueOf(Math.rint(d * 1000000.0) / 1000000.0));
    }

    private double getSliderValue() {
        int n = this.slider.getValue() - this.scrollmin;
        double d = this.minVal + (this.maxVal - this.minVal) * (double)n / (double)(this.scrollmax - this.scrollmin);
        return d;
    }
}

