/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class WavePacket {
    int height;
    int width;
    double frequency;
    double velocity;
    double timestep;
    double x1;
    private final double delta_t = 3.0;

    public WavePacket(int n, int n2, double d, double d2) {
        this.height = n;
        this.width = n2;
        this.frequency = d;
        this.velocity = d2;
    }

    public WavePacket(int n, int n2) {
        this(n, n2, 12.0, 1.0);
    }

    public void compute() {
        this.timestep += 3.0;
        if (this.timestep > 10000.0) {
            double d = this.frequency * this.timestep / (double)this.width;
            double d2 = (double)this.width / this.frequency * (d - Math.floor(d));
            d = this.frequency * (this.velocity * this.timestep - this.x1) / (10.0 * (double)this.width);
            this.x1 = -(d - Math.floor(d)) * 10.0 * (double)this.width / this.frequency + this.velocity * d2;
            this.timestep = d2;
        }
    }

    public void compute(double d) {
        this.timestep += d;
    }

    public void setSize(int n, int n2) {
        this.height = n2;
        this.width = n;
    }

    public void setVelocity(double d) {
        this.x1 += (d - this.velocity) * this.timestep;
        this.velocity = d;
    }

    public void setFrequency(double d) {
        this.frequency = d;
    }

    public void draw(Graphics graphics) {
        int n = this.height;
        int n2 = this.width;
        double d = this.velocity;
        double d2 = (double)n * 0.45;
        double d3 = this.frequency;
        double d4 = this.timestep;
        double d5 = this.x1;
        int n3 = 0;
        double d6 = Math.PI * 2 * d3 / (double)n2;
        double d7 = 75.39822368615503 / (double)n2;
        int n4 = (int)((double)n * 0.5 - d2 * Math.sin(d6 * ((double)n3 - d4)) * Math.sin(d7 * ((double)n3 - d * d4 + d5) / 10.0));
        graphics.setColor(Color.red);
        int n5 = 0;
        while (n5 < n2) {
            int n6 = (int)((double)(n / 2) - d2 * Math.sin(d6 * ((double)n5 - d4)) * Math.sin(d7 * ((double)n5 - d * d4 + d5) / 10.0));
            graphics.drawLine(n3, n4, n5, n6);
            n3 = n5++;
            n4 = n6;
        }
    }
}

