/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class WavePacketCanvas
extends Canvas
implements Runnable {
    Image offscreen;
    WavePacket curve = new WavePacket(this.imagewidth, this.imageheight, 12.0, 2.0);
    int imagewidth = 200;
    int imageheight = 100;
    Thread animator;
    boolean please_stop = false;
    long startTime;

    WavePacketCanvas() {
    }

    public void setVelocity(double d) {
        this.curve.setVelocity(d);
    }

    public void setFrequency(double d) {
        this.curve.setFrequency(d);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(150, 50);
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(150, 50);
        return dimension;
    }

    public void enable() {
        super.enable();
        this.animator = new Thread(this);
        this.animator.start();
        this.repaint();
    }

    public void disable() {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.animator = null;
        super.disable();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (this.offscreen != null) {
            graphics = this.getGraphics();
            graphics.drawImage(this.offscreen, 0, 0, this);
            return;
        }
        graphics.clearRect(0, 0, this.imagewidth, this.imageheight);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.target == this) {
            this.toggle();
        }
        return true;
    }

    public void toggle() {
        if (this.animator != null) {
            this.please_stop = true;
            return;
        }
        this.please_stop = false;
        this.enable();
    }

    public void run() {
        while (!this.please_stop) {
            this.startTime = System.currentTimeMillis() + 100L;
            Dimension dimension = this.size();
            if (this.offscreen == null || this.imagewidth != dimension.width || this.imageheight != dimension.height) {
                if (dimension.width > 1 && dimension.height > 1) {
                    this.imagewidth = dimension.width;
                    this.imageheight = dimension.height;
                }
                this.offscreen = this.createImage(this.imagewidth, this.imageheight);
                this.curve.setSize(this.imagewidth, this.imageheight);
            }
            this.curve.compute();
            Graphics graphics = this.offscreen.getGraphics();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
            this.curve.draw(graphics);
            this.repaint();
            try {
                Thread.sleep(Math.max(0L, this.startTime - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {}
        }
        this.animator = null;
    }
}

