/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RefractorAP
extends AP6
implements MouseMotionListener {
    static final String[][] text = new String[][]{{"de", "Keplersches Fernrohr", "Brennweiten:", "Objektiv:", "Okular:", "Sehwinkel:", "Vergr\u00f6\u00dferung:", ""}, {"en", "Refracting Astronomical Telescope", "Focal lengths:", "Objective:", "Eyepiece:", "Angles:", "Magnification:", ""}};
    private int[] gaps = new int[]{20, 5, 5, 20, 5, 5, 20, 80, 5, 20};
    final int width = 720;
    final int height = 400;
    final int width0 = 500;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JTextField tfF1;
    JTextField tfF2;
    JLabel lbAng1;
    JLabel lbAng2;
    JLabel lbMag;
    Color bgCanvas;
    Color bgPanel;
    Color color1;
    Color color2;
    Color colorLens;
    Color colorLight;
    Color colorStars;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    final int yM = 130;
    final int PIX = 250;
    final double n = 1.6;
    final int nP = 20;
    final double[][] pleiades = new double[][]{{11.0, 3.1}, {4.0, 2.7}, {2.0, 4.6}, {6.0, 0.2}, {6.0, 1.2}, {8.0, 1.0}};
    double xL1;
    double xL2;
    double f1;
    double f2;
    double a1;
    double a2;
    double b1;
    double b2;
    double m0;
    double m2;
    double ang1;
    double ang2;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(720, 400);
    }

    @Override
    protected void initAttributes() {
        this.f1 = 0.5;
        this.f2 = 0.1;
        this.calculation1();
        this.m0 = Math.tan(0.06981317007977318);
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.color1 = this.getColor(Color.blue, "color1");
        this.color2 = this.getColor(Color.green, "color2");
        this.colorLens = this.getColor(Color.cyan, "colorLens");
        this.colorLight = this.getColor(Color.red, "colorLight");
        this.colorStars = this.getColor(Color.yellow, "colorStars");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.coauthor = this.getText(t[7], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 500, 400);
        this.add(this.cv);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(500, 0, 220, 400);
        this.pan.add(this.text01);
        this.tfF1 = this.pan.newInputField(this.text02, this.meter, this.bgPanel, Color.black, 3);
        this.tfF1.setText(this.toString(this.f1, 2));
        this.tfF2 = this.pan.newInputField(this.text03, this.meter, this.bgPanel, Color.black, 3);
        this.tfF2.setText(this.toString(this.f2, 2));
        this.pan.add(this.text04);
        this.lbAng1 = this.pan.newOutputField(this.text02, this.degree, this.bgPanel, Color.black, 3);
        this.lbAng2 = this.pan.newOutputField(this.text03, this.degree, this.bgPanel, Color.black, 3);
        this.lbMag = this.pan.newOutputField(this.text05, "", this.bgPanel, Color.black, 3);
        this.pan.add(2000);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.calculation2();
    }

    @Override
    public void run() {
    }

    void calculation1() {
        double l2 = 125.0 * (this.f1 + this.f2);
        this.xL1 = 250.0 - l2;
        this.xL2 = 250.0 + l2;
        double r1 = 1.2000000000000002 * this.f1 * 250.0;
        double r2 = 1.2000000000000002 * this.f2 * 250.0;
        double limit = 125.0;
        this.b1 = 0.6 * r1;
        if (this.b1 > limit) {
            this.b1 = limit;
        }
        this.b2 = 0.6 * r2;
        if (this.b2 > limit) {
            this.b2 = limit;
        }
        this.a1 = r1 - Math.sqrt(r1 * r1 - this.b1 * this.b1);
        this.a2 = r2 - Math.sqrt(r2 * r2 - this.b2 * this.b2);
    }

    void calculation2() {
        double limit = 0.9 * this.b2 / ((this.f1 + this.f2) * 250.0);
        if (this.m0 > limit) {
            this.m0 = limit;
        } else if (this.m0 < -limit) {
            this.m0 = -limit;
        }
        this.ang1 = Math.atan(this.m0);
        this.m2 = -this.m0 * this.f1 / this.f2;
        this.ang2 = Math.atan(this.m2);
        this.lbAng1.setText(this.toString(this.ang1 / (Math.PI / 180), 1));
        this.lbAng2.setText(this.toString(this.ang2 / (Math.PI / 180), 1));
        if (this.ang1 != 0.0) {
            this.lbMag.setText(this.toString2(this.ang2 / this.ang1, 2, 1.0E-6));
        } else {
            this.lbMag.setText("---");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.f1 = this.inputTF(this.tfF1, 0.05, 0.5, 2);
        this.f2 = this.inputTF(this.tfF2, 0.05, 0.5, 2);
        this.calculation1();
        this.calculation2();
        this.cv.repaint();
        this.pan.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if ((double)x == this.xL1) {
            return;
        }
        this.m0 = Math.atan((double)(y - 130) / (this.xL1 - (double)x));
        this.calculation2();
        this.cv.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, RefractorAP.this.bgCanvas);
            RefractorAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void lens(Graphics2D g, double x, double a, double b) {
            double r = (a * a + b * b) / (2.0 * a);
            double r2 = 2.0 * r;
            double phi = Math.asin(b / r);
            double w = phi / (Math.PI / 180);
            Path2D.Double p = new Path2D.Double();
            Arc2D.Double arcL = new Arc2D.Double(x - r2 + a, 130.0 - r, r2, r2, -w, 2.0 * w, 1);
            p.append(arcL, true);
            Arc2D.Double arcR = new Arc2D.Double(x - a, 130.0 - r, r2, r2, 180.0 - w, 2.0 * w, 1);
            p.append(arcR, true);
            g.setColor(RefractorAP.this.colorLens);
            g.fill(p);
            g.setColor(Color.black);
            g.draw(p);
        }

        void ray(Graphics2D g, double t1) {
            double dx = RefractorAP.this.xL1 - 20.0;
            double x0 = RefractorAP.this.xL1 - dx;
            double y0 = 130.0 - t1 + RefractorAP.this.m0 * dx;
            double x1 = RefractorAP.this.xL1;
            double y1 = 130.0 - t1;
            double m1 = (RefractorAP.this.m0 * RefractorAP.this.f1 * 250.0 - t1) / (RefractorAP.this.f1 * 250.0);
            double x2 = RefractorAP.this.xL2;
            double t2 = t1 + m1 * (RefractorAP.this.xL2 - RefractorAP.this.xL1);
            if (Math.abs(t2) >= RefractorAP.this.b2) {
                return;
            }
            double y2 = 130.0 - t2;
            double x3 = RefractorAP.this.xL2 + dx;
            double y3 = 130.0 - t2 - RefractorAP.this.m2 * dx;
            CanvasAP.line(g, x0, y0, x1, y1);
            CanvasAP.line(g, x1, y1, x2, y2);
            CanvasAP.line(g, x2, y2, x3, y3);
        }

        void ray1(Graphics2D g) {
            double dx = RefractorAP.this.xL1 - 20.0;
            CanvasAP.line(g, RefractorAP.this.xL1 - dx, 130.0 + RefractorAP.this.m0 * dx, RefractorAP.this.xL1, 130.0);
        }

        void ray2(Graphics2D g) {
            double sin = Math.sin(RefractorAP.this.ang2);
            double cos = Math.cos(RefractorAP.this.ang2);
            for (int i = -10; i < 10; ++i) {
                double x0 = RefractorAP.this.xL2 - (double)(i * 10) * cos;
                double y0 = 130.0 + (double)(i * 10) * sin;
                double x1 = RefractorAP.this.xL2 - ((double)i + 0.6) * 10.0 * cos;
                double y1 = 130.0 + ((double)i + 0.6) * 10.0 * sin;
                CanvasAP.line(g, x0, y0, x1, y1);
            }
        }

        void f1f2(Graphics2D g) {
            double xx = RefractorAP.this.xL1 + 250.0 * RefractorAP.this.f1;
            CanvasAP.arrow(g, xx, 30.0, RefractorAP.this.xL1, 30.0);
            CanvasAP.arrow(g, RefractorAP.this.xL1, 30.0, xx, 30.0);
            CanvasAP.arrow(g, xx, 30.0, RefractorAP.this.xL2, 30.0);
            CanvasAP.arrow(g, RefractorAP.this.xL2, 30.0, xx, 30.0);
            int dxF = RefractorAP.this.fmH.stringWidth("f");
            int dx1 = RefractorAP.this.fmH.stringWidth("1");
            int dx2 = RefractorAP.this.fmH.stringWidth("2");
            int x0 = (int)(RefractorAP.this.xL1 + 250.0 * RefractorAP.this.f1 / 2.0) - (dxF + dx1) / 2;
            g.drawString("f", x0, 44);
            g.drawString("1", x0 + dxF, 50);
            x0 = (int)(RefractorAP.this.xL2 - 250.0 * RefractorAP.this.f2 / 2.0) - (dxF + dx2) / 2;
            g.drawString("f", x0, 44);
            g.drawString("2", x0 + dxF, 50);
        }

        void stars(Graphics2D g, int x, int y, double m) {
            CanvasAP.circle(g, x, y, 60.0, Color.black);
            for (int i = 0; i < RefractorAP.this.pleiades.length; ++i) {
                double r = RefractorAP.this.pleiades[i][0];
                double phi = RefractorAP.this.pleiades[i][1];
                double xS = (double)x + m * r * Math.cos(phi);
                double yS = (double)y - m * r * Math.sin(phi);
                CanvasAP.circle(g, xS, yS, 1.5, RefractorAP.this.colorStars);
            }
        }

        @Override
        public void paint(Graphics g) {
            int i;
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            this.lens(g2, RefractorAP.this.xL1, RefractorAP.this.a1, RefractorAP.this.b1);
            this.lens(g2, RefractorAP.this.xL2, RefractorAP.this.a2, RefractorAP.this.b2);
            double a = Math.abs(RefractorAP.this.ang1);
            double a0 = RefractorAP.this.ang1 >= 0.0 ? Math.PI : Math.PI - a;
            CanvasAP.angle(g2, RefractorAP.this.xL1, 130.0, 40.0, a0, a, RefractorAP.this.color1);
            a = Math.abs(RefractorAP.this.ang2);
            a0 = RefractorAP.this.ang2 >= 0.0 ? Math.PI : Math.PI - a;
            CanvasAP.angle(g2, RefractorAP.this.xL2, 130.0, 40.0, a0, a, RefractorAP.this.color2);
            g.setColor(Color.black);
            CanvasAP.line(g2, 20.0, 130.0, 480.0, 130.0);
            for (i = -10; i <= 10; ++i) {
                int y1 = 130 - i * 10 - 3;
                int y2 = y1 + 6;
                CanvasAP.line(g2, RefractorAP.this.xL1, y1, RefractorAP.this.xL1, y2);
                CanvasAP.line(g2, RefractorAP.this.xL2, y1, RefractorAP.this.xL2, y2);
            }
            g.setColor(RefractorAP.this.colorLight);
            for (i = -3; i <= 3; ++i) {
                this.ray(g2, (double)i * RefractorAP.this.b1 / 4.0);
            }
            g.setColor(Color.black);
            this.ray1(g2);
            this.ray2(g2);
            this.f1f2(g2);
            this.stars(g2, 100, 300, 1.0);
            this.stars(g2, 400, 300, -RefractorAP.this.f1 / RefractorAP.this.f2);
        }
    }
}

