/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class BohrModelAP
extends AP6
implements MouseListener,
MouseMotionListener {
    static final String[][] text = new String[][]{{"de", "Bohrsches Modell des Wasserstoffatoms", "Teilchenbild", "Wellenbild", "Hauptquantenzahl:", ""}, {"en", "Bohr's Model of the Hydogen Atom", "Particle model", "Wave model", "Principal quantum number:", ""}};
    private int[] gaps = new int[]{20, 10, 20, 10, 100, 10, 20};
    final int width = 700;
    final int height = 400;
    final int width0 = 500;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JRadioButton rbPart;
    JRadioButton rbWave;
    JLabel lbQZ;
    JComboBox coQZ;
    Color bgCanvas;
    Color bgPanel;
    Color colorNucleus;
    Color colorElectron;
    Color colorEmphasize;
    Color colorWavelength;
    String coauthor;
    String text01;
    String text02;
    String text03;
    final double rH = 1.0967758E7;
    final double h = 6.6262E-34;
    final double c = 2.99792458E8;
    final double e = 1.6022E-19;
    final double eps0 = 8.8542E-12;
    final double PI2 = Math.PI * 2;
    final int nMax = 20;
    int xM;
    int yM;
    int xA;
    int yA;
    double pix1;
    double pix2;
    double phi;
    double n;
    double T;
    int rE;
    int model;
    double lambda;
    String mult;
    boolean dragged;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 400);
    }

    @Override
    protected void initAttributes() {
        this.xM = 250;
        this.yM = 200;
        this.xA = 180;
        this.yA = 180;
        this.model = 1;
        this.n = 1.0;
        this.calculation();
        this.rE = (int)this.pix1;
        this.T = 1.0;
        this.lambda = Math.PI * 2;
        this.dragged = false;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorNucleus = this.getColor(Color.red, "colorNucleus");
        this.colorElectron = this.getColor(new Color(0, 128, 0), "colorElectron");
        this.colorEmphasize = this.getColor(Color.magenta, "colorEmphasize");
        this.colorWavelength = this.getColor(Color.blue, "colorWavelength");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.coauthor = this.getText(t[5], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 500, 400);
        this.add(this.cv);
        this.mult = "\u00b7";
        if (this.language.equals("en")) {
            this.mult = "x";
        }
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 1, this.gaps);
        this.pan.setBounds(500, 0, 200, 400);
        ButtonGroup bg = new ButtonGroup();
        this.rbPart = new JRadioButton(this.text01, true);
        bg.add(this.rbPart);
        this.pan.add(this.rbPart, this.bgPanel, Color.black);
        this.rbWave = new JRadioButton(this.text02, false);
        bg.add(this.rbWave);
        this.pan.add(this.rbWave, this.bgPanel, Color.black);
        this.pan.add(this.text03);
        this.coQZ = new JComboBox();
        this.coQZ.addItem("");
        for (int n = 1; n <= 10; ++n) {
            this.coQZ.addItem("  n  =  " + n);
        }
        this.coQZ.setSelectedIndex(1);
        this.pan.add(this.coQZ, Color.white, Color.black);
        this.pan.add(1999);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.rbPart.addActionListener(this);
        this.rbWave.addActionListener(this);
        this.coQZ.addActionListener(this);
        this.cv.addMouseListener(this);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            this.phi += (double)(t1 - t0) / 1000.0 * (Math.PI * 2 / this.T);
            t0 = t1;
        }
    }

    void calculation() {
        if (this.n <= 3.0) {
            this.pix1 = 10.0;
            this.pix2 = 250.0;
        } else if (this.n <= 5.0) {
            this.pix1 = 4.0;
            this.pix2 = 1000.0;
        } else if (this.n <= 7.0) {
            this.pix1 = 2.0;
            this.pix2 = 2400.0;
        } else {
            this.pix1 = 1.0;
            this.pix2 = 4500.0;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.dragged) {
            return;
        }
        int n = this.model = this.rbPart.isSelected() ? 1 : 2;
        if (ae.getSource() == this.coQZ) {
            this.n = this.coQZ.getSelectedIndex();
            if (this.n == 0.0) {
                this.n = 1.0;
                this.coQZ.setSelectedIndex(1);
            }
        }
        this.calculation();
        this.rE = (int)Math.round(this.pix1 * this.n * this.n);
        this.T = this.n * this.n * this.n;
        this.lambda = Math.PI * 2 / this.n;
        this.cv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int dx = me.getX() - this.xA;
        int dy = me.getY() - this.yA;
        this.rE = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        if (this.rE == 0) {
            this.rE = 1;
        }
        this.n = Math.sqrt((double)this.rE / this.pix1);
        this.T = this.n * this.n * this.n;
        this.lambda = Math.PI * 2 / this.n;
        this.dragged = true;
        int nn = (int)this.n;
        this.coQZ.setSelectedIndex((double)nn == this.n && this.n <= 10.0 ? nn : 0);
        this.cv.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.dragged = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, BohrModelAP.this.bgCanvas);
            BohrModelAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void nucleusOrbits(Graphics2D g, boolean cond) {
            CanvasAP.circle(g, BohrModelAP.this.xA, BohrModelAP.this.yA, BohrModelAP.this.pix1 >= 10.0 ? 2.0 : 1.0, BohrModelAP.this.colorNucleus);
            for (int i = 1; i <= 20; ++i) {
                if ((double)i == BohrModelAP.this.n) continue;
                double r = BohrModelAP.this.pix1 * (double)i * (double)i;
                if (r > 160.0) break;
                g.setColor(Color.black);
                String s = "n = " + i;
                if (r >= 10.0 && (double)i != BohrModelAP.this.n) {
                    this.alignText(g, s, this.fH, 1, BohrModelAP.this.xA, (int)((double)BohrModelAP.this.yA - r));
                }
                CanvasAP.circle(g, BohrModelAP.this.xA, BohrModelAP.this.yA, r, Color.black, false);
            }
            Color c = BohrModelAP.this.colorEmphasize;
            if (cond) {
                CanvasAP.circle(g, BohrModelAP.this.xA, BohrModelAP.this.yA, BohrModelAP.this.rE, c, false);
                String s = "n = " + (int)BohrModelAP.this.n;
                this.alignText(g, s, this.fH, 1, BohrModelAP.this.xA, BohrModelAP.this.yA - BohrModelAP.this.rE);
            } else {
                g.setColor(c);
                int w1 = 40;
                if (BohrModelAP.this.rE > 40) {
                    w1 = 20;
                }
                if (BohrModelAP.this.rE > 80) {
                    w1 = 10;
                }
                if (BohrModelAP.this.rE > 160) {
                    w1 = 5;
                }
                int w2 = (int)Math.round((double)w1 * 0.7);
                for (int i = 0; i < 360 / w1; ++i) {
                    CanvasAP.arc(g, BohrModelAP.this.xA, BohrModelAP.this.yA, BohrModelAP.this.rE, (double)(i * w1) * (Math.PI / 180), (double)w2 * (Math.PI / 180));
                }
            }
        }

        void atomPart(Graphics2D g) {
            boolean cond = BohrModelAP.this.n == (double)((int)BohrModelAP.this.n) && BohrModelAP.this.n > 0.0;
            this.nucleusOrbits(g, cond);
            double x = (double)BohrModelAP.this.xA + (double)BohrModelAP.this.rE * Math.cos(BohrModelAP.this.phi);
            double y = (double)BohrModelAP.this.yA - (double)BohrModelAP.this.rE * Math.sin(BohrModelAP.this.phi);
            if (cond) {
                CanvasAP.circle(g, x, y, 2.0, BohrModelAP.this.colorElectron);
            } else {
                CanvasAP.circle(g, x, y, 2.0, BohrModelAP.this.colorElectron, false);
            }
        }

        void atomWave(Graphics2D g) {
            boolean cond = BohrModelAP.this.n == (double)((int)BohrModelAP.this.n);
            this.nucleusOrbits(g, cond);
            g.setColor(BohrModelAP.this.colorElectron);
            double x0 = BohrModelAP.this.xA + BohrModelAP.this.rE;
            double y0 = BohrModelAP.this.yA;
            int i = 0;
            double phi = 0.0;
            while (phi <= Math.PI * 2) {
                phi = (double)(++i) * (Math.PI / 180);
                double rW = (double)BohrModelAP.this.rE + 8.0 * Math.sin(Math.PI * 2 * phi / BohrModelAP.this.lambda);
                double x1 = (double)BohrModelAP.this.xA + rW * Math.cos(phi);
                double y1 = (double)BohrModelAP.this.yA - rW * Math.sin(phi);
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
            g.setColor(BohrModelAP.this.colorWavelength);
            CanvasAP.arc(g, 3.0, BohrModelAP.this.xA, BohrModelAP.this.yA, BohrModelAP.this.rE + 1, 0.0, BohrModelAP.this.lambda);
        }

        void energyLevels(Graphics2D g) {
            double y;
            int x0 = 425;
            int y0 = 20;
            g.setColor(Color.black);
            CanvasAP.line(g, x0 - 35, y0, x0 + 35, y0);
            for (int i = 1; i <= 20; ++i) {
                g.setColor((double)i == BohrModelAP.this.n ? BohrModelAP.this.colorEmphasize : Color.black);
                y = (double)y0 + BohrModelAP.this.pix2 / (double)(i * i);
                String s = "n = " + i;
                if (y >= (double)(y0 + 25) && i <= 10) {
                    this.alignText(g, s, this.fH, 2, x0 - 30, (int)(y + 4.0));
                }
                CanvasAP.line(g, x0 - 25, y, x0 + 25, y);
            }
            int h = BohrModelAP.this.pix2 > 4000.0 ? 19 : (BohrModelAP.this.pix2 > 2000.0 ? 12 : (BohrModelAP.this.pix2 > 1000.0 ? 10 : 5));
            CanvasAP.rectangle(g, x0 - 25, y0, 51.0, h, Color.black);
            y = (double)y0 + BohrModelAP.this.pix2 / (BohrModelAP.this.n * BohrModelAP.this.n);
            if (BohrModelAP.this.n == (double)((int)BohrModelAP.this.n)) {
                CanvasAP.circle(g, x0, y, 2.0, BohrModelAP.this.colorElectron);
            } else {
                CanvasAP.circle(g, x0, y, 2.0, BohrModelAP.this.colorElectron, false);
            }
        }

        void writePower10(Graphics g, String s, double val, int exp, String u, int x, int y, int n) {
            g.setFont(this.fH);
            double power10 = Math.pow(10.0, exp);
            s = s + this.frame.toString(val / power10, n);
            s = s + " " + BohrModelAP.this.mult + " 10";
            int w = BohrModelAP.this.fmH.stringWidth(s);
            g.drawString(s, x, y);
            x += w;
            String e = "" + exp;
            w = BohrModelAP.this.fmH.stringWidth(e);
            g.drawString(e, x, y - 6);
            g.drawString(" " + u, x += w, y);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            if (BohrModelAP.this.model == 1) {
                this.atomPart(g2);
            } else {
                this.atomWave(g2);
            }
            this.energyLevels(g2);
            if (BohrModelAP.this.n != (double)((int)BohrModelAP.this.n)) {
                return;
            }
            g.setColor(Color.black);
            CanvasAP.setAntiAliasing(g2, false);
            double r = 2.5670448400000003E-38 * BohrModelAP.this.n * BohrModelAP.this.n / 4.848331311371743E-28;
            int x = 40;
            int y = 365;
            if (r < 1.0E-10) {
                this.writePower10(g, "r = ", r, -11, BohrModelAP.this.meter, x, y, 2);
            } else if (r < 1.0E-9) {
                this.writePower10(g, "r = ", r, -10, BohrModelAP.this.meter, x, y, 2);
            } else {
                this.writePower10(g, "r = ", r, -9, BohrModelAP.this.meter, x, y, 2);
            }
            double energy = 2.1787284394751194E-18 / (BohrModelAP.this.n * BohrModelAP.this.n);
            x = 378;
            y = 350;
            String s = "E ";
            int w = BohrModelAP.this.fmH.stringWidth(s);
            g.drawString("E", x - w, 350);
            s = "= \u2212";
            if (energy < 1.0E-19) {
                this.writePower10(g, s, energy, -20, BohrModelAP.this.joule, x, y, 1);
            } else if (energy < 1.0E-18) {
                this.writePower10(g, s, energy, -19, BohrModelAP.this.joule, x, y, 2);
            } else {
                this.writePower10(g, s, energy, -18, BohrModelAP.this.joule, x, y, 3);
            }
            s = s + this.frame.toString(energy / 1.6022E-19, 2) + " eV";
            g.drawString(s, 378, 365);
        }
    }
}

