/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollBar;

public class ElectricMotorAP
extends AP6
implements AdjustmentListener {
    String[][] text = new String[][]{{"de", "Elektromotor", "Zur\u00fcck", "Start", "Pause", "Weiter", "Umpolen", "U/min", "Stromrichtung", "Magnetfeld", "Lorentzkraft", ""}, {"en", "Electric Motor", "Reset", "Start", "Pause", "Resume", "Change direction", "rot/min", "Current direction", "Magnetic field", "Lorentz force", ""}};
    private int[] gaps = new int[]{10, 5, 5, 10, 5, 10, 5, 5, 10, 0, 10};
    final int width = 560;
    final int width0 = 380;
    final int height = 320;
    final double[] p1X = new double[]{135.0, 335.0, 335.0, 295.0, 250.0, 250.0, 85.0, 85.0, 135.0};
    final double[] p1Y = new double[]{290.0, 240.0, 140.0, 150.0, 140.0, 215.0, 255.0, 280.0, 290.0};
    final double[] p2X = new double[]{135.0, 250.0, 250.0, 295.0, 335.0, 335.0, 285.0, 85.0, 85.0, 135.0};
    final double[] p2Y = new double[]{115.0, 85.0, 140.0, 150.0, 140.0, 40.0, 30.0, 80.0, 105.0, 115.0};
    double[] p3X;
    double[] p3Y;
    double[] p4X;
    double[] p4Y;
    double[] c3;
    double[] c4;
    double[] p5X;
    double[] p5Y;
    double[] p6X;
    double[] p6Y;
    double[] pxEllipse;
    double[] pyEllipse;
    double[] pxCommutator;
    double[] pyCommutator;
    CanvasAP cv;
    Panel6 pan;
    ResetButton bReset;
    StartButton bStart;
    JButton bDirC;
    JScrollBar scr;
    JLabel lb;
    JCheckBox cb1;
    JCheckBox cb2;
    JCheckBox cb3;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorButton3;
    Color colorNorth;
    Color colorSouth;
    Color colorPlus;
    Color colorMinus;
    Color colorCurrent1;
    Color colorCurrent2;
    Color colorField;
    Color colorForce;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    double x0;
    double y0;
    double x1;
    double y1;
    double T;
    double t;
    double phi;
    double cos;
    double sin;
    int direction;
    boolean on;
    int current;

    public ElectricMotorAP() {
        this.initContacts();
        this.initCommutator();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(560, 320);
    }

    @Override
    protected void initAttributes() {
        this.T = 10.0;
        this.t = 0.0;
        this.direction = 1;
        this.on = true;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorButton3 = this.getColor(new Color(255, 64, 64), "colorButton3");
        this.colorNorth = this.getColor(Color.red, "colorNorth");
        this.colorSouth = this.getColor(Color.green, "colorSouth");
        this.colorPlus = this.getColor(Color.red, "colorPlus");
        this.colorMinus = this.getColor(Color.blue, "colorMinus");
        this.colorCurrent1 = this.getColor(Color.red, "colorCurrent1");
        this.colorCurrent2 = this.getColor(new Color(255, 64, 64), "colorCurrent2");
        this.colorField = this.getColor(Color.blue, "colorField");
        this.colorForce = this.getColor(Color.black, "colorForce");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(this.text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.coauthor = this.getText(t[11], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 380, 320);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 1, this.gaps);
        this.pan.setBounds(380, 0, 180, 320);
        this.bReset = new ResetButton(this.text01);
        this.pan.add(this.bReset, this.colorButton1, Color.black);
        this.bStart = new StartButton(this.text02, this.text03, this.text04);
        this.bStart.setState(1);
        this.pan.add(this.bStart, this.colorButton2, Color.black);
        this.bDirC = this.pan.newButton(this.text05, this.colorButton3);
        this.scr = new JScrollBar(0, 10, 2, 0, 22);
        this.scr.setBlockIncrement(5);
        this.scr.addAdjustmentListener(this);
        this.pan.add(this.scr, Color.white, Color.black);
        this.lb = new JLabel(this.toString(6.0, 1) + " " + this.text06);
        this.pan.add(this.lb, this.bgPanel, Color.black);
        this.cb1 = new JCheckBox(this.text07, true);
        this.pan.add(this.cb1, this.bgPanel, this.colorCurrent1);
        this.cb2 = new JCheckBox(this.text08, true);
        this.pan.add(this.cb2, this.bgPanel, this.colorField);
        this.cb3 = new JCheckBox(this.text09, true);
        this.pan.add(this.cb3, this.bgPanel, this.colorForce);
        this.pan.add(1997);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.bReset.addActionListener(this);
        this.bStart.addActionListener(this);
    }

    @Override
    protected void end() {
        this.thr = null;
        this.removeAll();
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on && this.T > 0.0) {
                this.t += (double)((long)this.direction * (t1 - t0)) / 1000.0;
            }
            t0 = t1;
        }
    }

    void screenCoords(double x, double y, double z) {
        this.x1 = 110.0 + 0.5 * x + 0.4 * y;
        this.y1 = 185.0 + 0.1 * x - 0.1 * y - 0.5 * z;
    }

    void screenCoordsRot(double x, double y, double z) {
        double xx = x * this.cos - z * this.sin;
        double zz = x * this.sin + z * this.cos;
        this.screenCoords(xx, y, zz);
    }

    void moveTo(double x, double y, double z) {
        this.screenCoordsRot(x, y, z);
        this.x0 = this.x1;
        this.y0 = this.y1;
    }

    double[] initCuboid(double[] px, double[] py, double xx1, double xx2, double yy1, double yy2, double zz1, double zz2) {
        this.screenCoords(xx1, yy1, zz1);
        px[0] = this.x1;
        py[0] = this.y1;
        this.screenCoords(xx2, yy1, zz1);
        px[1] = this.x1;
        py[1] = this.y1;
        this.screenCoords(xx2, yy2, zz1);
        px[2] = this.x1;
        py[2] = this.y1;
        this.screenCoords(xx2, yy2, zz2);
        px[3] = this.x1;
        py[3] = this.y1;
        this.screenCoords(xx1, yy2, zz2);
        px[4] = this.x1;
        py[4] = this.y1;
        this.screenCoords(xx1, yy1, zz2);
        px[5] = this.x1;
        py[5] = this.y1;
        this.screenCoords(xx2, yy1, zz2);
        double[] res = new double[]{this.x1, this.y1};
        return res;
    }

    void initContacts() {
        this.p3X = new double[6];
        this.p3Y = new double[6];
        this.p4X = new double[6];
        this.p4Y = new double[6];
        this.c3 = this.initCuboid(this.p3X, this.p3Y, -10.0, 10.0, -10.0, 10.0, 40.0, 60.0);
        this.c4 = this.initCuboid(this.p4X, this.p4Y, -10.0, 10.0, -10.0, 10.0, -60.0, -40.0);
    }

    void initCommutator() {
        this.pxEllipse = new double[72];
        this.pyEllipse = new double[72];
        this.pxCommutator = new double[74];
        this.pyCommutator = new double[74];
        for (int i = 0; i < 72; ++i) {
            double phi = (double)(95 + i * 5) * (Math.PI / 180);
            this.screenCoords(40.0 * Math.cos(phi), -10.0, 40.0 * Math.sin(phi));
            this.pxEllipse[i] = this.x1;
            this.pyEllipse[i] = this.y1;
            if (i == 0) {
                this.pxCommutator[73] = this.x1 + 8.0;
                this.pyCommutator[73] = this.y1 - 2.0;
            }
            if (i <= 37) {
                this.pxCommutator[i] = this.x1;
                this.pyCommutator[i] = this.y1;
            }
            if (i < 37) continue;
            this.pxCommutator[i + 1] = this.x1 + 8.0;
            this.pyCommutator[i + 1] = this.y1 - 2.0;
        }
        this.p5X = new double[10];
        this.p5Y = new double[10];
        this.p6X = new double[10];
        this.p6Y = new double[10];
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.bReset) {
            this.on = false;
            this.t = 0.0;
            this.phi = 0.0;
            this.bStart.setState(0);
        } else if (o == this.bStart) {
            this.on = !this.on;
            this.bStart.setState();
        } else if (o == this.bDirC) {
            this.direction = -this.direction;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        int u = this.scr.getValue();
        if (u > 20) {
            u = 20;
            this.scr.setValue(u);
        }
        if (u > 0) {
            this.T = 100.0 / (double)u;
            this.t = this.phi * this.T / (Math.PI * 2);
        } else {
            this.T = -1.0;
        }
        String s = this.T < 0.0 ? "0" : this.toString(60.0 / this.T, 1);
        this.lb.setText(s + " " + this.text06);
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, ElectricMotorAP.this.bgCanvas);
        }

        void magnet(Graphics2D g) {
            CanvasAP.polygon(g, ElectricMotorAP.this.p1X, ElectricMotorAP.this.p1Y, ElectricMotorAP.this.colorSouth, true);
            CanvasAP.polygon(g, ElectricMotorAP.this.p2X, ElectricMotorAP.this.p2Y, ElectricMotorAP.this.colorNorth, true);
            g.setColor(Color.black);
            CanvasAP.line(g, 85.0, 255.0, 135.0, 265.0);
            CanvasAP.line(g, 135.0, 265.0, 135.0, 290.0);
            CanvasAP.line(g, 135.0, 265.0, 295.0, 225.0);
            CanvasAP.line(g, 250.0, 215.0, 295.0, 225.0);
            CanvasAP.line(g, 85.0, 80.0, 135.0, 90.0);
            CanvasAP.line(g, 135.0, 90.0, 135.0, 115.0);
            CanvasAP.line(g, 135.0, 90.0, 335.0, 40.0);
            CanvasAP.line(g, 250.0, 85.0, 295.0, 75.0);
            CanvasAP.line(g, 295.0, 75.0, 295.0, 225.0);
        }

        void thickCircle(Graphics2D g, double x, double y, Color c) {
            CanvasAP.circle(g, 2.0, x, y, 4.0, c, false);
            CanvasAP.circle(g, x, y, 2.5, ElectricMotorAP.this.bgCanvas);
            g.setColor(c);
        }

        void wires(Graphics2D g) {
            int dir = ElectricMotorAP.this.direction;
            g.setColor(ElectricMotorAP.this.colorPlus);
            g.fillRect(35, 174 - dir * 10, 11, 3);
            g.fillRect(39, 170 - dir * 10, 3, 11);
            g.setColor(ElectricMotorAP.this.colorMinus);
            g.fillRect(35, 174 + dir * 10, 11, 3);
            g.setColor(ElectricMotorAP.this.current != 0 ? ElectricMotorAP.this.colorCurrent1 : Color.black);
            CanvasAP.line(g, 3.0, 60.0, 163.0, 60.0, 120.0);
            CanvasAP.line(g, 3.0, 60.0, 120.0, 110.0, 130.0);
            CanvasAP.line(g, 3.0, 110.0, 130.0, 110.0, 155.0);
            CanvasAP.line(g, 3.0, 60.0, 189.0, 60.0, 230.0);
            CanvasAP.line(g, 3.0, 60.0, 230.0, 110.0, 240.0);
            CanvasAP.line(g, 3.0, 110.0, 240.0, 110.0, 215.0);
            Color c = g.getColor();
            this.thickCircle(g, 60.0, 185.0, c);
            this.thickCircle(g, 60.0, 165.0, c);
            if (ElectricMotorAP.this.current != 0 && ElectricMotorAP.this.cb1.isSelected()) {
                ElectricMotorAP.this.x0 = 85 - dir * 25;
                ElectricMotorAP.this.y0 = 125 - dir * 5;
                this.arrowTo(g, 85 + dir * 5, 125 + dir);
                ElectricMotorAP.this.x0 = 85 + dir * 25;
                ElectricMotorAP.this.y0 = 235 + dir * 5;
                this.arrowTo(g, 85 - dir * 5, 235 - dir);
            }
        }

        void cuboid(Graphics2D g, double[] px, double[] py, double[] p, Color c, boolean fill) {
            CanvasAP.polygon(g, px, py, c, fill);
            if (!fill) {
                g.setColor(c);
            }
            CanvasAP.line(g, p[0], p[1], px[1], py[1]);
            CanvasAP.line(g, p[0], p[1], px[3], py[3]);
            CanvasAP.line(g, p[0], p[1], px[5], py[5]);
        }

        void contact1(Graphics2D g) {
            Color c = ElectricMotorAP.this.current != 0 ? ElectricMotorAP.this.colorCurrent2 : Color.lightGray;
            this.cuboid(g, ElectricMotorAP.this.p3X, ElectricMotorAP.this.p3Y, ElectricMotorAP.this.c3, c, true);
            g.setColor(ElectricMotorAP.this.current != 0 ? ElectricMotorAP.this.colorCurrent1 : Color.black);
            CanvasAP.line(g, 3.0, 110.0, 155.0, 110.0, 152.0);
        }

        void contact2(Graphics2D g) {
            Color c = ElectricMotorAP.this.current != 0 ? ElectricMotorAP.this.colorCurrent2 : Color.lightGray;
            this.cuboid(g, ElectricMotorAP.this.p4X, ElectricMotorAP.this.p4Y, ElectricMotorAP.this.c4, c, true);
        }

        void armature(Graphics2D g, int type) {
            int sign = 3 - 2 * type;
            int dir = ElectricMotorAP.this.current * ElectricMotorAP.this.direction;
            g.setColor(ElectricMotorAP.this.current != 0 ? ElectricMotorAP.this.colorCurrent1 : Color.black);
            ElectricMotorAP.this.moveTo(0.0, 0.0, sign * 20);
            this.lineTo(g, 0.0, 120.0, sign * 20);
            this.lineTo(g, 0.0, 120.0, sign * 80);
            this.lineTo(g, 0.0, 280.0, sign * 80);
            this.lineTo(g, 0.0, 280.0, 0.0);
            if (ElectricMotorAP.this.cb1.isSelected() && dir != 0) {
                ElectricMotorAP.this.moveTo(0.0, 200.0, sign * 80);
                this.arrowTo(g, 0.0, 200 - sign * dir * 40, sign * 80);
            }
        }

        void arrowTo(Graphics2D g, double x, double y) {
            CanvasAP.arrow(g, 3.0, ElectricMotorAP.this.x0, ElectricMotorAP.this.y0, x, y);
            ElectricMotorAP.this.x0 = x;
            ElectricMotorAP.this.y0 = y;
        }

        void lineTo(Graphics2D g, double x, double y, double z) {
            ElectricMotorAP.this.screenCoordsRot(x, y, z);
            CanvasAP.line(g, 3.0, ElectricMotorAP.this.x0, ElectricMotorAP.this.y0, ElectricMotorAP.this.x1, ElectricMotorAP.this.y1);
            ElectricMotorAP.this.x0 = ElectricMotorAP.this.x1;
            ElectricMotorAP.this.y0 = ElectricMotorAP.this.y1;
        }

        void arrowTo(Graphics2D g, double x, double y, double z) {
            double xx0 = ElectricMotorAP.this.x0;
            double yy0 = ElectricMotorAP.this.y0;
            this.lineTo(g, x, y, z);
            double x1 = ElectricMotorAP.this.x0;
            double y1 = ElectricMotorAP.this.y0;
            ElectricMotorAP.this.x0 = xx0;
            ElectricMotorAP.this.y0 = yy0;
            this.arrowTo(g, x1, y1);
        }

        void setPoint(double[] px, double[] py, int i, double x, double y, double z) {
            ElectricMotorAP.this.screenCoordsRot(x, y, z);
            px[i] = ElectricMotorAP.this.x1;
            py[i] = ElectricMotorAP.this.y1;
        }

        void commutator(Graphics2D g) {
            Color c = ElectricMotorAP.this.current != 0 ? ElectricMotorAP.this.colorCurrent2 : Color.lightGray;
            CanvasAP.polygon(g, ElectricMotorAP.this.pxCommutator, ElectricMotorAP.this.pyCommutator, c, true);
            CanvasAP.polygon(g, ElectricMotorAP.this.pxEllipse, ElectricMotorAP.this.pyEllipse, Color.black, false);
            int xM = 106;
            int yM = 186;
            int dx = 8;
            int dy = -2;
            for (int i = 0; i <= 4; ++i) {
                double w = (double)((i - 2) * 5) * (Math.PI / 180);
                ElectricMotorAP.this.screenCoordsRot(40.0 * Math.cos(w), -10.0, 40.0 * Math.sin(w));
                if (ElectricMotorAP.this.phi > 1.7453292519943295 && ElectricMotorAP.this.phi < 4.886921905584122) {
                    ElectricMotorAP.this.x1 = 212.0 - ElectricMotorAP.this.x1;
                    ElectricMotorAP.this.y1 = 372.0 - ElectricMotorAP.this.y1;
                }
                ElectricMotorAP.this.p5X[i] = ElectricMotorAP.this.x1;
                ElectricMotorAP.this.p5Y[i] = ElectricMotorAP.this.y1;
                ElectricMotorAP.this.p5X[i + 5] = 212.0 - ElectricMotorAP.this.x1;
                ElectricMotorAP.this.p5Y[i + 5] = 372.0 - ElectricMotorAP.this.y1;
                ElectricMotorAP.this.p6X[i] = ElectricMotorAP.this.x1;
                ElectricMotorAP.this.p6Y[i] = ElectricMotorAP.this.y1;
                ElectricMotorAP.this.p6X[9 - i] = ElectricMotorAP.this.x1 + 8.0;
                ElectricMotorAP.this.p6Y[9 - i] = ElectricMotorAP.this.y1 + -2.0;
            }
            CanvasAP.polygon(g, ElectricMotorAP.this.p5X, ElectricMotorAP.this.p5Y, Color.black, true);
            CanvasAP.polygon(g, ElectricMotorAP.this.p6X, ElectricMotorAP.this.p6Y, Color.black, true);
        }

        void fieldLines(Graphics2D g, int type) {
            if (!ElectricMotorAP.this.cb2.isSelected()) {
                return;
            }
            int begin = 0;
            int end = 0;
            switch (type) {
                case 0: {
                    begin = 2;
                    end = 3;
                    break;
                }
                case 1: {
                    begin = 0;
                    end = 2;
                    break;
                }
                case 2: {
                    begin = 3;
                    end = 5;
                }
            }
            g.setColor(ElectricMotorAP.this.colorField);
            for (int i = begin; i < end; ++i) {
                ElectricMotorAP.this.x0 = 150 + i * 20;
                ElectricMotorAP.this.y0 = 112 - i * 5;
                CanvasAP.line(g, 3.0, ElectricMotorAP.this.x0, ElectricMotorAP.this.y0, ElectricMotorAP.this.x0, ElectricMotorAP.this.y0 + 138.0);
                this.arrowTo(g, ElectricMotorAP.this.x0, ElectricMotorAP.this.y0 + 18.0);
                this.arrowTo(g, ElectricMotorAP.this.x0, ElectricMotorAP.this.y0 + 105.0);
            }
        }

        void forceArrow(Graphics2D g, int type) {
            if (!ElectricMotorAP.this.cb3.isSelected()) {
                return;
            }
            int z = 240 - type * 160;
            int d = (3 - 2 * type) * ElectricMotorAP.this.current * ElectricMotorAP.this.direction * 40;
            g.setColor(ElectricMotorAP.this.colorForce);
            if (ElectricMotorAP.this.current != 0) {
                ElectricMotorAP.this.moveTo(0.0, 200.0, z);
                this.arrowTo(g, ElectricMotorAP.this.x0 + (double)d, ElectricMotorAP.this.y0 + (double)(d / 5));
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            ElectricMotorAP.this.current = 0;
            ElectricMotorAP.this.cos = Math.cos(ElectricMotorAP.this.phi);
            ElectricMotorAP.this.sin = Math.sin(ElectricMotorAP.this.phi);
            double PI = Math.PI;
            if (ElectricMotorAP.this.T > 0.0 && ElectricMotorAP.this.phi > 1.7 && ElectricMotorAP.this.phi < 4.2915926535897935) {
                ElectricMotorAP.this.current = 1;
            }
            if (ElectricMotorAP.this.T > 0.0 && (ElectricMotorAP.this.phi < 1.15 || ElectricMotorAP.this.phi > 4.841592653589793)) {
                ElectricMotorAP.this.current = -1;
            }
            CanvasAP.setAntiAliasing(g2, true);
            this.magnet(g2);
            this.wires(g2);
            if (ElectricMotorAP.this.T > 0.0) {
                ElectricMotorAP.this.phi = ElectricMotorAP.this.t * (Math.PI * 2) / ElectricMotorAP.this.T;
            }
            int n = (int)(ElectricMotorAP.this.phi / (Math.PI * 2));
            ElectricMotorAP.this.phi = ElectricMotorAP.this.phi >= 0.0 ? (ElectricMotorAP.this.phi -= (double)n * (Math.PI * 2)) : (ElectricMotorAP.this.phi -= (double)(n - 1) * (Math.PI * 2));
            int qu = (int)(ElectricMotorAP.this.phi * 2.0 / Math.PI) + 1;
            if (ElectricMotorAP.this.direction == 1) {
                switch (qu) {
                    case 1: {
                        this.forceArrow(g2, 1);
                        this.armature(g2, 1);
                        this.fieldLines(g2, 1);
                        this.fieldLines(g2, 0);
                        this.fieldLines(g2, 2);
                        this.armature(g2, 2);
                        this.forceArrow(g2, 2);
                        break;
                    }
                    case 2: {
                        this.armature(g2, 1);
                        this.fieldLines(g2, 2);
                        this.fieldLines(g2, 0);
                        this.forceArrow(g2, 1);
                        this.forceArrow(g2, 2);
                        this.fieldLines(g2, 1);
                        this.armature(g2, 2);
                        break;
                    }
                    case 3: {
                        this.forceArrow(g2, 2);
                        this.armature(g2, 2);
                        this.fieldLines(g2, 1);
                        this.fieldLines(g2, 0);
                        this.fieldLines(g2, 2);
                        this.armature(g2, 1);
                        this.forceArrow(g2, 1);
                        break;
                    }
                    case 4: {
                        this.armature(g2, 2);
                        this.fieldLines(g2, 2);
                        this.fieldLines(g2, 0);
                        this.forceArrow(g2, 2);
                        this.forceArrow(g2, 1);
                        this.fieldLines(g2, 1);
                        this.armature(g2, 1);
                    }
                }
            } else {
                switch (qu) {
                    case 4: {
                        this.forceArrow(g2, 2);
                        this.armature(g2, 2);
                        this.fieldLines(g2, 1);
                        this.fieldLines(g2, 0);
                        this.fieldLines(g2, 2);
                        this.armature(g2, 1);
                        this.forceArrow(g2, 1);
                        break;
                    }
                    case 3: {
                        this.armature(g2, 2);
                        this.fieldLines(g2, 2);
                        this.fieldLines(g2, 0);
                        this.forceArrow(g2, 2);
                        this.forceArrow(g2, 1);
                        this.fieldLines(g2, 1);
                        this.armature(g2, 1);
                        break;
                    }
                    case 2: {
                        this.forceArrow(g2, 1);
                        this.armature(g2, 1);
                        this.fieldLines(g2, 1);
                        this.fieldLines(g2, 0);
                        this.fieldLines(g2, 2);
                        this.armature(g2, 2);
                        this.forceArrow(g2, 2);
                        break;
                    }
                    case 1: {
                        this.armature(g2, 1);
                        this.fieldLines(g2, 2);
                        this.fieldLines(g2, 0);
                        this.forceArrow(g2, 1);
                        this.forceArrow(g2, 2);
                        this.fieldLines(g2, 1);
                        this.armature(g2, 2);
                    }
                }
            }
            this.contact2(g2);
            this.commutator(g2);
            this.contact1(g2);
        }
    }
}

