/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;

public class ElectromagneticWaveAP
extends AP6
implements Runnable {
    static final String[][] text = new String[][]{{"de", "Elektromagnetische Welle"}, {"en", "Electromagnetic Wave"}};
    final int width = 560;
    final int height = 400;
    final double omega = 0.20943951023931953;
    final double k = 0.5235987755982988;
    final double theta = 0.2617993877991494;
    final double phi = 0.6981317007977318;
    CanvasAP cv;
    Color bgCanvas;
    Color colorE;
    Color colorB;
    int uM;
    int vM;
    double a1;
    double a2;
    double b1;
    double b2;
    double b3;
    double t;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(560, 400);
    }

    @Override
    protected void initAttributes() {
        this.uM = 120;
        this.vM = 180;
        this.calcCoeff();
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.colorE = this.getColor(Color.red, "colorE");
        this.colorB = this.getColor(Color.blue, "colorB");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
    }

    @Override
    protected void initPanel() {
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 560, 400);
        this.add(this.cv);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            this.t += (double)(t1 - t0) / 1000.0;
            t0 = t1;
        }
    }

    void calcCoeff() {
        double sin = Math.sin(0.2617993877991494);
        double cos = Math.cos(0.2617993877991494);
        double f = 15.0;
        this.a1 = -f * Math.sin(0.6981317007977318);
        this.a2 = f * Math.cos(0.6981317007977318);
        this.b1 = -sin * this.a2;
        this.b2 = sin * this.a1;
        this.b3 = f * cos;
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, ElectromagneticWaveAP.this.bgCanvas);
            Dimension dim = new Dimension(560, 400);
            this.setPreferredSize(dim);
            ap.setPreferredSize(dim);
        }

        void axes(Graphics2D g) {
            g.setColor(Color.black);
            double u = (double)ElectromagneticWaveAP.this.uM + ElectromagneticWaveAP.this.a2 * 35.0;
            double v = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b2 * 35.0;
            int x1 = (int)Math.round(u);
            int x2 = (int)Math.round(v);
            CanvasAP.arrow(g, (double)ElectromagneticWaveAP.this.uM - ElectromagneticWaveAP.this.a2 * 2.0, (double)ElectromagneticWaveAP.this.vM + ElectromagneticWaveAP.this.b2 * 2.0, u, v);
            u = ElectromagneticWaveAP.this.uM;
            v = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b3 * 10.0;
            int y2 = (int)Math.round(v);
            CanvasAP.arrow(g, ElectromagneticWaveAP.this.uM, (double)ElectromagneticWaveAP.this.vM + ElectromagneticWaveAP.this.b3 * 10.0, u, v);
            u = (double)ElectromagneticWaveAP.this.uM + ElectromagneticWaveAP.this.a1 * 10.0;
            v = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b1 * 10.0;
            int z1 = (int)Math.round(u);
            int z2 = (int)Math.round(v);
            CanvasAP.arrow(g, (double)ElectromagneticWaveAP.this.uM - ElectromagneticWaveAP.this.a1 * 10.0, (double)ElectromagneticWaveAP.this.vM + ElectromagneticWaveAP.this.b1 * 10.0, u, v);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString("x", x1 - 6, x2 - 6);
            g.drawString("y", ElectromagneticWaveAP.this.uM + 8, y2 + 8);
            g.drawString("z", z1, z2 - 6);
            CanvasAP.setAntiAliasing(g, true);
        }

        void eVectors(Graphics2D g) {
            g.setColor(ElectromagneticWaveAP.this.colorE);
            for (int y = 0; y < 30; ++y) {
                double e = 8.0 * Math.sin(0.20943951023931953 * ElectromagneticWaveAP.this.t - 0.5235987755982988 * (double)y);
                double u = (double)ElectromagneticWaveAP.this.uM + ElectromagneticWaveAP.this.a2 * (double)y;
                double v = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b2 * (double)y;
                CanvasAP.arrow(g, 2.0, u, v, u, v - ElectromagneticWaveAP.this.b3 * e);
            }
        }

        void bVectors(Graphics2D g, int signB) {
            g.setColor(ElectromagneticWaveAP.this.colorB);
            for (int y = 0; y < 30; ++y) {
                double b = 8.0 * Math.sin(0.20943951023931953 * ElectromagneticWaveAP.this.t - 0.5235987755982988 * (double)y);
                if (b * (double)signB <= 0.0) continue;
                double u = (double)ElectromagneticWaveAP.this.uM + ElectromagneticWaveAP.this.a2 * (double)y;
                double v = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b2 * (double)y;
                CanvasAP.arrow(g, 2.0, u, v, u + ElectromagneticWaveAP.this.a1 * b, v - ElectromagneticWaveAP.this.b1 * b);
            }
        }

        void eWave(Graphics2D g) {
            g.setColor(ElectromagneticWaveAP.this.colorE);
            double e = 8.0 * Math.sin(0.20943951023931953 * ElectromagneticWaveAP.this.t);
            double u1 = ElectromagneticWaveAP.this.uM;
            double v1 = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b3 * e;
            for (int yy = 1; yy <= 300; ++yy) {
                double y = (double)yy / 10.0;
                double u0 = u1;
                double v0 = v1;
                e = 8.0 * Math.sin(0.20943951023931953 * ElectromagneticWaveAP.this.t - 0.5235987755982988 * y);
                u1 = (double)ElectromagneticWaveAP.this.uM + ElectromagneticWaveAP.this.a2 * y;
                v1 = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b2 * y - ElectromagneticWaveAP.this.b3 * e;
                CanvasAP.line(g, u0, v0, u1, v1);
            }
        }

        void bWave(Graphics2D g) {
            g.setColor(ElectromagneticWaveAP.this.colorB);
            double e = 8.0 * Math.sin(0.20943951023931953 * ElectromagneticWaveAP.this.t);
            double u1 = (double)ElectromagneticWaveAP.this.uM + ElectromagneticWaveAP.this.a1 * e;
            double v1 = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b1 * e;
            for (int yy = 1; yy <= 300; ++yy) {
                double y = (double)yy / 10.0;
                double u0 = u1;
                double v0 = v1;
                e = 8.0 * Math.sin(0.20943951023931953 * ElectromagneticWaveAP.this.t - 0.5235987755982988 * y);
                u1 = (double)ElectromagneticWaveAP.this.uM + ElectromagneticWaveAP.this.a1 * e + ElectromagneticWaveAP.this.a2 * y;
                v1 = (double)ElectromagneticWaveAP.this.vM - ElectromagneticWaveAP.this.b1 * e - ElectromagneticWaveAP.this.b2 * y;
                CanvasAP.line(g, u0, v0, u1, v1);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setFont(this.fH);
            g.setColor(Color.black);
            Graphics2D g2 = (Graphics2D)g;
            g.drawString(ElectromagneticWaveAP.this.copyright(1999), 30, this.getHeight() - 20);
            CanvasAP.setAntiAliasing(g2, true);
            this.axes(g2);
            this.bVectors(g2, -1);
            this.eVectors(g2);
            this.eWave(g2);
            this.bVectors(g2, 1);
            this.bWave(g2);
        }
    }
}

