/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AP6
extends JPanel
implements ActionListener,
Runnable {
    protected static final double DEG = Math.PI / 180;
    protected final BasicStroke THIN = new BasicStroke(1.0f);
    private A6 applet;
    protected boolean correct = false;
    protected String title;
    protected Properties prop;
    protected String language;
    protected Thread thr;
    protected String ampere = "A";
    protected String milliampere = "mA";
    protected String microampere = "\u00b5A";
    protected String electronvolt = "eV";
    protected String farad = "F";
    protected String millifarad = "mF";
    protected String microfarad = "\u00b5F";
    protected String degree = "\u00b0";
    protected String henry = "H";
    protected String hertz = "Hz";
    protected String terahertz = "THz";
    protected String joule = "J";
    protected String kelvin = "K";
    protected String kilogram = "kg";
    protected String gram = "g";
    protected String kilogramPerMeter3 = "kg/m\u00b3";
    protected String gramPerCentimeter3 = "g/cm\u00b3";
    protected String meter = "m";
    protected String centimeter = "cm";
    protected String nanometer = "nm";
    protected String meter2 = "m\u00b2";
    protected String centimeter2 = "cm\u00b2";
    protected String meter3 = "m\u00b3";
    protected String decimeter3 = "dm\u00b3";
    protected String centimeter3 = "cm\u00b3";
    protected String meterPerSecond = "m/s";
    protected String meterPerSecond2 = "m/s\u00b2";
    protected String newton = "N";
    protected String newtonPerMeter = "N/m";
    protected String ohm = "\u03a9";
    protected String pascal = "Pa";
    protected String hectopascal = "hPa";
    protected String kilopascal = "kPa";
    protected String second = "s";
    protected String perSecond = "1/s";
    protected String volt = "V";

    public AP6() {
        this.setLayout(null);
    }

    protected abstract void initAttributes();

    protected abstract void initColors();

    protected abstract void initText();

    protected abstract void initCanvas();

    protected abstract void initPanel();

    void setApplet(A6 a) {
        this.applet = a;
    }

    Properties newProperties(String fn) {
        try {
            Properties prop = new Properties();
            FileReader reader = new FileReader(fn);
            prop.load(reader);
            ((Reader)reader).close();
            return prop;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return null;
        }
    }

    protected String[] searchLanguage(String[][] text, String lang) {
        int i;
        String[] t = text[0];
        for (i = 0; i < text.length && !lang.equals((t = text[i])[0]); ++i) {
        }
        if (i == text.length) {
            t = text[0];
        }
        this.language = t[0];
        return t;
    }

    protected String getDecimalSeparator(String lang) {
        if (lang.equals("en")) {
            return ".";
        }
        return ",";
    }

    protected String getText(String def, String key) {
        String s;
        if (this.applet != null) {
            String s2 = this.applet.getParameter(key);
            if (s2 != null && !s2.equals("")) {
                return s2;
            }
            return def;
        }
        String text = def;
        if (this.prop != null && !(s = this.prop.getProperty(key, text)).equals("")) {
            text = s;
        }
        return text;
    }

    private Color color(String hex) {
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4), 16);
        return new Color(r, g, b);
    }

    protected Color getColor(Color def, String key) {
        try {
            if (this.applet != null) {
                return this.color(this.applet.getParameter(key));
            }
            return this.color(this.prop.getProperty(key));
        }
        catch (Exception exc) {
            return def;
        }
    }

    protected void startThread(boolean animation) {
        if (!animation) {
            return;
        }
        this.thr = new Thread(this);
        this.thr.start();
    }

    private void setUnits() {
        if (this.language.equals("ru")) {
            this.meter = "\u043c";
            this.second = "\u0441";
        }
    }

    protected void initAP(boolean program, String propFile, boolean animation) {
        if (program) {
            this.prop = this.newProperties(propFile);
        }
        this.initAttributes();
        this.initColors();
        this.initText();
        this.setUnits();
        this.initCanvas();
        this.initPanel();
        this.startThread(animation);
    }

    protected void end() {
        this.thr = null;
        this.removeAll();
    }

    protected String toString(double a, int n) {
        int pos;
        if (n < 0) {
            return "";
        }
        String sign = a >= 0.0 ? "" : "\u2212";
        a = Math.abs(a);
        long zp = 1L;
        for (int i = 0; i < n; ++i) {
            zp *= 10L;
        }
        String s = "" + Math.round(a * (double)zp);
        for (pos = s.length() - n; pos <= 0; ++pos) {
            s = "0" + s;
        }
        String s1 = sign + s.substring(0, pos);
        String sep = this.getDecimalSeparator(this.language);
        if (n == 0) {
            return s1;
        }
        return s1 + sep + s.substring(pos);
    }

    protected String toString2(double a, int n, double eps) {
        String sign = a >= 0.0 ? "" : "\u2212";
        double b = Math.abs(a);
        if (b < eps) {
            return "0";
        }
        int z = (int)Math.floor(Math.log(b) / Math.log(10.0));
        if (z < n) {
            return sign + this.toString(b, n - 1 - z);
        }
        double zp = 1.0;
        for (int i = 0; i < z; ++i) {
            zp *= 10.0;
        }
        return this.toString2(a / zp, 3, 1.0E-10) + "*10^" + z;
    }

    protected double toDouble(String s) {
        s = s.replace(',', '.');
        s = s.replace('\u2212', '-');
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    protected double inputTF(JTextField tf, double min, double max, int n) {
        double value = this.toDouble(tf.getText());
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        tf.setText(this.toString(value, n));
        return this.correct ? value : 0.0;
    }

    protected double inputTF2(JTextField tf, double min, double max, int n, double eps) {
        double value = this.toDouble(tf.getText());
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        tf.setText(this.toString2(value, n, eps));
        return this.correct ? value : 0.0;
    }

    protected double floorP10(double a) {
        int n = (int)Math.floor(Math.log(a) / Math.log(10.0));
        double p = 1.0;
        for (int i = 0; i < Math.abs(n); ++i) {
            p *= 10.0;
        }
        return n >= 0 ? p : 1.0 / p;
    }

    protected String copyright(int year) {
        this.correct = true;
        return "\u00a9  W. Fendt " + year;
    }
}

