/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;

public class GeneratorAP
extends AP6
implements AdjustmentListener {
    String[][] text = new String[][]{{"de", "Generator", "Ohne Kommutator", "Mit Kommutator", "Umgekehrte Richtung", "U/min", "Pause", "Weiter", "Bewegungsrichtung", "Magnetfeld", "Induzierter Strom", "t", "U", "R", ""}, {"en", "Generator", "Without commutator", "With commutator", "Change direction", "rot/min", "Pause", "Resume", "Direction of movement", "Magnetic field", "Induced current", "t", "V", "R", ""}};
    final int width = 740;
    final int height = 360;
    final int width0 = 540;
    private int[] gaps = new int[]{10, 3, 10, 20, 10, 10, 10, 3, 3, 10, 3, 10};
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JRadioButton rbOK;
    JRadioButton rbMK;
    JButton buDir;
    JScrollBar scr;
    JLabel lbDrZ;
    StartButton buPause;
    JCheckBox cb1;
    JCheckBox cb2;
    JCheckBox cb3;
    final Color BLACK = Color.black;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorMotion;
    Color colorField;
    Color colorCurrent;
    Color colorVoltage;
    Color colorNorth;
    Color colorSouth;
    Color colorCrank;
    Color colorResistor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String symbolTime;
    String symbolVoltage;
    String symbolResistance;
    String coauthor;
    final double[] p1X = new double[]{213.0, 25.0, 25.0, 65.0, 110.0, 110.0, 263.0, 263.0};
    final double[] p1Y = new double[]{307.0, 260.0, 160.0, 170.0, 160.0, 235.0, 272.0, 297.0};
    final double[] p2X = new double[]{213.0, 110.0, 110.0, 65.0, 25.0, 25.0, 75.0, 263.0, 263.0};
    final double[] p2Y = new double[]{132.0, 105.0, 160.0, 170.0, 160.0, 60.0, 50.0, 97.0, 120.0};
    final double[] p5X = new double[]{241.0, 249.0, 259.0, 259.0, 251.0, 241.0};
    final double[] p5Y = new double[]{185.0, 187.0, 185.0, 175.0, 173.0, 175.0};
    final double[] p6X = new double[]{241.0, 249.0, 259.0, 259.0, 251.0, 241.0};
    final double[] p6Y = new double[]{235.0, 237.0, 235.0, 225.0, 223.0, 225.0};
    final double[] p7X = new double[]{265.0, 273.0, 283.0, 283.0, 275.0, 265.0};
    final double[] p7Y = new double[]{241.0, 243.0, 241.0, 231.0, 229.0, 231.0};
    final double[] pVM1X = new double[]{358.0, 398.0, 498.0, 498.0, 398.0, 398.0, 498.0, 458.0, 358.0};
    final double[] pVM1Y = new double[]{287.0, 297.0, 277.0, 227.0, 247.0, 147.0, 127.0, 117.0, 137.0};
    final double[] pVM2X = new double[]{398.0, 498.0, 498.0, 398.0};
    final double[] pVM2Y = new double[]{247.0, 227.0, 127.0, 147.0};
    final double[] pRX = new double[]{288.0, 325.0, 325.0, 288.0};
    final double[] pRY = new double[]{267.0, 260.0, 280.0, 287.0};
    final double PI = Math.PI;
    final double PI2 = Math.PI * 2;
    final double PIH = 1.5707963267948966;
    double x0;
    double y0;
    double x1;
    double y1;
    double[] p3X;
    double[] p3Y;
    double[] p4X;
    double[] p4Y;
    double[] p8X;
    double[] p8Y;
    double T;
    double t;
    boolean on;
    boolean current;
    int direction;
    double phi;
    double cos;
    double sin;
    boolean genDC;
    int nPer;
    boolean vArrows;
    boolean bArrows;
    boolean iArrows;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(740, 360);
    }

    @Override
    protected void initAttributes() {
        this.T = 10.0;
        this.nPer = 5;
        this.t = 0.0;
        this.phi = 0.0;
        this.cos = 1.0;
        this.sin = 0.0;
        this.current = true;
        this.on = true;
        this.direction = 1;
        this.genDC = false;
        this.iArrows = true;
        this.bArrows = true;
        this.vArrows = true;
        this.p3X = new double[4];
        this.p3Y = new double[4];
        this.p4X = new double[4];
        this.p4Y = new double[4];
        this.p8X = new double[4];
        this.p8Y = new double[4];
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(new Color(255, 64, 64), "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorMotion = this.getColor(this.BLACK, "colorMotion");
        this.colorField = this.getColor(Color.blue, "colorField");
        this.colorCurrent = this.getColor(Color.red, "colorCurrent");
        this.colorVoltage = this.getColor(Color.blue, "colorVoltage");
        this.colorNorth = this.getColor(Color.red, "colorNorth");
        this.colorSouth = this.getColor(Color.green, "colorSouth");
        this.colorCrank = this.getColor(Color.orange, "colorCrank");
        this.colorResistor = this.getColor(Color.green, "colorResistor");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(this.text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.symbolTime = this.getText(t[11], "symbolTime");
        this.symbolVoltage = this.getText(t[12], "symbolVoltage");
        this.symbolResistance = this.getText(t[13], "symbolResistance");
        this.coauthor = this.getText(t[14], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 540, 360);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 1, this.gaps);
        this.pan.setBounds(540, 0, 200, 360);
        ButtonGroup bg = new ButtonGroup();
        this.rbOK = this.pan.newRadioButton(this.text01, true, bg);
        this.rbMK = this.pan.newRadioButton(this.text02, false, bg);
        this.buDir = this.pan.newButton(this.text03, this.colorButton1);
        this.scr = new JScrollBar(0, 5, 2, 0, 12);
        this.scr.setBlockIncrement(5);
        this.pan.add(this.scr, Color.white, this.BLACK);
        this.lbDrZ = new JLabel(this.text04);
        this.lbDrZ.setText(this.toString(60.0 / this.T, 1) + " " + this.text04);
        this.pan.add(this.lbDrZ, this.bgPanel, this.BLACK);
        this.buPause = new StartButton("", this.text05, this.text06);
        this.buPause.setState(1);
        this.pan.add(this.buPause, this.colorButton2, this.BLACK);
        this.cb1 = this.pan.newCheckBox(this.text07, true);
        this.cb1.setForeground(this.colorMotion);
        this.cb2 = this.pan.newCheckBox(this.text08, true);
        this.cb2.setForeground(this.colorField);
        this.cb3 = this.pan.newCheckBox(this.text09, true);
        this.cb3.setForeground(this.colorCurrent);
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.buPause.addActionListener(this);
        this.scr.addAdjustmentListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on && this.T > 0.0) {
                double dt = (double)(t1 - t0) / 1000.0;
                this.t += dt;
                this.phi += (double)this.direction * dt * (Math.PI * 2) / this.T;
                int n = (int)(this.phi / (Math.PI * 2));
                this.phi = this.phi >= 0.0 ? (this.phi -= (double)n * (Math.PI * 2)) : (this.phi -= (double)(n - 1) * (Math.PI * 2));
                if (this.t > (double)this.nPer * this.T) {
                    this.t -= (double)this.nPer * this.T;
                }
                this.cos = Math.cos(this.phi);
                this.sin = Math.sin(this.phi);
            }
            t0 = t1;
        }
    }

    void setPoint(double[] px, double[] py, int i, double x, double y, double z) {
        double xx = x * this.cos - z * this.sin;
        double zz = x * this.sin + z * this.cos;
        px[i] = 250.0 + 0.5 * xx - 0.4 * y;
        py[i] = 205.0 - 0.1 * xx - 0.1 * y - 0.5 * zz;
    }

    void moveTo(double x, double y, double z) {
        double xx = x * this.cos - z * this.sin;
        double zz = x * this.sin + z * this.cos;
        this.x0 = 250.0 + 0.5 * xx - 0.4 * y;
        this.y0 = 205.0 - 0.1 * xx - 0.1 * y - 0.5 * zz;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.genDC = this.rbMK.isSelected();
        this.vArrows = this.cb1.isSelected();
        this.bArrows = this.cb2.isSelected();
        this.iArrows = this.cb3.isSelected();
        Object o = ae.getSource();
        if (o == this.buDir) {
            if (this.T > 0.0) {
                this.on = true;
            }
            this.direction = -this.direction;
        } else if (o == this.buPause) {
            this.buPause.setState();
            boolean bl = this.on = !this.on;
        }
        if (o == this.rbOK || o == this.rbMK || o == this.buDir) {
            this.on = true;
            this.t = 0.0;
            this.phi = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int u = this.scr.getValue();
        if (u > 0) {
            this.T = 50.0 / (double)u;
            this.nPer = u;
        } else {
            this.T = -1.0;
            this.nPer = 0;
        }
        this.t = 0.0;
        this.phi = 0.0;
        this.cos = 1.0;
        this.sin = 0.0;
        String s = this.T < 0.0 ? "0" : this.toString(60.0 / this.T, 1);
        this.lbDrZ.setText(s + " " + this.text04);
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, GeneratorAP.this.bgCanvas);
            GeneratorAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void magnet(Graphics2D g) {
            CanvasAP.polygon(g, GeneratorAP.this.p1X, GeneratorAP.this.p1Y, GeneratorAP.this.colorSouth, true);
            CanvasAP.polygon(g, GeneratorAP.this.p2X, GeneratorAP.this.p2Y, GeneratorAP.this.colorNorth, true);
            CanvasAP.line(g, 263.0, 272.0, 213.0, 282.0);
            CanvasAP.line(g, 213.0, 282.0, 213.0, 307.0);
            CanvasAP.line(g, 213.0, 282.0, 65.0, 245.0);
            CanvasAP.line(g, 110.0, 235.0, 65.0, 245.0);
            CanvasAP.line(g, 263.0, 97.0, 213.0, 107.0);
            CanvasAP.line(g, 213.0, 107.0, 213.0, 132.0);
            CanvasAP.line(g, 213.0, 107.0, 25.0, 60.0);
            CanvasAP.line(g, 110.0, 105.0, 65.0, 95.0);
            CanvasAP.line(g, 65.0, 95.0, 65.0, 245.0);
        }

        void lineTo(Graphics2D g, int x, int y) {
            GeneratorAP.this.x1 = x;
            GeneratorAP.this.y1 = y;
            CanvasAP.line(g, 2.5, GeneratorAP.this.x0, GeneratorAP.this.y0, GeneratorAP.this.x1, GeneratorAP.this.y1);
            GeneratorAP.this.x0 = GeneratorAP.this.x1;
            GeneratorAP.this.y0 = GeneratorAP.this.y1;
        }

        void lineTo(Graphics2D g, double x, double y, double z) {
            double xx = x * GeneratorAP.this.cos - z * GeneratorAP.this.sin;
            double zz = x * GeneratorAP.this.sin + z * GeneratorAP.this.cos;
            GeneratorAP.this.x1 = 250.0 + 0.5 * xx - 0.4 * y;
            GeneratorAP.this.y1 = 205.0 - 0.1 * xx - 0.1 * y - 0.5 * zz;
            CanvasAP.line(g, 2.5, GeneratorAP.this.x0, GeneratorAP.this.y0, GeneratorAP.this.x1, GeneratorAP.this.y1);
            GeneratorAP.this.x0 = GeneratorAP.this.x1;
            GeneratorAP.this.y0 = GeneratorAP.this.y1;
        }

        void arrowTo(Graphics2D g, double x, double y) {
            GeneratorAP.this.x1 = x;
            GeneratorAP.this.y1 = y;
            CanvasAP.arrow(g, 2.5, GeneratorAP.this.x0, GeneratorAP.this.y0, GeneratorAP.this.x1, GeneratorAP.this.y1);
            GeneratorAP.this.x0 = GeneratorAP.this.x1;
            GeneratorAP.this.y0 = GeneratorAP.this.y1;
        }

        void arrowTo(Graphics2D g, double x, double y, double z) {
            double xx0 = GeneratorAP.this.x0;
            double yy0 = GeneratorAP.this.y0;
            this.lineTo(g, x, y, z);
            GeneratorAP.this.x0 = xx0;
            GeneratorAP.this.y0 = yy0;
            this.arrowTo(g, GeneratorAP.this.x1, GeneratorAP.this.y1);
        }

        void halfArmature(Graphics2D g, int i) {
            double dw;
            int dir = 0;
            int sign = 3 - 2 * i;
            double d = dw = GeneratorAP.this.genDC ? 0.3 : 0.0;
            if (GeneratorAP.this.phi < 1.5707963267948966 - dw || GeneratorAP.this.phi > 4.71238898038469 + dw) {
                dir = GeneratorAP.this.direction;
            }
            if (GeneratorAP.this.phi > 1.5707963267948966 + dw && GeneratorAP.this.phi < 4.71238898038469 - dw) {
                dir = -GeneratorAP.this.direction;
            }
            g.setColor(GeneratorAP.this.current ? GeneratorAP.this.colorCurrent : GeneratorAP.this.BLACK);
            GeneratorAP.this.moveTo(0.0, 0.0, sign * 10);
            this.lineTo(g, 0.0, 120.0, sign * 10);
            this.lineTo(g, 0.0, 120.0, sign * 80);
            this.lineTo(g, 0.0, 280.0, sign * 80);
            this.lineTo(g, 0.0, 280.0, 0.0);
            if (GeneratorAP.this.iArrows && dir != 0 && GeneratorAP.this.T > 0.0) {
                GeneratorAP.this.moveTo(0.0, 200.0, sign * 80);
                this.arrowTo(g, 0.0, 200 - sign * dir * 40, sign * 80);
            }
        }

        void commutator(Graphics2D g) {
            Color c = GeneratorAP.this.current ? GeneratorAP.this.colorCurrent : Color.lightGray;
            CanvasAP.circle(g, 246.0, 204.0, 20.0, c);
            CanvasAP.circle(g, 254.0, 206.0, 20.0, c, true);
            CanvasAP.arc(g, 246.0, 204.0, 20.0, 1.2217304763960306, 3.490658503988659);
            double r = 40.0 - 4.0 * Math.sin(2.0 * GeneratorAP.this.phi);
            double x = r * Math.cos(0.25);
            double z = r * Math.sin(0.25);
            GeneratorAP.this.setPoint(GeneratorAP.this.p3X, GeneratorAP.this.p3Y, 0, x, -10.0, z);
            GeneratorAP.this.setPoint(GeneratorAP.this.p3X, GeneratorAP.this.p3Y, 1, -x, -10.0, z);
            GeneratorAP.this.setPoint(GeneratorAP.this.p3X, GeneratorAP.this.p3Y, 2, -x, -10.0, -z);
            GeneratorAP.this.setPoint(GeneratorAP.this.p3X, GeneratorAP.this.p3Y, 3, x, -10.0, -z);
            CanvasAP.polygon(g, GeneratorAP.this.p3X, GeneratorAP.this.p3Y, GeneratorAP.this.BLACK);
            if (GeneratorAP.this.phi < 1.5707963267948966 || GeneratorAP.this.phi > 4.71238898038469) {
                x = -x;
                z = -z;
            }
            GeneratorAP.this.setPoint(GeneratorAP.this.p4X, GeneratorAP.this.p4Y, 0, x, -10.0, z);
            GeneratorAP.this.setPoint(GeneratorAP.this.p4X, GeneratorAP.this.p4Y, 1, x, -10.0, -z);
            GeneratorAP.this.setPoint(GeneratorAP.this.p4X, GeneratorAP.this.p4Y, 2, x, 10.0, -z);
            GeneratorAP.this.setPoint(GeneratorAP.this.p4X, GeneratorAP.this.p4Y, 3, x, 10.0, z);
            CanvasAP.polygon(g, GeneratorAP.this.p4X, GeneratorAP.this.p4Y, GeneratorAP.this.BLACK);
        }

        void leftRing(Graphics2D g) {
            CanvasAP.circle(g, 254.0, 206.0, 20.0, GeneratorAP.this.colorCurrent);
            CanvasAP.circle(g, 246.0, 204.0, 20.0, GeneratorAP.this.colorCurrent);
            CanvasAP.circle(g, 254.0, 206.0, 15.0, GeneratorAP.this.BLACK);
            CanvasAP.sector(g, 254.0, 206.0, 15.0, 1.2217304763960306, Math.PI, GeneratorAP.this.bgCanvas);
            CanvasAP.sector(g, 246.0, 204.0, 15.0, 4.886921905584122, 2.0943951023931953, GeneratorAP.this.bgCanvas);
            g.setColor(GeneratorAP.this.colorCurrent);
            GeneratorAP.this.moveTo(0.0, 40.0, 10.0);
            this.lineTo(g, 0.0, 0.0, 10.0);
            this.lineTo(g, 0.0, 0.0, 30.0);
            GeneratorAP.this.moveTo(0.0, 40.0, -10.0);
            this.lineTo(g, 0.0, -40.0, -10.0);
            CanvasAP.circle(g, 254.0, 206.0, 20.0, GeneratorAP.this.BLACK, false);
            CanvasAP.arc(g, 246.0, 204.0, 20.0, 1.2217304763960306, 3.490658503988659);
            CanvasAP.circle(g, 254.0, 206.0, 15.0, GeneratorAP.this.BLACK, false);
            double x = 254.0 - 17.5 * GeneratorAP.this.sin;
            double y = 206.0 - 17.5 * GeneratorAP.this.cos;
            CanvasAP.circle(g, x, y, 1.5, Color.white);
        }

        void rightRing(Graphics2D g) {
            CanvasAP.circle(g, 278.0, 212.0, 20.0, GeneratorAP.this.colorCurrent);
            CanvasAP.circle(g, 270.0, 210.0, 20.0, GeneratorAP.this.colorCurrent);
            CanvasAP.circle(g, 278.0, 212.0, 15.0, GeneratorAP.this.BLACK);
            CanvasAP.sector(g, 278.0, 212.0, 15.0, 1.2217304763960306, Math.PI, GeneratorAP.this.bgCanvas);
            CanvasAP.sector(g, 270.0, 210.0, 15.0, 4.886921905584122, 2.0943951023931953, GeneratorAP.this.bgCanvas);
            g.setColor(GeneratorAP.this.colorCurrent);
            GeneratorAP.this.moveTo(0.0, -20.0, -10.0);
            this.lineTo(g, 0.0, -60.0, -10.0);
            this.lineTo(g, 0.0, -60.0, -30.0);
            CanvasAP.circle(g, 278.0, 212.0, 20.0, GeneratorAP.this.BLACK, false);
            CanvasAP.arc(g, 270.0, 210.0, 20.0, 1.2217304763960306, 3.490658503988659);
            CanvasAP.circle(g, 278.0, 212.0, 15.0, GeneratorAP.this.BLACK, false);
            double x = 278.0 - 17.5 * GeneratorAP.this.sin;
            double y = 212.0 - 17.5 * GeneratorAP.this.cos;
            CanvasAP.circle(g, x, y, 1.5, Color.white);
        }

        void crank(Graphics2D g, int y) {
            double xM = 250.0 - 0.4 * (double)y;
            double yM = 205.0 - 0.1 * (double)y;
            CanvasAP.circle(g, xM - 8.0, yM - 2.0, 20.0, GeneratorAP.this.colorCrank);
            CanvasAP.circle(g, xM, yM, 20.0, GeneratorAP.this.colorCrank, true);
            CanvasAP.arc(g, xM - 8.0, yM - 2.0, 20.0, 1.2217304763960306, 3.490658503988659);
            double xKG = xM - 15.0 * GeneratorAP.this.sin;
            double yKG = yM - 15.0 * GeneratorAP.this.cos;
            GeneratorAP.this.p8X[0] = xKG;
            GeneratorAP.this.p8Y[0] = yKG - 2.0;
            GeneratorAP.this.p8X[1] = xKG;
            GeneratorAP.this.p8Y[1] = yKG + 2.0;
            GeneratorAP.this.p8X[2] = xKG + 16.0;
            GeneratorAP.this.p8Y[2] = yKG + 6.0;
            GeneratorAP.this.p8X[3] = xKG + 16.0;
            GeneratorAP.this.p8Y[3] = yKG + 2.0;
            CanvasAP.polygon(g, GeneratorAP.this.p8X, GeneratorAP.this.p8Y, GeneratorAP.this.colorCrank);
            CanvasAP.circle(g, xKG + 16.0, yKG + 4.0, 2.0, GeneratorAP.this.colorCrank);
            g.setColor(GeneratorAP.this.BLACK);
            CanvasAP.line(g, xKG, yKG - 2.0, xKG + 16.0, yKG + 2.0);
            CanvasAP.line(g, xKG, yKG + 2.0, xKG + 16.0, yKG + 6.0);
            CanvasAP.arc(g, xKG, yKG, 2.0, 1.5707963267948966, Math.PI);
            CanvasAP.circle(g, xKG + 16.0, yKG + 4.0, 2.0, GeneratorAP.this.BLACK, false);
        }

        void contact1(Graphics2D g) {
            Color c = GeneratorAP.this.current ? GeneratorAP.this.colorCurrent : Color.lightGray;
            CanvasAP.polygon(g, GeneratorAP.this.p5X, GeneratorAP.this.p5Y, c, true);
            CanvasAP.line(g, 249.0, 177.0, 249.0, 187.0);
            CanvasAP.line(g, 249.0, 177.0, 241.0, 175.0);
            CanvasAP.line(g, 249.0, 177.0, 259.0, 175.0);
        }

        void contact2(Graphics2D g) {
            Color c = GeneratorAP.this.current ? GeneratorAP.this.colorCurrent : Color.lightGray;
            CanvasAP.polygon(g, GeneratorAP.this.p6X, GeneratorAP.this.p6Y, c, true);
            CanvasAP.line(g, 249.0, 227.0, 249.0, 237.0);
            CanvasAP.line(g, 249.0, 227.0, 241.0, 225.0);
            CanvasAP.line(g, 249.0, 227.0, 259.0, 225.0);
        }

        void contact3(Graphics2D g) {
            CanvasAP.polygon(g, GeneratorAP.this.p7X, GeneratorAP.this.p7Y, GeneratorAP.this.colorCurrent, true);
            CanvasAP.line(g, 273.0, 233.0, 273.0, 243.0);
            CanvasAP.line(g, 273.0, 233.0, 265.0, 231.0);
            CanvasAP.line(g, 273.0, 233.0, 283.0, 231.0);
        }

        void voltmeter(Graphics2D g, double u) {
            double wMax = 0.4;
            double lZ = 200.0;
            if (!GeneratorAP.this.current) {
                u = 0.0;
            }
            CanvasAP.polygon(g, GeneratorAP.this.pVM2X, GeneratorAP.this.pVM2Y, Color.white, true);
            g.setColor(GeneratorAP.this.BLACK);
            CanvasAP.line(g, 2.0, 407.0, 173.0, 404.0, 167.0);
            CanvasAP.line(g, 2.0, 427.0, 163.0, 426.0, 156.0);
            g.drawString("0", 444, 158);
            CanvasAP.line(g, 2.0, 469.0, 155.0, 470.0, 147.0);
            CanvasAP.line(g, 2.0, 489.0, 157.0, 492.0, 149.0);
            double xx = 300.0 + lZ * Math.sin(u * wMax);
            double zz = -150.0 + lZ * Math.cos(u * wMax);
            GeneratorAP.this.x1 = 298.0 + 0.5 * xx;
            GeneratorAP.this.y1 = 217.0 - 0.1 * xx - 0.5 * zz;
            CanvasAP.line(g, 2.0, 448.0, 262.0, GeneratorAP.this.x1, GeneratorAP.this.y1);
            CanvasAP.polygon(g, GeneratorAP.this.pVM1X, GeneratorAP.this.pVM1Y, GeneratorAP.this.colorVoltage, true);
            CanvasAP.line(g, 398.0, 297.0, 398.0, 247.0);
            CanvasAP.line(g, 398.0, 147.0, 358.0, 137.0);
            CanvasAP.circle(g, 423.0, 272.0, 3.5, GeneratorAP.this.BLACK);
            CanvasAP.circle(g, 473.0, 262.0, 3.5, GeneratorAP.this.BLACK);
            CanvasAP.line(g, 3.0, 468.0, 246.0, 478.0, 244.0);
            CanvasAP.line(g, 3.0, 473.0, 240.0, 473.0, 250.0);
            CanvasAP.line(g, 3.0, 418.0, 256.0, 428.0, 254.0);
            CanvasAP.line(g, 3.0, 448.0, 270.0, 444.0, 255.0);
            CanvasAP.line(g, 3.0, 448.0, 270.0, 452.0, 254.0);
            if (!GeneratorAP.this.iArrows) {
                return;
            }
            g.setColor(GeneratorAP.this.colorCurrent);
            if (u > 0.0) {
                GeneratorAP.this.x0 = 331.0;
                GeneratorAP.this.y0 = 294.0;
                this.arrowTo(g, 326.0, 295.0);
                GeneratorAP.this.x0 = 295.0;
                GeneratorAP.this.y0 = 136.0;
                this.arrowTo(g, 300.0, 135.0);
            }
            if (u < 0.0) {
                GeneratorAP.this.x0 = 326.0;
                GeneratorAP.this.y0 = 295.0;
                this.arrowTo(g, 331.0, 294.0);
                GeneratorAP.this.x0 = 300.0;
                GeneratorAP.this.y0 = 135.0;
                this.arrowTo(g, 295.0, 136.0);
            }
        }

        void wires1(Graphics2D g) {
            g.setColor(GeneratorAP.this.current ? GeneratorAP.this.colorCurrent : GeneratorAP.this.BLACK);
            GeneratorAP.this.x0 = 250.0;
            GeneratorAP.this.y0 = 175.0;
            this.lineTo(g, 250, 145);
            this.lineTo(g, 350, 125);
            this.lineTo(g, 350, 265);
            this.lineTo(g, 460, 243);
            this.lineTo(g, 516, 257);
        }

        void wiresDC2(Graphics2D g) {
            Color c = GeneratorAP.this.current ? GeneratorAP.this.colorCurrent : GeneratorAP.this.BLACK;
            g.setColor(c);
            GeneratorAP.this.x0 = 516.0;
            GeneratorAP.this.y0 = 257.0;
            this.lineTo(g, 481, 264);
            this.lineTo(g, 473, 262);
            GeneratorAP.this.x0 = 250.0;
            GeneratorAP.this.y0 = 236.0;
            this.lineTo(g, 250, 285);
            this.lineTo(g, 306, 299);
            this.lineTo(g, 431, 274);
            this.lineTo(g, 423, 272);
            CanvasAP.line(g, 2.5, 250.0, 285.0, 287.0, 278.0);
            CanvasAP.line(g, 2.5, 333.0, 268.0, 350.0, 265.0);
            CanvasAP.circle(g, 250.0, 285.0, 4.0, c);
            CanvasAP.circle(g, 350.0, 265.0, 4.0, c);
        }

        void wiresAC2(Graphics2D g) {
            g.setColor(GeneratorAP.this.colorCurrent);
            GeneratorAP.this.x0 = 516.0;
            GeneratorAP.this.y0 = 257.0;
            this.lineTo(g, 481, 264);
            this.lineTo(g, 473, 262);
            GeneratorAP.this.x0 = 274.0;
            GeneratorAP.this.y0 = 242.0;
            this.lineTo(g, 274, 291);
            this.lineTo(g, 306, 299);
            this.lineTo(g, 431, 274);
            this.lineTo(g, 423, 272);
            GeneratorAP.this.x0 = 274.0;
            GeneratorAP.this.y0 = 291.0;
            this.lineTo(g, 250, 285);
            this.lineTo(g, 287, 278);
            CanvasAP.line(g, 2.5, 333.0, 268.0, 350.0, 265.0);
            CanvasAP.circle(g, 274.0, 291.0, 4.0, GeneratorAP.this.colorCurrent);
            CanvasAP.circle(g, 350.0, 265.0, 4.0, GeneratorAP.this.colorCurrent);
            g.setColor(GeneratorAP.this.bgCanvas);
            CanvasAP.line(g, 272.0, 265.0, 272.0, 285.0);
            CanvasAP.line(g, 276.0, 265.0, 276.0, 285.0);
        }

        void resistor(Graphics2D g) {
            CanvasAP.polygon(g, GeneratorAP.this.pRX, GeneratorAP.this.pRY, GeneratorAP.this.colorResistor);
            CanvasAP.ellipse(g, 325.0, 270.0, 8.0, 10.0, GeneratorAP.this.colorResistor);
            CanvasAP.ellipse(g, 288.0, 277.0, 8.0, 10.0, GeneratorAP.this.colorResistor, true);
            CanvasAP.ellArc(g, 325.0, 270.0, 8.0, 10.0, 4.71238898038469, Math.PI);
            CanvasAP.line(g, 288.0, 267.0, 325.0, 260.0);
            CanvasAP.line(g, 288.0, 287.0, 325.0, 280.0);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(GeneratorAP.this.symbolResistance, 300, 260);
            CanvasAP.setAntiAliasing(g, true);
        }

        void diagram(Graphics2D g, int x, int y) {
            double x0;
            int i;
            double pixT = 4.0;
            g.setColor(GeneratorAP.this.BLACK);
            CanvasAP.arrow(g, x - 10, y, x + 215, y);
            for (i = 1; i <= 5; ++i) {
                CanvasAP.line(g, x + i * 40, y - 3, x + i * 40, y + 3);
            }
            CanvasAP.arrow(g, x, y + 45, x, y - 45);
            for (i = -2; i <= 2; ++i) {
                CanvasAP.line(g, x - 3, y + i * 15, x + 3, y + i * 15);
            }
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(GeneratorAP.this.symbolTime, x + 210, y + 15);
            g.drawString(GeneratorAP.this.symbolVoltage, x - 15, y - 35);
            CanvasAP.setAntiAliasing(g, true);
            double A = GeneratorAP.this.T > 0.0 ? 150.0 / GeneratorAP.this.T : 0.0;
            double x1 = x;
            double y1 = (double)y - (double)GeneratorAP.this.direction * A;
            while (x1 < (double)(x + 200)) {
                x0 = x1;
                double y0 = y1;
                x1 = x0 + 1.0;
                double alpha = (x1 - (double)x) * (Math.PI * 2) / (GeneratorAP.this.T * 4.0);
                double u = A * Math.cos(alpha);
                if (GeneratorAP.this.genDC) {
                    u = Math.abs(u);
                }
                if ((y1 = (double)y - (double)GeneratorAP.this.direction * u) < (double)(y + 4) && y1 > (double)(y - 4) && GeneratorAP.this.T < 10.0 && GeneratorAP.this.genDC) {
                    y1 = y;
                }
                CanvasAP.line(g, x0, y0, x1, y1);
            }
            x0 = (double)x + GeneratorAP.this.t * 4.0;
            double u = A * GeneratorAP.this.cos;
            if (GeneratorAP.this.genDC) {
                u = Math.abs(u);
            }
            double y0 = (double)y - (double)GeneratorAP.this.direction * u;
            CanvasAP.circle(g, x0, y0, 2.5, GeneratorAP.this.colorVoltage, true);
        }

        void movementArrow(Graphics2D g, int i) {
            if (!GeneratorAP.this.vArrows || GeneratorAP.this.T <= 0.0) {
                return;
            }
            int z = 240 - i * 160;
            int dir = (3 - 2 * i) * GeneratorAP.this.direction;
            g.setColor(GeneratorAP.this.colorMotion);
            GeneratorAP.this.moveTo(0.0, 200.0, z);
            this.arrowTo(g, -dir * 50, 200.0, z);
        }

        void fieldLines(Graphics2D g, int i) {
            if (!GeneratorAP.this.bArrows) {
                return;
            }
            int begin = 0;
            int end = 0;
            switch (i) {
                case 0: {
                    end = 2;
                    begin = 2;
                    break;
                }
                case 1: {
                    begin = 0;
                    end = 1;
                    break;
                }
                case 2: {
                    begin = 3;
                    end = 4;
                }
            }
            g.setColor(GeneratorAP.this.colorField);
            for (i = begin; i <= end; ++i) {
                GeneratorAP.this.x0 = 130 + i * 20;
                GeneratorAP.this.y0 = 112 + i * 5;
                CanvasAP.line(g, 2.5, GeneratorAP.this.x0, GeneratorAP.this.y0, GeneratorAP.this.x0, GeneratorAP.this.y0 + 138.0);
                this.arrowTo(g, GeneratorAP.this.x0, GeneratorAP.this.y0 + 18.0);
                this.arrowTo(g, GeneratorAP.this.x0, GeneratorAP.this.y0 + 105.0);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            double dw = GeneratorAP.this.genDC ? 0.3 : 0.0;
            GeneratorAP.this.current = true;
            if (GeneratorAP.this.phi > 1.5707963267948966 - dw && GeneratorAP.this.phi < 1.5707963267948966 + dw) {
                boolean bl = GeneratorAP.this.current = !GeneratorAP.this.genDC;
            }
            if (GeneratorAP.this.phi > 4.71238898038469 - dw && GeneratorAP.this.phi < 4.71238898038469 + dw) {
                GeneratorAP.this.current = !GeneratorAP.this.genDC;
            }
            this.magnet(g2);
            int qu = (int)(GeneratorAP.this.phi / 1.5707963267948966);
            if (GeneratorAP.this.direction == -1) {
                qu = qu % 2 == 0 ? qu + 1 : qu - 1;
            }
            switch (qu) {
                case 0: {
                    this.movementArrow(g2, 2);
                    this.halfArmature(g2, 2);
                    this.fieldLines(g2, 1);
                    this.fieldLines(g2, 0);
                    this.fieldLines(g2, 2);
                    this.halfArmature(g2, 1);
                    this.movementArrow(g2, 1);
                    break;
                }
                case 1: {
                    this.halfArmature(g2, 2);
                    this.fieldLines(g2, 1);
                    this.fieldLines(g2, 0);
                    this.movementArrow(g2, 2);
                    this.movementArrow(g2, 1);
                    this.fieldLines(g2, 2);
                    this.halfArmature(g2, 1);
                    break;
                }
                case 2: {
                    this.movementArrow(g2, 1);
                    this.halfArmature(g2, 1);
                    this.fieldLines(g2, 1);
                    this.fieldLines(g2, 0);
                    this.fieldLines(g2, 2);
                    this.halfArmature(g2, 2);
                    this.movementArrow(g2, 2);
                    break;
                }
                case 3: {
                    this.halfArmature(g2, 1);
                    this.fieldLines(g2, 1);
                    this.fieldLines(g2, 0);
                    this.movementArrow(g2, 1);
                    this.movementArrow(g2, 2);
                    this.fieldLines(g2, 2);
                    this.halfArmature(g2, 2);
                }
            }
            if (GeneratorAP.this.genDC) {
                this.contact2(g2);
                this.commutator(g2);
                this.contact1(g2);
                this.resistor(g2);
                this.wires1(g2);
                this.crank(g2, -100);
                this.voltmeter(g2, GeneratorAP.this.T > 0.0 ? (double)(GeneratorAP.this.direction * 5) / GeneratorAP.this.T * Math.abs(GeneratorAP.this.cos) : 0.0);
                this.wiresDC2(g2);
            } else {
                this.contact3(g2);
                this.leftRing(g2);
                this.rightRing(g2);
                this.contact1(g2);
                this.resistor(g2);
                this.wires1(g2);
                this.crank(g2, -160);
                this.voltmeter(g2, GeneratorAP.this.T > 0.0 ? (double)(GeneratorAP.this.direction * 5) / GeneratorAP.this.T * GeneratorAP.this.cos : 0.0);
                this.wiresAC2(g2);
            }
            this.diagram(g2, 300, 65);
        }
    }
}

