/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class DoubleSlitAP
extends AP6
implements AdjustmentListener {
    static final String[][] text = new String[][]{{"de", "Interferenz von Licht am Doppelspalt", "Wellenl\u00e4nge:", "Spaltabstand:", "Winkel:", "Maxima:", "Minima:", "Relative Intensit\u00e4t:", "Interferenzmuster", "Intensit\u00e4tsverteilung", ""}, {"en", "Interference of Light at a Double Slit", "Wavelength:", "Spacing between slits:", "Angle:", "Maxima:", "Minima:", "Relative intensity:", "Interference pattern", "Intensity profile", ""}};
    private int[] gaps = new int[]{10, 5, 10, 5, 10, 5, 10, 5, 10, 5, 5, 20, 0, 10};
    final int width = 720;
    final int height = 440;
    final int width0 = 440;
    final int height1 = 300;
    FontMetrics fmH;
    CanvasAP1 cv1;
    CanvasAP2 cv2;
    Panel6 pan;
    JTextField tfLambda;
    JTextField tfD;
    JTextField tfAlpha;
    JScrollBar scrLambda;
    JScrollBar scrD;
    JScrollBar scrAlpha;
    JRadioButton rb1;
    JRadioButton rb2;
    JComboBox coMax;
    JComboBox coMin;
    JLabel lbI;
    final Color BLACK = Color.black;
    final Color WHITE = Color.white;
    Color bgCanvas1;
    Color bgCanvas2;
    Color bgPanel;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    final int MAX = 90;
    final double RAD = 200.0;
    int xM;
    int yM;
    double lambda;
    double d;
    double alpha;
    double minAlpha;
    double theta;
    double phi;
    double a1;
    double a2;
    double b1;
    double b2;
    double b3;
    double[] poly1X;
    double[] poly1Y;
    double[] poly2X;
    double[] poly2Y;
    double[] poly3X;
    double[] poly3Y;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(720, 440);
    }

    @Override
    protected void initAttributes() {
        this.xM = 210;
        this.yM = 200;
        this.lambda = 6.000000000000001E-7;
        this.d = 1.0000000000000002E-6;
        this.alpha = 0.30543261909900765;
        this.theta = 3.490658503988659;
        this.phi = 0.6981317007977318;
        this.calcCoeff();
        this.setPolygons();
    }

    @Override
    protected void initColors() {
        this.bgCanvas1 = this.getColor(Color.darkGray, "bgCanvas1");
        this.bgCanvas2 = this.getColor(Color.yellow, "bgCanvas2");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.coauthor = this.getText(t[10], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv1 = new CanvasAP1(this);
        this.cv1.setBounds(0, 0, 440, 300);
        this.add(this.cv1);
        this.cv2 = new CanvasAP2(this);
        this.cv2.setBounds(0, 300, 440, 140);
        this.add(this.cv2);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(440, 0, 280, 440);
        boolean HOR = false;
        this.tfLambda = this.pan.newInputField(this.text01, this.nanometer, this.WHITE, this.BLACK, 2);
        this.tfLambda.setText(this.toString(1.0E9 * this.lambda, 0));
        this.scrLambda = new JScrollBar(0, 220, 50, 0, 450);
        this.pan.add(this.scrLambda, Color.gray, this.BLACK);
        this.tfD = this.pan.newInputField(this.text02, this.nanometer, this.WHITE, this.BLACK, 2);
        this.tfD.setText(this.toString(1.0E9 * this.d, 0));
        this.scrD = new JScrollBar(0, 500, 100, 0, 4600);
        this.pan.add(this.scrD, Color.gray, this.BLACK);
        this.tfAlpha = this.pan.newInputField(this.text03, this.degree, this.WHITE, this.BLACK, 2);
        this.tfAlpha.setText(this.toString(this.alpha / (Math.PI / 180), 1));
        this.scrAlpha = new JScrollBar(0, 175, 100, 0, 1000);
        this.pan.add(this.scrAlpha, Color.gray, this.BLACK);
        JLabel lb = new JLabel(this.text04);
        this.pan.add(lb, this.bgPanel, 0, 1, 10, 0);
        this.coMax = new JComboBox();
        this.pan.add(this.coMax, this.WHITE, 1, 2, 0, 10);
        lb = new JLabel(this.text05);
        this.pan.add(lb, this.bgPanel, 0, 1, 10, 0);
        this.coMin = new JComboBox();
        this.pan.add(this.coMin, this.WHITE, 1, 2, 0, 10);
        this.updateMaxMin();
        this.lbI = this.pan.newOutputField(this.text06, "", this.bgPanel, this.BLACK, 2);
        this.lbI.setText(this.toString(this.intensity(this.alpha), 3));
        ButtonGroup bg = new ButtonGroup();
        this.rb1 = this.pan.newRadioButton(this.text07, true, bg);
        this.rb2 = this.pan.newRadioButton(this.text08, false, bg);
        this.pan.add(2003);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.scrLambda.addAdjustmentListener(this);
        this.scrD.addAdjustmentListener(this);
        this.scrAlpha.addAdjustmentListener(this);
        this.coMax.addActionListener(this);
        this.coMin.addActionListener(this);
    }

    @Override
    public void run() {
    }

    void setPolygons() {
        this.poly1X = new double[4];
        this.poly1Y = new double[4];
        this.setPoint(this.poly1X, this.poly1Y, 0, 0.0, 50.0, 50.0);
        this.setPoint(this.poly1X, this.poly1Y, 1, 0.0, -50.0, 50.0);
        this.setPoint(this.poly1X, this.poly1Y, 2, 0.0, -50.0, -50.0);
        this.setPoint(this.poly1X, this.poly1Y, 3, 0.0, 50.0, -50.0);
        this.poly2X = new double[362];
        this.poly2Y = new double[362];
        for (int i = 0; i <= 180; ++i) {
            double w = (double)(i - 90) * (Math.PI / 180);
            double cos = 200.0 * Math.cos(w);
            double sin = 200.0 * Math.sin(w);
            this.setPoint(this.poly2X, this.poly2Y, i, cos, sin, 50.0);
            this.setPoint(this.poly2X, this.poly2Y, 361 - i, cos, sin, -50.0);
        }
        this.minAlpha = Math.atan(this.a2 / this.a1);
        int i0 = (int)Math.round(-this.minAlpha / (Math.PI / 180));
        this.poly3X = new double[(90 - i0 + 1) * 2];
        this.poly3Y = new double[(90 - i0 + 1) * 2];
        for (int i = 0; i <= 90 - i0; ++i) {
            double w = (double)(i - 90) * (Math.PI / 180);
            double cos = 200.0 * Math.cos(w);
            double sin = 200.0 * Math.sin(w);
            this.setPoint(this.poly3X, this.poly3Y, i, cos, sin, 50.0);
            this.setPoint(this.poly3X, this.poly3Y, 2 * (90 - i0) + 1 - i, cos, sin, -50.0);
        }
    }

    void updateMaxMin() {
        String s;
        double w;
        int k;
        this.coMax.removeAllItems();
        this.coMin.removeAllItems();
        int maxK = (int)(this.d / this.lambda);
        for (k = 0; k <= maxK; ++k) {
            w = Math.asin((double)k * this.lambda / this.d) / (Math.PI / 180);
            s = this.toString(w, 1) + this.degree + "  (k = " + k + ")";
            this.coMax.addItem(s);
        }
        maxK = (int)(this.d / this.lambda + 0.5);
        for (k = 1; k <= maxK; ++k) {
            w = Math.asin(((double)k - 0.5) * this.lambda / this.d) / (Math.PI / 180);
            s = this.toString(w, 1) + this.degree + "  (k = " + k + ")";
            this.coMin.addItem(s);
        }
    }

    void calcCoeff() {
        this.a1 = -Math.sin(this.theta);
        this.a2 = Math.cos(this.theta);
        this.b1 = -Math.sin(this.phi) * this.a2;
        this.b2 = Math.sin(this.phi) * this.a1;
        this.b3 = Math.cos(this.phi);
    }

    double screenU(double x, double y) {
        return (double)this.xM + this.a1 * x + this.a2 * y;
    }

    double screenV(double x, double y, double z) {
        return (double)this.yM - this.b1 * x - this.b2 * y - this.b3 * z;
    }

    void setPoint(double[] px, double[] py, int i, double x, double y, double z) {
        px[i] = this.screenU(x, y);
        py[i] = this.screenV(x, y, z);
    }

    double intensity(double x) {
        double c = this.d * 2.0 * Math.PI / this.lambda;
        return (1.0 + Math.cos(c * Math.sin(x))) / 2.0;
    }

    void arrowDown(Graphics2D g, double x, double y) {
        g.setColor(this.WHITE);
        Canvas6.arrow(g, x, y, x, y + 20.0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int k;
        boolean co;
        Object o = ae.getSource();
        boolean bl = co = o == this.coMax || o == this.coMin;
        if (o == this.coMax) {
            k = this.coMax.getSelectedIndex();
            this.alpha = Math.asin((double)k * this.lambda / this.d);
        }
        if (o == this.coMin) {
            k = this.coMin.getSelectedIndex();
            this.alpha = Math.asin(((double)k + 0.5) * this.lambda / this.d);
        }
        this.lambda = 1.0E-9 * this.inputTF(this.tfLambda, 380.0, 780.0, 0);
        int u = (int)Math.round(this.lambda / 1.0E-9 - 380.0);
        this.scrLambda.setValue(u);
        this.d = 1.0E-9 * this.inputTF(this.tfD, 500.0, 5000.0, 0);
        u = (int)Math.round(this.d / 1.0E-9 - 500.0);
        this.scrD.setValue(u);
        if (!co) {
            this.alpha = Math.PI / 180 * this.inputTF(this.tfAlpha, 0.0, 90.0, 1);
        }
        u = (int)Math.round(this.alpha * 10.0 / (Math.PI / 180));
        this.scrAlpha.setValue(u);
        this.lbI.setText(this.toString(this.intensity(this.alpha), 3));
        if (o == this.tfLambda || o == this.tfD) {
            this.updateMaxMin();
        }
        this.cv1.repaint();
        this.cv2.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        Object o = ae.getSource();
        if (o == this.scrLambda) {
            this.lambda = (double)(380 + this.scrLambda.getValue()) * 1.0E-9;
            this.tfLambda.setText(this.toString(1.0E9 * this.lambda, 0));
        } else if (o == this.scrD) {
            this.d = (double)(500 + this.scrD.getValue()) * 1.0E-9;
            this.tfD.setText(this.toString(1.0E9 * this.d, 0));
        } else if (o == this.scrAlpha) {
            this.alpha = (double)this.scrAlpha.getValue() * (Math.PI / 180) / 10.0;
            this.tfAlpha.setText(this.toString(this.alpha / (Math.PI / 180), 1));
        }
        if (o == this.scrLambda || o == this.scrD) {
            this.updateMaxMin();
        }
        this.lbI.setText(this.toString(this.intensity(this.alpha), 3));
        this.cv1.repaint();
        this.cv2.repaint();
    }

    class CanvasAP2
    extends Canvas6 {
        CanvasAP2(AP6 ap) {
            super(ap, DoubleSlitAP.this.bgCanvas2);
            DoubleSlitAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void horAxis(Graphics2D g, int u, int v) {
            CanvasAP2.arrow(g, u, v, u + 190, v);
            CanvasAP2.arrow(g, u, v, u - 190, v);
            for (int i = -3; i <= 3; ++i) {
                int u0 = u + 55 * i;
                CanvasAP2.line(g, u0, v - 2, u0, v + 2);
                String s = "" + Math.abs(i) * 30;
                u0 = u + 55 * i - DoubleSlitAP.this.fmH.stringWidth(s) / 2;
                CanvasAP2.setAntiAliasing(g, false);
                g.drawString(s + DoubleSlitAP.this.degree, u0, v + 18);
                CanvasAP2.setAntiAliasing(g, true);
            }
        }

        void paintPattern(Graphics2D g) {
            int uM = 220;
            int v1 = 60;
            int v2 = 90;
            int w = 330;
            double pixX = (double)w / Math.PI;
            CanvasAP2.rectangle(g, 20.0, v1 - 40, 400.0, 100.0, DoubleSlitAP.this.BLACK);
            for (int i = uM - w / 2; i <= uM + w / 2; ++i) {
                double x = (double)(uM - i) / pixX;
                g.setColor(Spectrum.color(DoubleSlitAP.this.lambda, DoubleSlitAP.this.intensity(x)));
                CanvasAP2.line(g, i, v1 - 1, i, v1 + 1);
            }
            double i = DoubleSlitAP.this.alpha * pixX;
            DoubleSlitAP.this.arrowDown(g, (double)uM - i, v1 - 30);
            DoubleSlitAP.this.arrowDown(g, (double)uM + i, v1 - 30);
            this.horAxis(g, uM, 90);
        }

        void paintIntensity(Graphics2D g) {
            double v0;
            int uM = 220;
            int vM = 110;
            g.setColor(DoubleSlitAP.this.BLACK);
            this.horAxis(g, uM, vM);
            CanvasAP2.arrow(g, uM, vM + 5, uM, vM - 100);
            int w = 330;
            double pixX = (double)w / Math.PI;
            double pixY = 80.0;
            double u1 = uM - w / 2;
            double x = -1.5707963267948966;
            double y = DoubleSlitAP.this.intensity(x);
            double v1 = (double)vM - y * pixY;
            while (u1 < (double)(uM + w / 2)) {
                double u0 = u1;
                v0 = v1;
                x = ((u1 += 1.0) - (double)uM) / pixX;
                y = DoubleSlitAP.this.intensity(x);
                v1 = (double)vM - y * pixY;
                CanvasAP2.line(g, u0, v0, u1, v1);
            }
            double du = pixX * DoubleSlitAP.this.alpha;
            v0 = (double)vM - DoubleSlitAP.this.intensity(DoubleSlitAP.this.alpha) * pixY;
            CanvasAP2.circle(g, (double)uM + du, v0, 2.5, Color.red);
            CanvasAP2.circle(g, (double)uM - du, v0, 2.5, Color.red);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP2.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            if (DoubleSlitAP.this.rb1.isSelected()) {
                this.paintPattern(g2);
            } else {
                this.paintIntensity(g2);
            }
        }
    }

    class CanvasAP1
    extends Canvas6 {
        CanvasAP1(AP6 ap) {
            super(ap, DoubleSlitAP.this.bgCanvas1);
            DoubleSlitAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void screenLeft(Graphics2D g) {
            CanvasAP1.polygon(g, DoubleSlitAP.this.poly2X, DoubleSlitAP.this.poly2Y, DoubleSlitAP.this.BLACK, true);
            for (int i = -360; i <= 360; ++i) {
                double w = (double)i * (Math.PI / 180) / 4.0;
                double x = 200.0 * Math.cos(w);
                double y = 200.0 * Math.sin(w);
                double u0 = DoubleSlitAP.this.screenU(x, y);
                double v0 = DoubleSlitAP.this.screenV(x, y, 0.0);
                g.setColor(Spectrum.color(DoubleSlitAP.this.lambda, DoubleSlitAP.this.intensity(w)));
                CanvasAP1.line(g, u0, v0 - 1.0, u0, v0 + 1.0);
            }
            g.setColor(DoubleSlitAP.this.WHITE);
            double x = 200.0 * Math.cos(DoubleSlitAP.this.alpha);
            double y = 200.0 * Math.sin(DoubleSlitAP.this.alpha);
            double u0 = DoubleSlitAP.this.screenU(x, y);
            double v0 = DoubleSlitAP.this.screenV(x, y, 35.0);
            DoubleSlitAP.this.arrowDown(g, u0, v0);
            if (-DoubleSlitAP.this.alpha > DoubleSlitAP.this.minAlpha) {
                u0 = DoubleSlitAP.this.screenU(x, -y);
                v0 = DoubleSlitAP.this.screenV(x, -y, 35.0);
                DoubleSlitAP.this.arrowDown(g, u0, v0);
            }
        }

        void screenRight(Graphics2D g) {
            CanvasAP1.polygon(g, DoubleSlitAP.this.poly3X, DoubleSlitAP.this.poly3Y, DoubleSlitAP.this.BLACK, true);
            double x = 200.0 * Math.cos(DoubleSlitAP.this.minAlpha);
            double y = 200.0 * Math.sin(DoubleSlitAP.this.minAlpha);
            double u0 = DoubleSlitAP.this.screenU(x, y);
            CanvasAP1.rectangle(g, u0, 0.0, 10.0, 300.0, DoubleSlitAP.this.bgCanvas1);
        }

        void raysMaxima(Graphics2D g) {
            g.setColor(Spectrum.color(DoubleSlitAP.this.lambda));
            int maxK = (int)(DoubleSlitAP.this.d / DoubleSlitAP.this.lambda);
            for (int k = -maxK; k <= maxK; ++k) {
                double w = Math.asin((double)k * DoubleSlitAP.this.lambda / DoubleSlitAP.this.d);
                double x = 200.0 * Math.cos(w);
                double y = 200.0 * Math.sin(w);
                double u0 = DoubleSlitAP.this.screenU(x, y);
                double v0 = DoubleSlitAP.this.screenV(x, y, 0.0);
                CanvasAP1.line(g, 2.0, DoubleSlitAP.this.xM, DoubleSlitAP.this.yM, u0, v0);
            }
        }

        void doubleSlit(Graphics2D g) {
            CanvasAP1.polygon(g, DoubleSlitAP.this.poly1X, DoubleSlitAP.this.poly1Y, Color.gray, true);
            double f = 2.0E-6;
            double u0 = Math.max(DoubleSlitAP.this.screenU(0.0, -DoubleSlitAP.this.d / 2.0E-6), (double)(DoubleSlitAP.this.xM + 1));
            double v0 = DoubleSlitAP.this.screenV(0.0, -DoubleSlitAP.this.d / 2.0E-6, -20.0);
            double v1 = DoubleSlitAP.this.screenV(0.0, -DoubleSlitAP.this.d / 2.0E-6, 20.0);
            CanvasAP1.line(g, u0, v0, u0, v1);
            u0 = Math.min(DoubleSlitAP.this.screenU(0.0, DoubleSlitAP.this.d / 2.0E-6), (double)(DoubleSlitAP.this.xM - 1));
            v0 = DoubleSlitAP.this.screenV(0.0, DoubleSlitAP.this.d / 2.0E-6, -20.0);
            v1 = DoubleSlitAP.this.screenV(0.0, DoubleSlitAP.this.d / 2.0E-6, 20.0);
            CanvasAP1.line(g, u0, v0, u0, v1);
        }

        void rayBefore(Graphics2D g) {
            double u0 = DoubleSlitAP.this.screenU(-200.0, 0.0);
            double v0 = DoubleSlitAP.this.screenV(-200.0, 0.0, 0.0);
            g.setColor(Spectrum.color(DoubleSlitAP.this.lambda));
            CanvasAP1.line(g, 4.0, DoubleSlitAP.this.xM, DoubleSlitAP.this.yM, u0, v0);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setClip(2, 2, 436, 296);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP1.setAntiAliasing(g2, true);
            this.screenLeft(g2);
            this.raysMaxima(g2);
            this.screenRight(g2);
            this.doubleSlit(g2);
            this.rayBefore(g2);
        }
    }
}

