/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class InterferenceAP
extends AP6
implements MouseMotionListener {
    static final String[][] text = new String[][]{{"de", "Interferenz zweier Kreis- oder Kugelwellen", "Pause", "Weiter", "Zeitlupe", "Entfernung der beiden Wellen-", "zentren:", "Wellenl\u00e4nge:", "Gangunterschied:", "Konstruktive Interferenz (Amplitude maximal)", "Destruktive Interferenz (Amplitude minimal)", ""}, {"en", "Interference of two Circular or Spherical Waves", "Pause", "Resume", "Slow motion", "Distance of the two", "sources:", "Wavelength:", "Difference of path lengths:", "Constructive interference (maximal amplitude)", "Destructive interference (minimal amplitude)", ""}};
    private int[] gaps = new int[]{10, 10, 10, 0, 10, 80, 0, 10};
    final int width = 600;
    final int height = 360;
    final int width0 = 400;
    final int height0 = 300;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    StartButton buPause;
    JCheckBox cbSlow;
    JTextField tfD;
    JTextField tfLambda;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton;
    Color color1;
    Color color2;
    Color colorPoint;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    final int umr = 10;
    final double T = 5.0;
    final int nHyp = 90;
    final double dPhi = Math.PI / 90;
    int xM;
    int yM;
    boolean on;
    boolean slow;
    double t;
    double phi;
    double dC;
    double lambda;
    double lambdaPixel;
    int xC1;
    int xC2;
    int yC;
    int nCircles;
    int xP;
    int yP;
    double ds;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 360);
    }

    @Override
    protected void initAttributes() {
        this.xM = 200;
        this.yC = this.yM = 150;
        this.dC = 10.0;
        this.lambda = 4.0;
        this.xP = this.xM;
        this.yP = this.yM - 50;
        this.ds = 0.0;
        this.calculation();
        this.calcDiff();
        this.on = true;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton = this.getColor(Color.yellow, "colorButton");
        this.color1 = this.getColor(Color.red, "color1");
        this.color2 = this.getColor(Color.blue, "color2");
        this.colorPoint = this.getColor(Color.magenta, "colorPoint");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.coauthor = this.getText(t[11], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 400, 360);
        this.add(this.cv);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(400, 0, 200, 360);
        this.buPause = new StartButton("", this.text01, this.text02);
        this.buPause.setState(1);
        this.pan.add(this.buPause, this.colorButton, Color.black);
        this.cbSlow = new JCheckBox(this.text03);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        this.pan.add(this.text04);
        this.tfD = this.pan.newInputField(this.text05, this.centimeter, this.bgPanel, Color.black, 2);
        this.tfD.setText(this.toString(this.dC, 1));
        this.tfLambda = this.pan.newInputField(this.text06, this.centimeter, this.bgPanel, Color.black, 2);
        this.tfLambda.setText(this.toString(this.lambda, 1));
        this.pan.add(1999);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.buPause.addActionListener(this);
        this.cbSlow.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            double dt = (double)(t1 - t0) / 1000.0;
            if (this.slow) {
                dt /= 5.0;
            }
            if (this.on) {
                this.t += dt;
            }
            t0 = t1;
        }
    }

    void calculation() {
        int d0 = (int)Math.round(10.0 * this.dC / 2.0);
        double dx = 150.0;
        double dy = (this.dC * 10.0 + 600.0) / 2.0;
        this.xC1 = this.xM - d0;
        this.xC2 = this.xM + d0;
        this.lambdaPixel = this.lambda * 10.0;
        this.nCircles = (int)(Math.sqrt(dx * dx + dy * dy) / this.lambdaPixel);
    }

    void calcDiff() {
        int dx1 = this.xP - this.xC1;
        int dx2 = this.xP - this.xC2;
        int dy = this.yP - this.yC;
        double s1 = Math.sqrt(dx1 * dx1 + dy * dy);
        double s2 = Math.sqrt(dx2 * dx2 + dy * dy);
        this.ds = Math.abs(s1 - s2);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.buPause) {
            this.on = !this.on;
            this.buPause.setState();
        } else if (o instanceof JTextField) {
            this.dC = this.inputTF(this.tfD, 5.0, 30.0, 1);
            this.lambda = this.inputTF(this.tfLambda, 2.0, 20.0, 1);
            this.calculation();
            this.calcDiff();
        }
        this.slow = this.cbSlow.isSelected();
        this.cv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (x > 400 || y > 300) {
            return;
        }
        this.xP = x;
        this.yP = y;
        this.calcDiff();
        this.cv.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, InterferenceAP.this.bgCanvas);
            InterferenceAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void hyperbel(Graphics2D g, double diff) {
            double dc2 = InterferenceAP.this.dC * InterferenceAP.this.dC * 10.0 * 10.0;
            double a = diff / 2.0;
            double b = 0.5 * Math.sqrt(dc2 - diff * diff);
            double x0 = a;
            double y0 = 0.0;
            for (int i = 1; i < 45; ++i) {
                double phi = (double)i * (Math.PI / 90);
                double x1 = a / Math.cos(phi);
                double y1 = b * Math.tan(phi);
                CanvasAP.line(g, (double)InterferenceAP.this.xM + x0, (double)InterferenceAP.this.yM + y0, (double)InterferenceAP.this.xM + x1, (double)InterferenceAP.this.yM + y1);
                CanvasAP.line(g, (double)InterferenceAP.this.xM + x0, (double)InterferenceAP.this.yM - y0, (double)InterferenceAP.this.xM + x1, (double)InterferenceAP.this.yM - y1);
                CanvasAP.line(g, (double)InterferenceAP.this.xM - x0, (double)InterferenceAP.this.yM + y0, (double)InterferenceAP.this.xM - x1, (double)InterferenceAP.this.yM + y1);
                CanvasAP.line(g, (double)InterferenceAP.this.xM - x0, (double)InterferenceAP.this.yM - y0, (double)InterferenceAP.this.xM - x1, (double)InterferenceAP.this.yM - y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void paintFix(Graphics2D g) {
            CanvasAP.rectangle(g, 0.0, 0.0, 600.0, 360.0, InterferenceAP.this.bgCanvas);
            g.setColor(InterferenceAP.this.color1);
            CanvasAP.line(g, InterferenceAP.this.xM, 0.0, InterferenceAP.this.xM, 300.0);
            int i = 1;
            while ((double)i <= InterferenceAP.this.dC / InterferenceAP.this.lambda) {
                this.hyperbel(g, (double)i * InterferenceAP.this.lambdaPixel);
                ++i;
            }
            g.setColor(InterferenceAP.this.color2);
            i = 0;
            while ((double)i + 0.5 <= InterferenceAP.this.dC / InterferenceAP.this.lambda) {
                this.hyperbel(g, ((double)i + 0.5) * InterferenceAP.this.lambdaPixel);
                ++i;
            }
        }

        void paintVar(Graphics2D g) {
            double r;
            int i;
            double nConstr = InterferenceAP.this.t / 5.0;
            int n0 = (int)nConstr;
            nConstr -= (double)n0;
            double nDestr = InterferenceAP.this.t / 5.0 + 0.5;
            n0 = (int)nDestr;
            nDestr -= (double)n0;
            Color c = Color.lightGray;
            for (i = 0; i < InterferenceAP.this.nCircles; ++i) {
                r = (nDestr + (double)i) * InterferenceAP.this.lambdaPixel;
                CanvasAP.circle(g, InterferenceAP.this.xC1, InterferenceAP.this.yC, r, c, false);
                CanvasAP.circle(g, InterferenceAP.this.xC2, InterferenceAP.this.yC, r, c, false);
            }
            c = Color.black;
            CanvasAP.circle(g, InterferenceAP.this.xC1, InterferenceAP.this.yC, 2.5, c);
            CanvasAP.circle(g, InterferenceAP.this.xC2, InterferenceAP.this.yC, 2.5, c);
            for (i = 0; i < InterferenceAP.this.nCircles; ++i) {
                r = (nConstr + (double)i) * InterferenceAP.this.lambdaPixel;
                CanvasAP.circle(g, InterferenceAP.this.xC1, InterferenceAP.this.yC, r, c, false);
                CanvasAP.circle(g, InterferenceAP.this.xC2, InterferenceAP.this.yC, r, c, false);
            }
            c = InterferenceAP.this.colorPoint;
            CanvasAP.circle(g, InterferenceAP.this.xP, InterferenceAP.this.yP, 2.5, c);
            CanvasAP.line(g, InterferenceAP.this.xP, InterferenceAP.this.yP, InterferenceAP.this.xC1, InterferenceAP.this.yC);
            CanvasAP.line(g, InterferenceAP.this.xP, InterferenceAP.this.yP, InterferenceAP.this.xC2, InterferenceAP.this.yC);
            CanvasAP.rectangle(g, 0.0, 300.0, 400.0, 60.0, InterferenceAP.this.bgCanvas);
            g.setColor(Color.black);
            CanvasAP.line(g, 0.0, 300.0, 600.0, 300.0);
            CanvasAP.setAntiAliasing(g, false);
            int lStr = InterferenceAP.this.fmH.stringWidth(InterferenceAP.this.text08);
            lStr = Math.max(lStr, InterferenceAP.this.fmH.stringWidth(InterferenceAP.this.text09));
            lStr = Math.max(lStr, InterferenceAP.this.fmH.stringWidth(InterferenceAP.this.text07) + 60);
            int xText = (400 - lStr) / 2;
            int xDeltaS = xText + lStr / 2;
            g.drawString(InterferenceAP.this.text07, xText, 325);
            String str = InterferenceAP.this.text07;
            lStr = InterferenceAP.this.fmH.stringWidth(str);
            xDeltaS = Math.max(xDeltaS, xText + lStr + 20);
            str = "\u0394s = " + this.frame.toString(InterferenceAP.this.ds / InterferenceAP.this.lambdaPixel, 1) + " \u03bb";
            g.drawString(str, xDeltaS + 15, 325);
            int ds10 = (int)(10.0 * InterferenceAP.this.ds / InterferenceAP.this.lambdaPixel + 0.5);
            if (ds10 % 10 == 0) {
                g.setColor(InterferenceAP.this.color1);
                g.drawString(InterferenceAP.this.text08, xText, 345);
            }
            if (ds10 % 10 == 5) {
                g.setColor(InterferenceAP.this.color2);
                g.drawString(InterferenceAP.this.text09, xText, 345);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.setFont(this.fH);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setClip(2, 2, 396, 356);
            this.paintFix(g2);
            this.paintVar(g2);
        }
    }
}

