/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class DigitalClock
extends Component {
    int x;
    int y;
    int n1;
    int n2;
    String u;
    Color col;
    Font fC;
    FontMetrics fmC;
    String pt;

    DigitalClock(int x, int y, int n1, int n2, String u, Color col, String pt) {
        this.x = x;
        this.y = y;
        this.n1 = n1;
        this.n2 = n2;
        this.u = u;
        this.col = col;
        this.pt = pt;
        this.fC = new Font("Monospaced", 1, 16);
        this.fmC = this.getFontMetrics(this.fC);
    }

    String doubleToString(double a, int n) {
        String s;
        String string = s = a >= 0.0 ? "" : "-";
        if (a < 0.0) {
            a = -a;
        }
        long p = 1L;
        for (int i = 0; i < n; ++i) {
            p *= 10L;
        }
        long b = Math.round(a * (double)p);
        s = s + b / p;
        if (n > 0) {
            s = s + this.pt;
        }
        b %= p;
        for (int i = 0; i < n; ++i) {
            s = s + b / (p /= 10L);
            b %= p;
        }
        return s;
    }

    void paint(Graphics g, double t) {
        int lMax = this.n1 + this.n2 + this.u.length() + 2;
        int w = lMax * this.fmC.stringWidth(" ") + 10;
        g.setColor(this.col);
        g.fillRect(this.x - w / 2 - 10, this.y - 15, w + 20, 30);
        g.setColor(Color.black);
        g.drawRect(this.x - w / 2 - 10, this.y - 15, w + 20, 30);
        g.fillRect(this.x - w / 2, this.y - 10, w, 21);
        g.setColor(Color.red);
        g.setFont(this.fC);
        if (t >= 1000.0) {
            return;
        }
        String s = this.doubleToString(t, 3) + " " + this.u;
        int l = s.length();
        if (l > 20) {
            return;
        }
        s = "                    ".substring(0, lMax - l) + s;
        g.drawString(s, this.x - this.fmC.stringWidth(s) / 2, this.y + 5);
    }
}

