/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;

class Pendulum {
    final double DEG = Math.PI / 180;
    double l;
    double g;
    double m;
    double alpha0;
    int ax;
    int ay;
    double pix;
    int r;
    Color col;
    double omega;
    double tPer;
    double px;
    double py;
    int lPix;
    double alpha;
    double sinAlpha;
    double cosAlpha;

    Pendulum(double l, double g, double m, double alpha0, int ax, int ay, double pix, int r, Color col) {
        this.l = l;
        this.g = g;
        this.m = m;
        this.alpha0 = alpha0;
        this.omega = Math.sqrt(g / l);
        this.tPer = Math.PI * 2 / this.omega;
        this.ax = ax;
        this.ay = ay;
        this.pix = pix;
        this.lPix = (int)Math.round(l * pix);
        this.r = r;
        this.col = col;
    }

    Pendulum(double l, double g, double m, double alpha0, int ax, int ay, double pix) {
        this(l, g, m, alpha0, ax, ay, pix, 5, Color.white);
    }

    void drawArc(Graphics2D g) {
        double a = Math.abs(this.alpha);
        if (this.alpha > 0.0) {
            Canvas6.arc(g, 3.0, this.ax, this.ay, this.lPix, 4.71238898038469, a);
        } else if (this.alpha < 0.0) {
            Canvas6.arc(g, 3.0, this.ax, this.ay, this.lPix, 4.71238898038469 - a, a);
        }
    }

    void drawArrow(Graphics2D g, double r, double phi) {
        double x = this.px + r * Math.cos(phi);
        double y = this.py - r * Math.sin(phi);
        Canvas6.arrow(g, 3.0, this.px, this.py, x, y);
    }

    void paint(Graphics2D g, double phi) {
        this.alpha = this.alpha0 * Math.cos(phi);
        this.sinAlpha = Math.sin(this.alpha);
        this.cosAlpha = Math.cos(this.alpha);
        this.px = (double)this.ax + (double)this.lPix * this.sinAlpha;
        this.py = (double)this.ay + (double)this.lPix * this.cosAlpha;
        g.setColor(Color.black);
        Canvas6.line(g, this.ax, this.ay, this.px, this.py);
        Canvas6.circle(g, this.px, this.py, this.r, this.col, true);
    }
}

