/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PendulumAP
extends AP6 {
    String[][] text = new String[][]{{"de", "Fadenpendel", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Pendell\u00e4nge:", "", "Fallbeschleunigung:", "Masse:", "Amplitude:", "Elongation", "Geschwindigkeit", "Beschleunigung", "Kraft", "Energie", "Maximum", "Beschleunigung (tangentiale Komponente)", "Kraft (tangentiale Komponente)", "Potentielle Energie", "Kinetische Energie", "Gesamtenergie", "(in s)", "(in m)", "(in m/s)", "(in m/s\u00b2)", "(in N)", "(in J)", "Schwingungsdauer", ""}, {"en", "Pendulum", "Reset", "Start", "Pause", "Resume", "Slow motion", "Length:", "Gravitational", "acceleration:", "Mass:", "Amplitude:", "Elongation", "Velocity", "Acceleration", "Force", "Energy", "Maximum", "Acceleration (tangential component)", "Force (tangential component)", "Potential energy", "Kinetic energy", "Total energy", "(in s)", "(in m)", "(in m/s)", "(in m/s\u00b2)", "(in N)", "(in J)", "Oscillation period", ""}};
    private int[] gaps = new int[]{5, 3, 5, 5, 3, 0, 3, 3, 5, 0, 0, 0, 0, 5, 0, 5};
    final int width = 820;
    final int height = 420;
    final int width0 = 560;
    final int ax = 120;
    final int ay = 30;
    final int lPix = 25;
    final int xD = 260;
    final int yD1 = 180;
    final int yD2 = 165;
    final int tPix = 20;
    FontMetrics fmH;
    final Color BLACK = Color.black;
    CanvasAP cv;
    Panel6 pan;
    ResetButton bReset;
    StartButton bStart;
    JTextField tfL;
    JTextField tfG;
    JTextField tfM;
    JTextField tfAlpha0;
    JCheckBox cbSlow;
    JRadioButton rbS;
    JRadioButton rbV;
    JRadioButton rbA;
    JRadioButton rbF;
    JRadioButton rbE;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorElongation;
    Color colorVelocity;
    Color colorAcceleration;
    Color colorForce;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String text20;
    String text21;
    String text22;
    String text23;
    String text24;
    String text25;
    String text26;
    String text27;
    String text28;
    int nrSize;
    boolean on;
    boolean slow;
    double t;
    double tU;
    double phi;
    double sinPhi;
    double cosPhi;
    double yPix;
    Pendulum p;
    DigitalClock dcl;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(820, 420);
    }

    @Override
    protected void initAttributes() {
        this.p = new Pendulum(5.0, 9.81, 5.0, 0.17453292519943295, 120, 30, 25.0);
        this.dcl = new DigitalClock(120, 340, 3, 3, this.second, Color.gray, ",");
        this.nrSize = 0;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorElongation = this.getColor(Color.red, "colorElongation");
        this.colorVelocity = this.getColor(Color.magenta, "colorVelocity");
        this.colorAcceleration = this.getColor(Color.blue, "colorAcceleration");
        this.colorForce = this.getColor(new Color(0, 128, 32), "colorForce");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(this.text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.text20 = this.getText(t[21], "text20");
        this.text21 = this.getText(t[22], "text21");
        this.text22 = this.getText(t[23], "text22");
        this.text23 = this.getText(t[24], "text23");
        this.text24 = this.getText(t[25], "text24");
        this.text25 = this.getText(t[26], "text25");
        this.text26 = this.getText(t[27], "text26");
        this.text27 = this.getText(t[28], "text27");
        this.text28 = this.getText(t[29], "text28");
        this.coauthor = this.getText(t[30], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 560, 420);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(560, 0, 260, 420);
        this.bReset = new ResetButton(this.text01);
        this.pan.add(this.bReset, this.colorButton1, this.BLACK);
        this.bStart = new StartButton(this.text02, this.text03, this.text04);
        this.pan.add(this.bStart, this.colorButton2, this.BLACK);
        this.cbSlow = new JCheckBox(this.text05);
        this.pan.add(this.cbSlow, this.bgPanel, this.BLACK);
        this.tfL = this.pan.newInputField(this.text06, this.meter, Color.white, this.BLACK, 3);
        this.tfL.setText(this.toString(this.p.l, 3));
        JLabel grav = new JLabel(this.text07);
        this.pan.add(grav, this.bgPanel, 0, 1, 10, 0);
        this.tfG = this.pan.newInputField(this.text08, this.meterPerSecond2, Color.white, this.BLACK, 3);
        this.tfG.setText(this.toString(this.p.g, 2));
        this.tfM = this.pan.newInputField(this.text09, this.kilogram, Color.white, this.BLACK, 3);
        this.tfM.setText(this.toString(this.p.m, 3));
        this.tfAlpha0 = this.pan.newInputField(this.text10, this.degree, Color.white, this.BLACK, 3);
        this.tfAlpha0.setText(this.toString(this.p.alpha0 / (Math.PI / 180), 1));
        ButtonGroup bg = new ButtonGroup();
        this.rbS = new JRadioButton(this.text11, true);
        bg.add(this.rbS);
        this.pan.add(this.rbS, this.bgPanel, this.colorElongation);
        this.rbV = new JRadioButton(this.text12, false);
        bg.add(this.rbV);
        this.pan.add(this.rbV, this.bgPanel, this.colorVelocity);
        this.rbA = new JRadioButton(this.text13, false);
        bg.add(this.rbA);
        this.pan.add(this.rbA, this.bgPanel, this.colorAcceleration);
        this.rbF = new JRadioButton(this.text14, false);
        bg.add(this.rbF);
        this.pan.add(this.rbF, this.bgPanel, this.colorForce);
        this.rbE = new JRadioButton(this.text15, false);
        bg.add(this.rbE);
        this.pan.add(this.rbE, this.bgPanel, this.BLACK);
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.bReset.addActionListener(this);
        this.bStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
        this.rbS.addActionListener(this);
        this.rbV.addActionListener(this);
        this.rbA.addActionListener(this);
        this.rbF.addActionListener(this);
        this.rbE.addActionListener(this);
    }

    @Override
    protected void end() {
        this.thr = null;
        this.removeAll();
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                if (this.slow) {
                    dt /= 10.0;
                }
                this.t += dt;
                if (this.t >= 1000.0) {
                    this.t -= 1000.0;
                }
            }
            this.tU = this.t < 5.0 ? 0.0 : this.t - 5.0;
            t0 = t1;
        }
    }

    void setTF(boolean flag) {
        this.tfL.setEnabled(flag);
        this.tfG.setEnabled(flag);
        this.tfM.setEnabled(flag);
        this.tfAlpha0.setEnabled(flag);
    }

    void changeValues() {
        double l = this.inputTF(this.tfL, 0.5, 10.0, 3);
        double g = this.inputTF(this.tfG, 1.0, 100.0, 2);
        double m = this.inputTF(this.tfM, 1.0, 10.0, 3);
        double alpha0 = Math.PI / 180 * this.inputTF(this.tfAlpha0, 2.0, 20.0, 1);
        this.p = new Pendulum(l, g, m, alpha0, 120, 30, 25.0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.changeValues();
        Object o = ae.getSource();
        if (o == this.bReset) {
            this.bStart.setState(0);
            this.setTF(true);
            this.tU = 0.0;
            this.t = 0.0;
        } else if (o == this.bStart) {
            this.bStart.setState();
            this.setTF(false);
        }
        this.on = this.bStart.getState() == 1;
        this.slow = this.cbSlow.isSelected();
        if (this.rbS.isSelected()) {
            this.nrSize = 0;
        } else if (this.rbV.isSelected()) {
            this.nrSize = 1;
        } else if (this.rbA.isSelected()) {
            this.nrSize = 2;
        } else if (this.rbF.isSelected()) {
            this.nrSize = 3;
        } else if (this.rbE.isSelected()) {
            this.nrSize = 4;
        }
        this.repaint();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, PendulumAP.this.bgCanvas);
            PendulumAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void writeValue(Graphics2D g, String s, double val, String u, int n, int x1, int x2, int y) {
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(s + ":", x1, y);
            g.drawString(PendulumAP.this.toString2(val, n, 1.0E-6) + " " + u, x2, y);
            CanvasAP.setAntiAliasing(g, true);
        }

        void centerText(Graphics2D g, String s1, String s2, int x, int y) {
            int w1 = PendulumAP.this.fmH.stringWidth(s1);
            int w2 = PendulumAP.this.fmH.stringWidth(s2);
            int x0 = x - (w1 + w2) / 2;
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(s1, x0, y);
            g.drawString(s2, x0 + w1 + 1, y + 5);
            CanvasAP.setAntiAliasing(g, true);
        }

        void xAxis(Graphics2D g, int x, int y, int x0, int x1) {
            g.setColor(PendulumAP.this.BLACK);
            CanvasAP.arrow(g, x0, y, x1, y);
            this.alignText(g, "t", this.fH, 1, x1 - 10, y + 15);
            this.alignText(g, PendulumAP.this.text22, this.fH, 1, x1 - 10, y + 27);
        }

        void yAxis(Graphics2D g, int x, int y, int y0, int y1) {
            g.setColor(PendulumAP.this.BLACK);
            CanvasAP.arrow(g, x, y0, x, y1);
        }

        void horAxis(Graphics2D g, int x, int y) {
            g.setColor(PendulumAP.this.BLACK);
            this.xAxis(g, x, y, x - 20, x + 240);
            int t0 = (int)Math.ceil(PendulumAP.this.tU);
            int x0 = (int)Math.round((double)x + 20.0 * ((double)t0 - PendulumAP.this.tU));
            for (int i = 0; i <= 10; ++i) {
                int xs = x0 + i * 20;
                g.drawLine(xs, y - 2, xs, y + 2);
                if (xs < x + 5 || xs > x + 215 || t0 + i > 100 && (t0 + i) % 2 != 0) continue;
                this.alignText(g, "" + (t0 + i), this.fH, 1, xs, y + 13);
            }
        }

        void orthAxis(Graphics2D g, int x, int y, int yLow, int yHigh, double maxSI) {
            int n0;
            double pot10 = Math.pow(10.0, Math.floor(Math.log(maxSI) / Math.log(10.0)));
            double q = maxSI / pot10;
            int n = q > 5.0 ? 10 : (q > 2.0 ? 5 : 2);
            double yyMax = (double)n * pot10;
            this.yAxis(g, x, y, yLow, yHigh);
            for (int i = n0 = PendulumAP.this.nrSize < 4 ? -n : 0; i <= n; ++i) {
                int ys = y - i * 100 / n;
                CanvasAP.line(g, x - 2, ys, x + 2, ys);
                String s = PendulumAP.this.toString2((double)i * pot10, 1, 1.0E-6);
                if (Math.abs((double)i * pot10) >= 10.0) {
                    s = "" + (int)Math.round((double)i * pot10);
                }
                if (n >= 10 && i % 2 != 0 || i == 0) continue;
                CanvasAP.setAntiAliasing(g, false);
                g.drawString(s, x - 3 - PendulumAP.this.fmH.stringWidth(s), ys + 4);
                CanvasAP.setAntiAliasing(g, true);
            }
            PendulumAP.this.yPix = (double)(100 / n) / pot10;
        }

        void sinus(Graphics2D g, double x, double y, double per, double ampl, double xMin, double xMax) {
            double omega = Math.PI * 2 / per;
            double x0 = xMin;
            double y0 = y - ampl * Math.sin(omega * (x0 - x));
            while (x0 < xMax) {
                double x1 = x0 + 1.0;
                double y1 = y - ampl * Math.sin(omega * (x1 - x));
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void diagram(Graphics2D g, int type, int x, int y, double yMax) {
            this.horAxis(g, x, y);
            this.orthAxis(g, x, y, y + 120, y - 135, yMax);
            this.sinus(g, (double)x - (double)type * PendulumAP.this.p.tPer * 5.0 - PendulumAP.this.tU * 20.0, y, PendulumAP.this.p.tPer * 20.0, yMax * PendulumAP.this.yPix, x, x + 200);
        }

        void diagramE(Graphics2D g, int x, int y, double energy) {
            g.setColor(PendulumAP.this.BLACK);
            this.horAxis(g, x, y);
            this.orthAxis(g, x, y, y + 20, y - 125, energy);
            double x1 = x + 200;
            double y1 = (double)y - energy * PendulumAP.this.yPix;
            CanvasAP.line(g, x, y1, x1, y1);
            double xx = (double)x - PendulumAP.this.tU * 20.0;
            double per = PendulumAP.this.p.tPer * 10.0;
            double ampl = energy * PendulumAP.this.yPix / 2.0;
            this.sinus(g, xx - PendulumAP.this.p.tPer * 2.5, (double)y - ampl, per, ampl, x, x + 200);
            this.sinus(g, xx - PendulumAP.this.p.tPer * 7.5, (double)y - ampl, per, ampl, x, x + 200);
        }

        void drawMomVal(Graphics2D g, double val, double x, double y) {
            Color c = g.getColor();
            CanvasAP.circle(g, x += (PendulumAP.this.t - PendulumAP.this.tU) * 20.0, y -= val * PendulumAP.this.yPix, 2.5, c);
        }

        void drawElongation(Graphics2D g) {
            double sMax = PendulumAP.this.p.l * PendulumAP.this.p.alpha0;
            double s = sMax * PendulumAP.this.cosPhi;
            this.diagram(g, 1, 260, 180, sMax);
            g.setColor(PendulumAP.this.BLACK);
            this.alignText(g, "s", this.fH, 1, 235, 50);
            this.alignText(g, PendulumAP.this.text23, this.fH, 1, 235, 62);
            g.setColor(PendulumAP.this.colorElongation);
            PendulumAP.this.p.drawArc(g);
            this.writeValue(g, PendulumAP.this.text11, s, PendulumAP.this.meter, 3, 260, 460, 370);
            this.writeValue(g, "(" + PendulumAP.this.text16, sMax, PendulumAP.this.meter + ")", 3, 260, 460, 390);
            this.drawMomVal(g, s, 260.0, 180.0);
        }

        void drawVelocity(Graphics2D g) {
            double vMax = PendulumAP.this.p.l * PendulumAP.this.p.alpha0 * PendulumAP.this.p.omega;
            double v = -vMax * PendulumAP.this.sinPhi;
            this.diagram(g, 2, 260, 180, vMax);
            g.setColor(Color.black);
            this.alignText(g, "v", this.fH, 1, 232, 50);
            this.alignText(g, PendulumAP.this.text24, this.fH, 1, 232, 62);
            g.setColor(PendulumAP.this.colorVelocity);
            PendulumAP.this.p.drawArrow(g, v * PendulumAP.this.yPix, PendulumAP.this.p.alpha0 * PendulumAP.this.cosPhi);
            this.drawMomVal(g, v, 260.0, 180.0);
            this.writeValue(g, PendulumAP.this.text12, v, PendulumAP.this.meterPerSecond, 3, 260, 460, 370);
            this.writeValue(g, "(" + PendulumAP.this.text16, vMax, PendulumAP.this.meterPerSecond + ")", 3, 260, 460, 390);
        }

        void drawAcceleration(Graphics2D g) {
            double aMax = PendulumAP.this.p.l * PendulumAP.this.p.alpha0 * PendulumAP.this.p.omega * PendulumAP.this.p.omega;
            double a = -aMax * PendulumAP.this.cosPhi;
            this.diagram(g, 3, 260, 180, aMax);
            g.setColor(PendulumAP.this.BLACK);
            this.centerText(g, "a", "tang", 230, 50);
            this.alignText(g, PendulumAP.this.text25, this.fH, 1, 230, 67);
            g.setColor(PendulumAP.this.colorAcceleration);
            PendulumAP.this.p.drawArrow(g, a * PendulumAP.this.yPix, PendulumAP.this.p.alpha0 * PendulumAP.this.cosPhi);
            this.drawMomVal(g, a, 260.0, 180.0);
            this.writeValue(g, PendulumAP.this.text17, a, PendulumAP.this.meterPerSecond2, 3, 230, 480, 370);
            this.writeValue(g, "(" + PendulumAP.this.text16, aMax, PendulumAP.this.meterPerSecond2 + ")", 3, 230, 480, 390);
        }

        void drawForce(Graphics2D g) {
            double fMax = PendulumAP.this.p.m * PendulumAP.this.p.l * PendulumAP.this.p.alpha0 * PendulumAP.this.p.omega * PendulumAP.this.p.omega;
            double f = -fMax * PendulumAP.this.cosPhi;
            this.diagram(g, 3, 260, 180, fMax);
            g.setColor(PendulumAP.this.BLACK);
            this.centerText(g, "F", "tang", 230, 50);
            this.alignText(g, PendulumAP.this.text26, this.fH, 1, 230, 67);
            g.setColor(PendulumAP.this.colorForce);
            PendulumAP.this.p.drawArrow(g, f * PendulumAP.this.yPix, PendulumAP.this.p.alpha0 * PendulumAP.this.cosPhi);
            this.drawMomVal(g, f, 260.0, 180.0);
            this.writeValue(g, PendulumAP.this.text18, f, PendulumAP.this.newton, 3, 230, 480, 370);
            this.writeValue(g, "(" + PendulumAP.this.text16, fMax, PendulumAP.this.newton + ")", 3, 230, 480, 390);
        }

        void drawEnergy(Graphics2D g) {
            double e = PendulumAP.this.p.l * PendulumAP.this.p.alpha0 * PendulumAP.this.p.omega;
            e = PendulumAP.this.p.m * e * e / 2.0;
            double part = PendulumAP.this.cosPhi * PendulumAP.this.cosPhi;
            double eP = e * part;
            double eK = e - eP;
            this.diagramE(g, 260, 165, e);
            g.setColor(PendulumAP.this.BLACK);
            this.centerText(g, "E", "pot", 230, 40);
            this.alignText(g, PendulumAP.this.text27, this.fH, 1, 230, 57);
            this.centerText(g, "E", "kin", 290, 40);
            this.alignText(g, PendulumAP.this.text27, this.fH, 1, 290, 57);
            g.setColor(PendulumAP.this.colorElongation);
            this.writeValue(g, PendulumAP.this.text19, eP, PendulumAP.this.joule, 3, 260, 460, 350);
            g.setColor(PendulumAP.this.colorVelocity);
            this.writeValue(g, PendulumAP.this.text20, eK, PendulumAP.this.joule, 3, 260, 460, 370);
            g.setColor(PendulumAP.this.BLACK);
            this.writeValue(g, PendulumAP.this.text21, e, PendulumAP.this.joule, 3, 260, 460, 390);
            double dy = part * 100.0;
            double y = 205.0 + dy;
            CanvasAP.rectangle(g, 300.0, 205.0, 50.0, dy, PendulumAP.this.colorElongation, true);
            if (part > 0.001 || PendulumAP.this.on) {
                g.drawString(PendulumAP.this.text19, 360, 220);
            }
            CanvasAP.rectangle(g, 300.0, y, 50.0, 100.0 - dy, PendulumAP.this.colorVelocity, true);
            if (part < 0.999 || PendulumAP.this.on) {
                g.drawString(PendulumAP.this.text20, 360, 300);
            }
            g.setColor(PendulumAP.this.colorElongation);
            this.drawMomVal(g, eP, 260.0, 165.0);
            g.setColor(PendulumAP.this.colorVelocity);
            this.drawMomVal(g, eK, 260.0, 165.0);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            CanvasAP.rectangle(g2, PendulumAP.this.p.ax - 50, PendulumAP.this.p.ay - 5, 100.0, 5.0, PendulumAP.this.BLACK, true);
            PendulumAP.this.phi = PendulumAP.this.p.omega * PendulumAP.this.t;
            PendulumAP.this.sinPhi = Math.sin(PendulumAP.this.phi);
            PendulumAP.this.cosPhi = Math.cos(PendulumAP.this.phi);
            PendulumAP.this.p.paint(g2, PendulumAP.this.phi);
            PendulumAP.this.dcl.paint(g, PendulumAP.this.t);
            g.setFont(this.fH);
            switch (PendulumAP.this.nrSize) {
                case 0: {
                    this.drawElongation(g2);
                    break;
                }
                case 1: {
                    this.drawVelocity(g2);
                    break;
                }
                case 2: {
                    this.drawAcceleration(g2);
                    break;
                }
                case 3: {
                    this.drawForce(g2);
                    break;
                }
                case 4: {
                    this.drawEnergy(g2);
                }
            }
            g.setColor(PendulumAP.this.BLACK);
            String s = PendulumAP.this.text28 + ":  " + PendulumAP.this.toString2(PendulumAP.this.p.tPer, 3, 1.0E-6) + " " + PendulumAP.this.second;
            this.alignText(g2, s, this.fH, 1, 120, 390);
        }
    }
}

