/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RefractionAP
extends AP6
implements ItemListener,
MouseMotionListener {
    static final String[][] text = new String[][]{{"de", "Lichtbrechung", "1. Brechungsindex:", "2. Brechungsindex:", "Einfallswinkel:", "Reflexionswinkel:", "Brechungswinkel:", "Grenzwinkel der", "Totalreflexion:", "Vakuum (n = 1)", "Luft (n = 1,0003)", "Wasser (n = 1,33)", "Ethanol (n = 1,36)", "Quarzglas (n = 1,46)", "Benzol (n = 1,49)", "Kronglas N-K5 (n = 1,52)", "Steinsalz (n = 1,54)", "Flintglas LF5 (n = 1,58)", "Kronglas N-SK4 (n = 1,61)", "Flintglas SF6 (n = 1,81)", "Diamant (n = 2,42)", ""}, {"en", "Refraction of Light", "1st index of refraction:", "2nd index of refraction:", "Angle of incidence:", "Angle of reflection:", "Angle of refraction:", "Critical angle for total", "internal reflection:", "vacuum (n = 1)", "air (n = 1.0003)", "water (n = 1.33)", "ethanol (n = 1.36)", "fused quartz (n = 1.46)", "benzene (n = 1.49)", "crown glass N-K5 (n = 1.52)", "rock salt (n = 1.54)", "flint glass LF5 (n = 1.58)", "crown glass N-SK4 (n = 1.61)", "flint glass SF6 (n = 1.81)", "diamond (n = 2.42)", ""}};
    private int[] gaps = new int[]{10, 10, 10, 10, 10, 10, 10, 10, 0, 10, 0, 10};
    final int width = 800;
    final int height = 360;
    final int width0 = 560;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JComboBox co1;
    JComboBox co2;
    JTextField tfN1;
    JTextField tfN2;
    JTextField tfEW;
    JLabel lbGW1;
    JLabel lbGW2;
    JLabel lbRW;
    JLabel lbBW;
    JLabel lbGW;
    JLabel lbGWGrad;
    Color bgCanvas;
    Color bgPanel;
    Color color1;
    Color color2;
    Color color3;
    Color background1;
    Color background2;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    final int r = 250;
    final int nMed = 12;
    final int mx = 140;
    final int my = 180;
    double eps1;
    double eps2;
    double epsg;
    String medium1;
    String medium2;
    double n1;
    double n2;
    double[] indizes;
    String[] medien;
    boolean refr;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 360);
    }

    @Override
    protected void initAttributes() {
        this.eps1 = 0.5235987755982988;
        this.n1 = 1.0003;
        this.n2 = 1.33;
        this.medien = new String[12];
        this.indizes = new double[12];
        this.medium1 = this.medien[1];
        this.medium2 = this.medien[2];
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.color1 = this.getColor(Color.black, "color1");
        this.color2 = this.getColor(Color.blue, "color2");
        this.color3 = this.getColor(Color.red, "color3");
        this.background1 = this.getColor(Color.white, "background1");
        this.background2 = this.getColor(Color.cyan, "background2");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.coauthor = this.getText(t[21], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 560, 360);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(560, 0, 240, 360);
        this.co1 = new JComboBox();
        this.co2 = new JComboBox();
        for (int i = 0; i < 12; ++i) {
            this.zerlegenAngabe(i);
            String s = this.medien[i];
            this.co1.addItem(s);
            this.co2.addItem(s);
        }
        this.co1.addItem("");
        this.co2.addItem("");
        this.co1.setSelectedIndex(1);
        this.co2.setSelectedIndex(2);
        this.pan.add(this.co1, Color.white, Color.black);
        this.pan.add(this.co2, Color.white, Color.black);
        this.tfN1 = this.pan.newInputField(this.text01, "", this.bgPanel, Color.black, 4);
        this.tfN2 = this.pan.newInputField(this.text02, "", this.bgPanel, Color.black, 4);
        this.tfEW = this.pan.newInputField(this.text03, this.degree, this.bgPanel, Color.black, 4);
        this.lbRW = this.pan.newOutputField(this.text04, this.degree, this.bgPanel, this.color2, 4);
        this.lbBW = this.pan.newOutputField(this.text05, this.degree, this.bgPanel, this.color3, 4);
        this.lbGW1 = new JLabel();
        this.pan.add(this.lbGW1, this.bgPanel, this.color2);
        this.lbGW2 = new JLabel();
        this.pan.add(this.lbGW2, this.bgPanel, 0, 1, 10, 0);
        this.lbGW2.setForeground(this.color2);
        this.lbGW = new JLabel();
        this.pan.add(this.lbGW, this.bgPanel, 1, 1, 0, 0);
        this.lbGWGrad = new JLabel();
        this.pan.add(this.lbGWGrad, this.bgPanel, 2, 1, 0, 10);
        this.pan.add(1997);
        this.pan.add(this.coauthor);
        this.tfEW.setText(this.toString(this.eps1 / (Math.PI / 180), 1));
        this.eintragenIndizes();
        this.eintragenWinkel();
        this.medium1 = this.medien[1];
        this.medium2 = this.medien[2];
        this.add(this.pan);
        this.co1.addItemListener(this);
        this.co2.addItemListener(this);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    public void run() {
    }

    boolean zahlOderKomma(String s, int i) {
        char ch = s.charAt(i);
        return Character.isDigit(ch) || ch == ',' || ch == '.';
    }

    void zerlegenAngabe(int i) {
        int k;
        String s = "";
        switch (i) {
            case 0: {
                s = this.text08;
                break;
            }
            case 1: {
                s = this.text09;
                break;
            }
            case 2: {
                s = this.text10;
                break;
            }
            case 3: {
                s = this.text11;
                break;
            }
            case 4: {
                s = this.text12;
                break;
            }
            case 5: {
                s = this.text13;
                break;
            }
            case 6: {
                s = this.text14;
                break;
            }
            case 7: {
                s = this.text15;
                break;
            }
            case 8: {
                s = this.text16;
                break;
            }
            case 9: {
                s = this.text17;
                break;
            }
            case 10: {
                s = this.text18;
                break;
            }
            case 11: {
                s = this.text19;
            }
        }
        int ind = s.indexOf(40);
        if (ind < 0) {
            return;
        }
        for (k = ind - 1; k >= 0 && s.charAt(k) == ' '; --k) {
        }
        this.medien[i] = s.substring(0, k + 1);
        ind = s.indexOf(61);
        if (ind < 0) {
            return;
        }
        s = s.substring(ind + 1);
        ind = -1;
        for (ind = 0; ind < s.length() && !this.zahlOderKomma(s, ind); ++ind) {
        }
        if (ind < 0) {
            return;
        }
        s = s.substring(ind);
        ind = -1;
        for (ind = 0; ind < s.length() && this.zahlOderKomma(s, ind); ++ind) {
        }
        if (ind < 0) {
            return;
        }
        s = s.substring(0, ind);
        s = s.replaceAll(",", ".");
        this.indizes[i] = Double.parseDouble(s);
    }

    double brechungswinkel(double eps) {
        double sin = this.n1 * Math.sin(eps) / this.n2;
        if (sin > 1.0 || sin < -1.0) {
            return Double.NaN;
        }
        return Math.asin(sin);
    }

    int stellenzahl(JComboBox co) {
        int i = co.getSelectedIndex();
        if (i == 0) {
            return 0;
        }
        if (i == 1) {
            return 4;
        }
        return 2;
    }

    void eintragenIndizes() {
        int st = this.stellenzahl(this.co1);
        this.tfN1.setText(this.toString(this.n1, st));
        st = this.stellenzahl(this.co2);
        this.tfN2.setText(this.toString(this.n2, st));
    }

    void eintragenWinkel() {
        this.lbRW.setText(this.toString(this.eps1 / (Math.PI / 180), 1));
        this.eps2 = this.brechungswinkel(this.eps1);
        this.refr = !Double.isNaN(this.eps2);
        String s = this.refr ? this.toString(this.eps2 / (Math.PI / 180), 1) : "-----";
        this.lbBW.setText(s);
    }

    int index(double n) {
        for (int i = 0; i < 12; ++i) {
            if (!(Math.abs(n - this.indizes[i]) < 1.0E-10)) continue;
            return i;
        }
        return -1;
    }

    void textTotalReflection() {
        if (this.n2 < this.n1) {
            this.lbGW1.setText(this.text06);
            this.lbGW2.setText(this.text07);
            this.epsg = Math.asin(this.n2 / this.n1);
            this.lbGW.setText(this.toString(this.epsg / (Math.PI / 180), 1));
            this.lbGWGrad.setText(this.degree);
        } else {
            this.lbGW1.setText("");
            this.lbGW2.setText("");
            this.lbGW.setText("");
            this.lbGWGrad.setText("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.n1 = this.inputTF(this.tfN1, 1.0, 5.0, 2);
        this.n2 = this.inputTF(this.tfN2, 1.0, 5.0, 2);
        this.co1.setSelectedIndex(this.index(this.n1));
        this.co2.setSelectedIndex(this.index(this.n2));
        this.eps1 = Math.PI / 180 * this.inputTF(this.tfEW, 0.0, 90.0, 1);
        this.eintragenIndizes();
        this.eintragenWinkel();
        this.textTotalReflection();
        this.cv.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        int i = this.co1.getSelectedIndex();
        if (i < 12 && i >= 0) {
            this.medium1 = this.medien[i];
            this.n1 = this.indizes[i];
        } else {
            this.medium1 = "";
        }
        i = this.co2.getSelectedIndex();
        if (i < 12 && i >= 0) {
            this.medium2 = this.medien[i];
            this.n2 = this.indizes[i];
        } else {
            this.medium2 = "";
        }
        this.eintragenIndizes();
        this.eintragenWinkel();
        this.textTotalReflection();
        this.cv.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (x <= 140 && y > 180) {
            y = 180;
        } else if (x > 140 && y <= 180) {
            x = 140;
        } else if (x > 140 && y > 180) {
            return;
        }
        this.eps1 = Math.atan2(140 - x, 180 - y);
        this.tfEW.setText(this.toString(this.eps1 / (Math.PI / 180), 1));
        this.eintragenWinkel();
        this.cv.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, RefractionAP.this.bgCanvas);
            RefractionAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void ray(Graphics2D g, double w) {
            double x = 140.0 - 250.0 * Math.sin(w);
            double y = 180.0 - 250.0 * Math.cos(w);
            g.setColor(Color.red);
            CanvasAP.line(g, 140.0, 180.0, x, y);
        }

        void diagram(Graphics2D g, int x, int y) {
            double y0;
            double x0;
            int w;
            g.setColor(Color.black);
            CanvasAP.arrow(g, 1.0, x, y, x + 205, y);
            for (w = 10; w <= 90; w += 10) {
                int xx = x + 2 * w;
                CanvasAP.line(g, xx, (double)y - 2.5, xx, (double)y + 2.5);
                this.alignText(g, "" + w + RefractionAP.this.degree, this.fH, 1, xx + 3, y + 15);
            }
            g.drawString("\u03b5", x + 200, y + 12);
            CanvasAP.arrow(g, 1.0, x, y, x, y - 205);
            for (w = 10; w <= 90; w += 10) {
                int yy = y - 2 * w;
                CanvasAP.line(g, (double)x - 2.5, yy, (double)x + 2.5, yy);
                this.alignText(g, "" + w + RefractionAP.this.degree, this.fH, 2, x - 3, yy + 5);
            }
            this.alignText(g, "\u03b5'", this.fH, 2, x - 3, y - 195);
            double x1 = x;
            double y1 = y;
            while (x1 < (double)(x + 180)) {
                x0 = x1;
                y0 = y1;
                double eps1 = ((x1 += 1.0) - (double)x) * (Math.PI / 180) / 2.0;
                double eps2 = RefractionAP.this.brechungswinkel(eps1);
                if (Double.isNaN(eps2)) {
                    CanvasAP.line(g, x0, y0, x0, y - 180);
                    break;
                }
                y1 = (double)y - eps2 * 2.0 / (Math.PI / 180);
                CanvasAP.line(g, x0, y0, x1, y1);
            }
            if (!RefractionAP.this.refr) {
                return;
            }
            x0 = (double)x + RefractionAP.this.eps1 * 2.0 / (Math.PI / 180);
            y0 = (double)y - RefractionAP.this.eps2 * 2.0 / (Math.PI / 180);
            CanvasAP.circle(g, x0, y0, 2.5, Color.red);
            g.setColor(Color.black);
            CanvasAP.dashedLine(g, x0, y0, x0, y);
            CanvasAP.dashedLine(g, x0, y0, x, y0);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            this.diagram(g2, 320, 280);
            g.setClip(20, 60, 241, 241);
            Color c = RefractionAP.this.n1 < RefractionAP.this.n2 ? RefractionAP.this.background1 : RefractionAP.this.background2;
            CanvasAP.rectangle(g2, 0.0, 0.0, 280.0, 360.0, c, true);
            c = RefractionAP.this.n2 < RefractionAP.this.n1 ? RefractionAP.this.background1 : RefractionAP.this.background2;
            CanvasAP.rectangle(g2, 0.0, 180.0, 280.0, 180.0, c, true);
            CanvasAP.line(g2, 140.0, -70.0, 140.0, 430.0);
            CanvasAP.rectangle(g2, 20.0, 60.0, 240.0, 240.0, Color.black, false);
            CanvasAP.angle(g2, 140.0, 180.0, 20.0, 1.5707963267948966, RefractionAP.this.eps1, RefractionAP.this.color1);
            this.ray(g2, RefractionAP.this.eps1);
            if (RefractionAP.this.n1 != RefractionAP.this.n2) {
                CanvasAP.angle(g2, 140.0, 180.0, 20.0, 1.5707963267948966 - RefractionAP.this.eps1, RefractionAP.this.eps1, RefractionAP.this.color2);
                this.ray(g2, -RefractionAP.this.eps1);
            }
            if (RefractionAP.this.refr) {
                CanvasAP.angle(g2, 140.0, 180.0, 20.0, 4.71238898038469, RefractionAP.this.eps2, RefractionAP.this.color3);
                this.ray(g2, Math.PI + RefractionAP.this.eps2);
            }
            CanvasAP.setAntiAliasing(g2, false);
            g.setColor(Color.black);
            g.drawString(RefractionAP.this.medium1, 30, 80);
            g.drawString(RefractionAP.this.medium2, 30, 290);
        }
    }
}

