/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Panel6
extends JPanel {
    private final char[] numbers = new char[]{'\u00a9', ' ', ' ', 'W', '.', ' ', 'F', 'e', 'n', 'd', 't', ' '};
    private AP6 frame;
    private Font fH;
    private int cols;
    private int rows;
    private int[] gaps;

    public Panel6(AP6 a, Color c, int sp, int[] g) {
        this.frame = a;
        this.setBackground(c);
        this.cols = sp;
        this.rows = 0;
        this.gaps = g;
        this.setLayout(new GridBagLayout());
        this.fH = new Font("SansSerif", 1, 12);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    private String constructString() {
        this.frame.correct = true;
        String s = "";
        for (int i = 0; i < this.numbers.length; ++i) {
            s = s + this.numbers[i];
        }
        return s;
    }

    private void add(JComponent comp, Color bg, Color fg, Font f, int x, int w, int weight, int top, int left, int bottom, int right) {
        this.add(comp);
        if (x == 0) {
            ++this.rows;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = this.rows - 1;
        c.gridwidth = w;
        c.gridheight = 1;
        c.fill = 2;
        c.anchor = 10;
        c.weightx = weight;
        c.weighty = 1.0;
        c.insets = new Insets(top, left, bottom, right);
        ((GridBagLayout)this.getLayout()).setConstraints(comp, c);
        comp.setFont(f);
        comp.setBackground(bg);
        comp.setForeground(fg);
    }

    protected void add(JComponent comp, Color bg, int x, int w, int left, int right) {
        this.add(comp);
        if (x == 0) {
            ++this.rows;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = this.rows - 1;
        c.gridwidth = w;
        c.gridheight = 1;
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(this.top(), left, this.bottom(), right);
        ((GridBagLayout)this.getLayout()).setConstraints(comp, c);
        comp.setFont(this.fH);
        comp.setBackground(bg);
        comp.setForeground(Color.black);
    }

    private int top() {
        try {
            return this.gaps[this.rows];
        }
        catch (Exception exc) {
            return 0;
        }
    }

    private int bottom() {
        try {
            return this.rows == this.gaps.length - 2 ? this.gaps[this.rows + 1] : 0;
        }
        catch (Exception exc) {
            return 0;
        }
    }

    public void add(JComponent comp, Color bg, Color fg) {
        this.add(comp, bg, fg, this.fH, 0, this.cols, 1, this.top(), 10, this.bottom(), 10);
    }

    public void add(String s, Color fg) {
        JLabel lb = new JLabel(s);
        this.add(lb, this.getBackground(), fg);
    }

    public void add(String s) {
        this.add(s, Color.black);
    }

    public JButton newButton(String s, Color bg, Color fg) {
        JButton bu = new JButton(s);
        this.add(bu, bg, fg, this.fH, 0, this.cols, 1, this.top(), 10, this.bottom(), 10);
        bu.addActionListener(this.frame);
        return bu;
    }

    public JButton newButton(String s, Color bg) {
        return this.newButton(s, bg, Color.black);
    }

    public JTextField newInputField(String s, String u, Color bg, Color fg, int weight) {
        int top = this.top();
        int bottom = this.bottom();
        JLabel lbLeft = new JLabel(s);
        this.add(lbLeft, bg, fg, this.fH, 0, 1, 1, top, 10, bottom, 0);
        JTextField tf = new JTextField();
        this.add(tf, Color.white, fg, this.fH, 1, 1, weight, top, 0, bottom, 0);
        JLabel lbRight = new JLabel(u);
        this.add(lbRight, bg, fg, this.fH, 2, 1, 1, top, 5, bottom, 10);
        tf.addActionListener(this.frame);
        return tf;
    }

    public JLabel newOutputField(String s, String u, Color bg, Color fg, int weight) {
        int top = this.top();
        int bottom = this.bottom();
        JLabel lbLeft = new JLabel(s);
        this.add(lbLeft, bg, fg, this.fH, 0, 1, 1, top, 10, bottom, 0);
        JLabel lb = new JLabel();
        this.add(lb, bg, fg, this.fH, 1, 1, weight, top, 0, bottom, 0);
        JLabel lbRight = new JLabel(u);
        this.add(lbRight, bg, fg, this.fH, 2, 1, 1, top, 5, bottom, 10);
        return lb;
    }

    JRadioButton newRadioButton(String text, boolean sel, ButtonGroup bg) {
        JRadioButton rb = new JRadioButton(text, sel);
        bg.add(rb);
        this.add(rb, this.getBackground(), Color.black);
        rb.addActionListener(this.frame);
        return rb;
    }

    public void add(int year) {
        this.add(this.constructString() + year);
    }
}

