/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SpringPendulumAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Federpendel", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Federkonstante:", "Masse:", "", "Fallbeschleunigung:", "Amplitude:", "Elongation", "Geschwindigkeit", "Beschleunigung", "Kraft", "Energie", "Maximum", "Potentielle Energie", "Kinetische Energie", "Gesamtenergie", "(in s)", "(in m)", "(in m/s)", "(in m/s\u00b2)", "(in N)", "(in J)", "Schwingungsdauer", "t", "s", "v", "a", "F", "E", "pot", "kin", ""}, {"en", "Spring Pendulum", "Reset", "Start", "Pause", "Resume", "Slow motion", "Spring constant:", "Mass:", "Gravitational", "acceleration:", "Amplitude:", "Elongation", "Velocity", "Acceleration", "Force", "Energy", "Maximum", "Potential energy", "Kinetic energy", "Total energy", "(in s)", "(in m)", "(in m/s)", "(in m/s\u00b2)", "(in N)", "(in J)", "Oscillation period", "t", "s", "v", "a", "F", "E", "pot", "kin", ""}};
    private int[] gaps = new int[]{5, 3, 5, 5, 3, 0, 3, 3, 5, 0, 0, 0, 0, 5, 0, 5};
    final int width = 760;
    final int height = 420;
    final int width0 = 500;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    ResetButton bReset;
    StartButton bStart;
    JTextField tfD;
    JTextField tfM;
    JTextField tfG;
    JTextField tfA;
    JCheckBox cbSlow;
    JRadioButton rbS;
    JRadioButton rbV;
    JRadioButton rbA;
    JRadioButton rbF;
    JRadioButton rbE;
    final Color BLACK = Color.black;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorElongation;
    Color colorVelocity;
    Color colorAcceleration;
    Color colorForce;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String text20;
    String text21;
    String text22;
    String text23;
    String text24;
    String text25;
    String text26;
    String symbolTime;
    String symbolElongation;
    String symbolVelocity;
    String symbolAcceleration;
    String symbolForce;
    String symbolEnergy;
    String symbolPotential;
    String symbolKinetic;
    final int ax = 100;
    final int ay = 50;
    final int py0 = 180;
    final int xD = 220;
    final int yD1 = 180;
    final int yD2 = 160;
    final int tPix = 20;
    final double eps = 1.0E-6;
    double t;
    double tU;
    double D;
    double m;
    double g;
    double A;
    double omega;
    double T;
    double phi;
    double sinPhi;
    double cosPhi;
    double yPix;
    double py;
    boolean on;
    boolean slow;
    int nrSize;
    DigitalClock dcl;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(760, 420);
    }

    @Override
    protected void initAttributes() {
        this.t = 0.0;
        this.slow = false;
        this.on = false;
        this.D = 20.0;
        this.m = 5.0;
        this.g = 9.81;
        this.A = 0.05;
        this.calculation();
        this.nrSize = 0;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorElongation = this.getColor(Color.red, "colorElongation");
        this.colorVelocity = this.getColor(Color.magenta, "colorVelocity");
        this.colorAcceleration = this.getColor(Color.blue, "colorAcceleration");
        this.colorForce = this.getColor(new Color(0, 128, 32), "colorForce");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.text20 = this.getText(t[21], "text20");
        this.text21 = this.getText(t[22], "text21");
        this.text22 = this.getText(t[23], "text22");
        this.text23 = this.getText(t[24], "text23");
        this.text24 = this.getText(t[25], "text24");
        this.text25 = this.getText(t[26], "text25");
        this.text26 = this.getText(t[27], "text26");
        this.symbolTime = this.getText(t[28], "symbolTime");
        this.symbolElongation = this.getText(t[29], "symbolElongation");
        this.symbolVelocity = this.getText(t[30], "symbolVelocity");
        this.symbolAcceleration = this.getText(t[31], "symbolAcceleration");
        this.symbolForce = this.getText(t[32], "symbolForce");
        this.symbolEnergy = this.getText(t[33], "symbolEnergy");
        this.symbolPotential = this.getText(t[34], "symbolPotential");
        this.symbolKinetic = this.getText(t[35], "symbolKinetic");
        this.coauthor = this.getText(t[36], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 500, 420);
        this.add(this.cv);
        String pt = this.getDecimalSeparator(this.language);
        this.dcl = new DigitalClock(100, 340, 3, 3, this.second, Color.gray, pt);
    }

    @Override
    protected void initPanel() {
        boolean oneLineG = this.text08.equals("");
        if (oneLineG) {
            this.gaps[5] = 5;
            for (int i = 7; i < this.gaps.length - 1; ++i) {
                this.gaps[i] = this.gaps[i + 1];
            }
        }
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(500, 0, 260, 420);
        this.bReset = new ResetButton(this.text01);
        this.pan.add(this.bReset, this.colorButton1, this.BLACK);
        this.bStart = new StartButton(this.text02, this.text03, this.text04);
        this.pan.add(this.bStart, this.colorButton2, this.BLACK);
        this.cbSlow = new JCheckBox(this.text05);
        this.pan.add(this.cbSlow, this.bgPanel, this.BLACK);
        this.tfD = this.pan.newInputField(this.text06, this.newtonPerMeter, Color.white, this.BLACK, 2);
        this.tfD.setText(this.toString2(this.D, 3, 1.0E-6));
        this.tfM = this.pan.newInputField(this.text07, this.kilogram, Color.white, this.BLACK, 2);
        this.tfM.setText(this.toString2(this.m, 3, 1.0E-6));
        if (!oneLineG) {
            this.pan.add(this.text08);
        }
        this.tfG = this.pan.newInputField(this.text09, this.meterPerSecond2, Color.white, this.BLACK, 2);
        this.tfG.setText(this.toString2(this.g, 3, 1.0E-6));
        this.tfA = this.pan.newInputField(this.text10, this.meter, Color.white, this.BLACK, 2);
        this.tfA.setText(this.toString2(this.A, 3, 1.0E-6));
        ButtonGroup bg = new ButtonGroup();
        this.rbS = this.newRadioButton(this.text11, true, bg, this.colorElongation);
        this.rbV = this.newRadioButton(this.text12, false, bg, this.colorVelocity);
        this.rbA = this.newRadioButton(this.text13, false, bg, this.colorAcceleration);
        this.rbF = this.newRadioButton(this.text14, false, bg, this.colorForce);
        this.rbE = this.newRadioButton(this.text15, false, bg, this.BLACK);
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.bReset.addActionListener(this);
        this.bStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                if (this.slow) {
                    dt /= 10.0;
                }
                this.t += dt;
            }
            this.tU = this.t < 5.0 ? 0.0 : this.t - 5.0;
            t0 = t1;
        }
    }

    JRadioButton newRadioButton(String text, boolean sel, ButtonGroup bg, Color fg) {
        JRadioButton rb = new JRadioButton(text, sel);
        bg.add(rb);
        this.pan.add(rb, this.bgPanel, fg);
        rb.addActionListener(this);
        return rb;
    }

    void calculation() {
        this.omega = Math.sqrt(this.D / this.m);
        this.T = Math.PI * 2 / this.omega;
        this.repaint();
    }

    void changeValues() {
        this.D = this.inputTF2(this.tfD, 5.0, 50.0, 3, 1.0E-6);
        this.m = this.inputTF2(this.tfM, 1.0, 10.0, 3, 1.0E-6);
        this.g = this.inputTF2(this.tfG, 1.0, 100.0, 3, 1.0E-6);
        this.A = this.inputTF2(this.tfA, 0.01, 0.1, 3, 1.0E-6);
        this.calculation();
    }

    void setTF(boolean flag) {
        this.tfD.setEnabled(flag);
        this.tfM.setEnabled(flag);
        this.tfG.setEnabled(flag);
        this.tfA.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.slow = this.cbSlow.isSelected();
        if (this.rbS.isSelected()) {
            this.nrSize = 0;
        } else if (this.rbV.isSelected()) {
            this.nrSize = 1;
        } else if (this.rbA.isSelected()) {
            this.nrSize = 2;
        } else if (this.rbF.isSelected()) {
            this.nrSize = 3;
        } else if (this.rbE.isSelected()) {
            this.nrSize = 4;
        }
        this.changeValues();
        Object o = ae.getSource();
        if (o == this.bReset) {
            this.bStart.setState(0);
            this.setTF(true);
            this.t = 0.0;
        } else if (o == this.bStart) {
            this.bStart.setState();
            this.setTF(false);
        }
        this.on = this.bStart.getState() == 1;
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, SpringPendulumAP.this.bgCanvas);
            SpringPendulumAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void spring(Graphics2D g) {
            double per = (SpringPendulumAP.this.py - 50.0 - 25.0) / 10.0;
            double ampl = 10.0;
            double omega = Math.PI * 2 / per;
            g.setColor(SpringPendulumAP.this.BLACK);
            double x0 = 100.0;
            double y0 = 60.0;
            while (y0 < SpringPendulumAP.this.py - 15.0) {
                double y1 = y0 + 1.0;
                double x1 = 100.0 + ampl * Math.sin(omega * (y1 - 50.0 - 10.0));
                if (y0 > SpringPendulumAP.this.py - 16.0) {
                    x1 = Math.min(x1, 100.0);
                }
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void pendulum(Graphics2D g) {
            CanvasAP.rectangle(g, 50.0, 45.0, 100.0, 5.0, SpringPendulumAP.this.BLACK, true);
            CanvasAP.line(g, 100.0, 50.0, 100.0, 60.0);
            SpringPendulumAP.this.py = 180.0 - 500.0 * SpringPendulumAP.this.A * SpringPendulumAP.this.cosPhi;
            this.spring(g);
            CanvasAP.line(g, 100.0, SpringPendulumAP.this.py - 15.0, 100.0, SpringPendulumAP.this.py - 5.0);
            CanvasAP.circle(g, 100.0, SpringPendulumAP.this.py, 5.0, Color.white, true);
            CanvasAP.line(g, 60.0, 180.0, 80.0, 180.0);
            CanvasAP.line(g, 120.0, 180.0, 140.0, 180.0);
        }

        void xAxis(Graphics2D g, int x, int y, int x0, int x1) {
            CanvasAP.arrow(g, x0, y, x1, y);
            this.alignText(g, SpringPendulumAP.this.symbolTime, this.fH, 1, x1 - 10, y + 15);
            this.alignText(g, SpringPendulumAP.this.text20, this.fH, 1, x1 - 10, y + 27);
        }

        void yAxis(Graphics2D g, int x, int y, int y0, int y1) {
            CanvasAP.arrow(g, x, y0, x, y1);
        }

        void horizontalAxis(Graphics2D g, int x, int y) {
            g.setColor(SpringPendulumAP.this.BLACK);
            this.xAxis(g, x, y, x - 20, x + 240);
            int t0 = (int)Math.ceil(SpringPendulumAP.this.tU);
            double x0 = (double)x + 20.0 * ((double)t0 - SpringPendulumAP.this.tU);
            for (int i = 0; i <= 10; ++i) {
                int xs = (int)(x0 + (double)(i * 20));
                CanvasAP.line(g, xs, y - 2, xs, y + 2);
                if (xs < x + 5 || xs > x + 215 || t0 + i > 100 && (t0 + i) % 2 != 0) continue;
                this.alignText(g, "" + (t0 + i), this.fH, 1, xs, y + 13);
            }
        }

        void verticalAxis(Graphics2D g, int x, int y, int yLow, int yHigh, double maxSI) {
            int n0;
            double pot10 = Math.pow(10.0, Math.floor(Math.log(maxSI) / Math.log(10.0)));
            double q = maxSI / pot10;
            int n = 10;
            if (q <= 5.0) {
                n = 5;
            }
            if (q <= 2.0) {
                n = 2;
            }
            double yyMax = (double)n * pot10;
            this.yAxis(g, x, y, yLow, yHigh);
            for (int i = n0 = SpringPendulumAP.this.nrSize < 4 ? -n : 0; i <= n; ++i) {
                int ys = y - i * 100 / n;
                CanvasAP.line(g, x - 2, ys, x + 2, ys);
                String s = SpringPendulumAP.this.toString2((double)i * pot10, 1, 1.0E-6);
                CanvasAP.setAntiAliasing(g, false);
                if ((n < 10 || i % 2 == 0) && i != 0) {
                    g.drawString(s, x - 3 - SpringPendulumAP.this.fmH.stringWidth(s), ys + 4);
                }
                CanvasAP.setAntiAliasing(g, true);
            }
            SpringPendulumAP.this.yPix = (double)(100 / n) / pot10;
        }

        void drawMomVal(Graphics2D g, double val, int x, int y) {
            Color c = g.getColor();
            CanvasAP.circle(g, (double)x + (SpringPendulumAP.this.t - SpringPendulumAP.this.tU) * 20.0, (double)y - val * SpringPendulumAP.this.yPix, 2.5, c);
        }

        void sinus(Graphics2D g, double x, double y, double per, double ampl, double xMin, double xMax) {
            double omega = Math.PI * 2 / per;
            double x0 = xMin;
            double y0 = y - ampl * Math.sin(omega * (x0 - x));
            while (x0 < xMax) {
                double x1 = x0 + 1.0;
                double y1 = y - ampl * Math.sin(omega * (x1 - x));
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void diagram(Graphics2D g, int type, int x, int y, double yMax) {
            this.horizontalAxis(g, x, y);
            this.verticalAxis(g, x, y, y + 120, y - 135, yMax);
            this.sinus(g, (double)x - (double)type * SpringPendulumAP.this.T * 5.0 - SpringPendulumAP.this.tU * 20.0, y, SpringPendulumAP.this.T * 20.0, yMax * SpringPendulumAP.this.yPix, x, x + 200);
        }

        void diagramE(Graphics2D g, int x, int y, double energy) {
            g.setColor(SpringPendulumAP.this.BLACK);
            this.horizontalAxis(g, x, y);
            this.verticalAxis(g, x, y, y + 20, y - 125, energy);
            double x1 = x + 200;
            double y1 = (double)y - energy * SpringPendulumAP.this.yPix;
            CanvasAP.line(g, x, y1, x1, y1);
            double ampl = energy * SpringPendulumAP.this.yPix / 2.0;
            this.sinus(g, (double)x - SpringPendulumAP.this.T * 2.5 - SpringPendulumAP.this.tU * 20.0, (double)y - ampl, SpringPendulumAP.this.T * 10.0, ampl, x, x1);
            this.sinus(g, (double)x - SpringPendulumAP.this.T * 7.5 - SpringPendulumAP.this.tU * 20.0, (double)y - ampl, SpringPendulumAP.this.T * 10.0, ampl, x, x1);
        }

        void centerText(Graphics2D g, String s1, String s2, int x, int y) {
            int w1 = SpringPendulumAP.this.fmH.stringWidth(s1);
            int w2 = SpringPendulumAP.this.fmH.stringWidth(s2);
            int x0 = x - (w1 + w2) / 2;
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(s1, x0, y);
            g.drawString(s2, x0 + w1 + 1, y + 5);
            CanvasAP.setAntiAliasing(g, true);
        }

        void writeValue(Graphics2D g, String s, double val, String u, int n, int x1, int x2, int y) {
            CanvasAP.setAntiAliasing(g, false);
            g.drawString(s + ":", x1, y);
            g.drawString(SpringPendulumAP.this.toString2(val, n, 1.0E-6) + " " + u, x2, y);
            CanvasAP.setAntiAliasing(g, true);
        }

        void drawS(Graphics2D g) {
            double s = SpringPendulumAP.this.A * SpringPendulumAP.this.cosPhi;
            this.diagram(g, 1, 220, 180, SpringPendulumAP.this.A);
            g.setColor(SpringPendulumAP.this.BLACK);
            this.alignText(g, SpringPendulumAP.this.symbolElongation, this.fH, 1, 195, 50);
            this.alignText(g, SpringPendulumAP.this.text21, this.fH, 1, 195, 62);
            g.setColor(SpringPendulumAP.this.colorElongation);
            CanvasAP.line(g, 3.0, 100.0, 180.0, 100.0, SpringPendulumAP.this.py);
            this.writeValue(g, SpringPendulumAP.this.text11, s, SpringPendulumAP.this.meter, 3, 220, 400, 370);
            this.writeValue(g, "(" + SpringPendulumAP.this.text16, SpringPendulumAP.this.A, SpringPendulumAP.this.meter + ")", 3, 220, 400, 390);
            this.drawMomVal(g, s, 220, 180);
        }

        void drawV(Graphics2D g) {
            double vMax = SpringPendulumAP.this.A * SpringPendulumAP.this.omega;
            double v = -vMax * SpringPendulumAP.this.sinPhi;
            this.diagram(g, 2, 220, 180, vMax);
            g.setColor(SpringPendulumAP.this.BLACK);
            this.alignText(g, SpringPendulumAP.this.symbolVelocity, this.fH, 1, 192, 50);
            this.alignText(g, SpringPendulumAP.this.text22, this.fH, 1, 192, 62);
            g.setColor(SpringPendulumAP.this.colorVelocity);
            CanvasAP.arrow(g, 3.0, 100.0, SpringPendulumAP.this.py, 100.0, SpringPendulumAP.this.py - v * SpringPendulumAP.this.yPix);
            String mps = SpringPendulumAP.this.meterPerSecond;
            this.writeValue(g, SpringPendulumAP.this.text12, v, mps, 3, 220, 400, 370);
            this.writeValue(g, "(" + SpringPendulumAP.this.text16, vMax, mps + ")", 3, 220, 400, 390);
            this.drawMomVal(g, v, 220, 180);
        }

        void drawA(Graphics2D g) {
            double aMax = SpringPendulumAP.this.A * SpringPendulumAP.this.omega * SpringPendulumAP.this.omega;
            double a = -aMax * SpringPendulumAP.this.cosPhi;
            this.diagram(g, 3, 220, 180, aMax);
            g.setColor(SpringPendulumAP.this.BLACK);
            this.alignText(g, SpringPendulumAP.this.symbolAcceleration, this.fH, 1, 190, 50);
            this.alignText(g, SpringPendulumAP.this.text23, this.fH, 1, 190, 62);
            g.setColor(SpringPendulumAP.this.colorAcceleration);
            CanvasAP.arrow(g, 3.0, 100.0, SpringPendulumAP.this.py, 100.0, SpringPendulumAP.this.py - a * SpringPendulumAP.this.yPix);
            String mps2 = SpringPendulumAP.this.meterPerSecond2;
            this.writeValue(g, SpringPendulumAP.this.text13, a, mps2, 3, 220, 400, 370);
            this.writeValue(g, "(" + SpringPendulumAP.this.text16, aMax, mps2 + ")", 3, 220, 400, 390);
            this.drawMomVal(g, a, 220, 180);
        }

        void drawF(Graphics2D g) {
            double fMax = SpringPendulumAP.this.m * SpringPendulumAP.this.A * SpringPendulumAP.this.omega * SpringPendulumAP.this.omega;
            double f = -fMax * SpringPendulumAP.this.cosPhi;
            this.diagram(g, 3, 220, 180, fMax);
            g.setColor(SpringPendulumAP.this.BLACK);
            this.alignText(g, SpringPendulumAP.this.symbolForce, this.fH, 1, 195, 50);
            this.alignText(g, SpringPendulumAP.this.text24, this.fH, 1, 195, 62);
            g.setColor(SpringPendulumAP.this.colorForce);
            CanvasAP.arrow(g, 3.0, 100.0, SpringPendulumAP.this.py, 100.0, SpringPendulumAP.this.py - f * SpringPendulumAP.this.yPix);
            this.writeValue(g, SpringPendulumAP.this.text14, f, SpringPendulumAP.this.newton, 3, 220, 400, 370);
            this.writeValue(g, "(" + SpringPendulumAP.this.text16, fMax, SpringPendulumAP.this.newton + ")", 3, 220, 400, 390);
            this.drawMomVal(g, f, 220, 180);
        }

        void drawE(Graphics2D g) {
            double e = SpringPendulumAP.this.m * SpringPendulumAP.this.A * SpringPendulumAP.this.A * SpringPendulumAP.this.omega * SpringPendulumAP.this.omega / 2.0;
            double part = SpringPendulumAP.this.cosPhi * SpringPendulumAP.this.cosPhi;
            double eP = part * e;
            double eK = e - eP;
            this.diagramE(g, 220, 160, e);
            g.setColor(SpringPendulumAP.this.BLACK);
            this.centerText(g, SpringPendulumAP.this.symbolEnergy, SpringPendulumAP.this.symbolPotential, 190, 35);
            this.alignText(g, SpringPendulumAP.this.text25, this.fH, 1, 190, 52);
            this.centerText(g, SpringPendulumAP.this.symbolEnergy, SpringPendulumAP.this.symbolKinetic, 250, 35);
            this.alignText(g, SpringPendulumAP.this.text25, this.fH, 1, 250, 52);
            double dy = part * 100.0;
            double y = 200.0 + dy;
            CanvasAP.rectangle(g, 280.0, 200.0, 50.0, dy, SpringPendulumAP.this.colorElongation, true);
            CanvasAP.rectangle(g, 280.0, y, 50.0, 100.0 - dy, SpringPendulumAP.this.colorVelocity, true);
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(SpringPendulumAP.this.colorElongation);
            if (part > 0.001 || SpringPendulumAP.this.on) {
                g.drawString(SpringPendulumAP.this.text17, 340, 215);
            }
            this.writeValue(g, SpringPendulumAP.this.text17, eP, SpringPendulumAP.this.joule, 3, 220, 400, 350);
            this.drawMomVal(g, eP, 220, 160);
            g.setColor(SpringPendulumAP.this.colorVelocity);
            if (part < 0.999 || SpringPendulumAP.this.on) {
                g.drawString(SpringPendulumAP.this.text18, 340, 295);
            }
            this.writeValue(g, SpringPendulumAP.this.text18, eK, SpringPendulumAP.this.joule, 3, 220, 400, 370);
            this.drawMomVal(g, eK, 220, 160);
            g.setColor(SpringPendulumAP.this.BLACK);
            this.writeValue(g, SpringPendulumAP.this.text19, e, SpringPendulumAP.this.joule, 3, 220, 400, 390);
            CanvasAP.setAntiAliasing(g, true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            SpringPendulumAP.this.phi = Math.PI * 2 * SpringPendulumAP.this.t / SpringPendulumAP.this.T;
            SpringPendulumAP.this.cosPhi = Math.cos(SpringPendulumAP.this.phi);
            SpringPendulumAP.this.sinPhi = Math.sin(SpringPendulumAP.this.phi);
            this.pendulum(g2);
            SpringPendulumAP.this.dcl.paint(g, SpringPendulumAP.this.t);
            g.setFont(this.fH);
            switch (SpringPendulumAP.this.nrSize) {
                case 0: {
                    this.drawS(g2);
                    break;
                }
                case 1: {
                    this.drawV(g2);
                    break;
                }
                case 2: {
                    this.drawA(g2);
                    break;
                }
                case 3: {
                    this.drawF(g2);
                    break;
                }
                case 4: {
                    this.drawE(g2);
                }
            }
            g.setColor(SpringPendulumAP.this.BLACK);
            String s = SpringPendulumAP.this.text26 + ":  " + SpringPendulumAP.this.toString2(SpringPendulumAP.this.T, 3, 1.0E-6) + " " + SpringPendulumAP.this.second;
            this.alignText(g2, s, this.fH, 1, 100, 390);
        }
    }
}

