/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ResonanceAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Erwungene Schwingungen, Resonanz", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Resonator:", "Federkonstante:", "Masse:", "D\u00e4mpfung:", "Erreger:", "Kreisfrequenz:", "Diagramm Elongation", "Diagramm Amplitude", "Diagramm Phasenunterschied", "Resonanzkatastrophe!", "(Simulation nicht mehr realistisch!)", ""}, {"en", "Forced Oscillations, Resonance", "Reset", "Start", "Pause", "Resume", "Slow motion", "Resonator:", "Spring constant:", "Mass:", "Attenuation:", "Exciter:", "Angular frequency:", "Elongation diagram", "Amplitude diagram", "Phase difference diagram", "Resonance disaster!", "(Simulation no longer realistic!)", ""}};
    private int[] gaps = new int[]{10, 10, 10, 10, 5, 5, 5, 10, 5, 10, 5, 5, 10, 0, 10};
    final int width = 700;
    final int height = 420;
    final int width0 = 450;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    ResetButton buReset;
    StartButton buStart;
    JTextField tfD;
    JTextField tfM;
    JTextField tfGamma;
    JTextField tfOmega;
    JCheckBox cbSlow;
    JRadioButton rbElong;
    JRadioButton rbAmpl;
    JRadioButton rbPhDiff;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorExciter;
    Color colorResonator;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    double t;
    double d;
    double m;
    double gamma;
    double omega;
    double omega0;
    double omega1;
    final double aE = 0.02;
    double aR;
    double aAbs;
    double aEla;
    double a1;
    double b1;
    double yE;
    double yR;
    double dPhi;
    boolean on;
    boolean slow;
    boolean reskat;
    int nrSize;
    final double eps = 1.0E-6;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 420);
    }

    @Override
    protected void initAttributes() {
        this.on = false;
        this.t = 0.0;
        this.d = 10.0;
        this.m = 1.0;
        this.gamma = 0.2;
        this.omega = 2.0;
        this.slow = false;
        this.reskat = false;
        this.nrSize = 2;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.yellow, "colorButton2");
        this.colorExciter = this.getColor(Color.red, "colorExciter");
        this.colorResonator = this.getColor(Color.blue, "colorResonator");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.coauthor = this.getText(t[18], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 450, 420);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(450, 0, 250, 420);
        this.buReset = new ResetButton(this.text01);
        this.pan.add(this.buReset, this.colorButton1, Color.black);
        this.buStart = new StartButton(this.text02, this.text03, this.text04);
        this.pan.add(this.buStart, this.colorButton2, Color.black);
        this.cbSlow = new JCheckBox(this.text05);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        this.pan.add(this.text06, this.colorResonator);
        this.tfD = this.pan.newInputField(this.text07, this.newtonPerMeter, this.bgPanel, this.colorResonator, 2);
        this.tfD.setText(this.toString2(this.d, 3, 1.0E-6));
        this.tfM = this.pan.newInputField(this.text08, this.kilogram, this.bgPanel, this.colorResonator, 2);
        this.tfM.setText(this.toString2(this.m, 3, 1.0E-6));
        this.tfGamma = this.pan.newInputField(this.text09, this.perSecond, this.bgPanel, this.colorResonator, 2);
        this.tfGamma.setText(this.toString2(this.gamma, 3, 1.0E-6));
        this.pan.add(this.text10, this.colorExciter);
        this.tfOmega = this.pan.newInputField(this.text11, "rad/s", this.bgPanel, this.colorExciter, 2);
        this.tfOmega.setText(this.toString2(this.omega, 3, 1.0E-6));
        ButtonGroup bg = new ButtonGroup();
        this.rbElong = this.pan.newRadioButton(this.text12, false, bg);
        this.rbAmpl = this.pan.newRadioButton(this.text13, true, bg);
        this.rbPhDiff = this.pan.newRadioButton(this.text14, false, bg);
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.buReset.addActionListener(this);
        this.buStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
        this.calculation();
        this.cv.repaint();
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                this.t += this.slow ? dt / 5.0 : dt;
            }
            t0 = t1;
        }
    }

    double elongation(double t) {
        double arg = this.omega * t;
        double yR = this.aAbs * Math.sin(arg) + this.aEla * Math.cos(arg);
        if (this.gamma < 2.0 * this.omega0) {
            if (this.gamma > 0.0 || this.omega != this.omega0) {
                double arg1 = this.omega1 * t;
                yR += Math.exp(-this.gamma * t / 2.0) * (this.a1 * Math.sin(arg1) + this.b1 * Math.cos(arg1));
            } else {
                yR = this.omega * 0.02 * t / 2.0 * Math.sin(arg);
            }
        } else if (this.gamma == 2.0 * this.omega0) {
            yR += Math.exp(-this.gamma * t / 2.0) * (this.a1 * t + this.b1);
        } else {
            double pot1 = Math.exp((-this.gamma / 2.0 + this.omega1) * t);
            double pot2 = Math.exp((-this.gamma / 2.0 - this.omega1) * t);
            yR += pot1 * (this.b1 + this.a1) / 2.0 + pot2 * (this.b1 - this.a1) / 2.0;
        }
        return yR;
    }

    void calculation() {
        this.omega0 = Math.sqrt(this.d / this.m);
        this.omega1 = Math.sqrt(Math.abs(this.d / this.m - this.gamma * this.gamma / 4.0));
        double diff = this.omega0 * this.omega0 - this.omega * this.omega;
        double nenner = diff * diff + this.gamma * this.gamma * this.omega * this.omega;
        if (nenner != 0.0) {
            this.aAbs = this.d * 0.02 / this.m * (this.gamma * this.omega / nenner);
            this.aEla = this.d * 0.02 / this.m * (diff / nenner);
        }
        this.a1 = -(this.aAbs * this.omega + this.gamma / 2.0 * this.aEla);
        if (this.omega1 != 0.0) {
            this.a1 /= this.omega1;
        }
        this.b1 = -this.aEla;
        this.aR = nenner > 0.0 ? 0.02 * this.d / (this.m * Math.sqrt(nenner)) : 1000000.0;
        if (this.gamma == 0.0) {
            this.dPhi = this.omega < this.omega0 ? 0.0 : (this.omega == this.omega0 ? 1.5707963267948966 : Math.PI);
        } else {
            this.dPhi = Math.atan(this.gamma * this.omega / diff);
            if (this.dPhi < 0.0) {
                this.dPhi += Math.PI;
            }
        }
        this.reskat = false;
    }

    void enableTF(boolean flag) {
        this.tfD.setEnabled(flag);
        this.tfM.setEnabled(flag);
        this.tfGamma.setEnabled(flag);
        this.tfOmega.setEnabled(flag);
    }

    void inputCalc() {
        this.d = this.inputTF2(this.tfD, 5.0, 50.0, 3, 1.0E-6);
        this.m = this.inputTF2(this.tfM, 1.0, 10.0, 3, 1.0E-6);
        this.gamma = this.inputTF2(this.tfGamma, 0.0, 100.0, 3, 1.0E-6);
        this.omega = this.inputTF2(this.tfOmega, 0.0, 10.0, 3, 1.0E-6);
        this.calculation();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.inputCalc();
        Object o = ae.getSource();
        if (o == this.buReset) {
            this.buStart.setState(0);
            this.enableTF(true);
            this.reskat = false;
            this.t = 0.0;
        } else if (o == this.buStart) {
            this.buStart.setState();
            this.enableTF(false);
        }
        this.on = this.buStart.getState() == 1;
        this.slow = this.cbSlow.isSelected();
        if (this.rbElong.isSelected()) {
            this.nrSize = 1;
        } else if (this.rbAmpl.isSelected()) {
            this.nrSize = 2;
        } else if (this.rbPhDiff.isSelected()) {
            this.nrSize = 3;
        }
        this.repaint();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, ResonanceAP.this.bgCanvas);
            ResonanceAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void spring(Graphics2D g, double x, double yO, double yU) {
            double ampl = 10.0;
            double k = 75.39822368615503 / (yU - yO);
            g.setColor(Color.black);
            CanvasAP.line(g, x, yO - 10.0, x, yO);
            CanvasAP.line(g, x, yU, x, yU + 10.0);
            double x0 = x;
            double y0 = yO;
            while (y0 < yU) {
                double y1 = y0 + 1.0;
                double x1 = x + ampl * Math.sin(k * (y1 - yO));
                if (y1 > yU) {
                    x1 = Math.min(x1, x);
                }
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void pendulum(Graphics2D g) {
            int pix = 500;
            int x0 = 70;
            int yE0 = 90;
            int yR0 = 255;
            ResonanceAP.this.yE = 0.02 * Math.cos(ResonanceAP.this.omega * ResonanceAP.this.t);
            double yyE = 500.0 * ResonanceAP.this.yE;
            CanvasAP.circle(g, 70.0, 90.0 - yyE, 4.0, ResonanceAP.this.colorExciter, true);
            ResonanceAP.this.yR = ResonanceAP.this.elongation(ResonanceAP.this.t);
            double yy = 500.0 * ResonanceAP.this.yR;
            CanvasAP.rectangle(g, 60.0, 250.0 - yy, 20.0, 10.0, ResonanceAP.this.colorResonator, true);
            g.setColor(Color.black);
            if (yy < yyE + 120.0) {
                this.spring(g, 70.0, 100.0 - yyE, 240.0 - yy);
            } else if (!ResonanceAP.this.reskat) {
                ResonanceAP.this.reskat = true;
            }
            if (yy > yyE + 210.0) {
                this.spring(g, 70.0, 270.0 - yy, 80.0 - yyE);
            }
            g.setColor(ResonanceAP.this.colorExciter);
            CanvasAP.arrow(g, 45.0, 80.0, 45.0, 100.0);
            CanvasAP.arrow(g, 45.0, 100.0, 45.0, 80.0);
            CanvasAP.line(g, 43.0, 90.0, 47.0, 90.0);
            g.setColor(ResonanceAP.this.colorResonator);
            double y1 = 255.0 - ResonanceAP.this.aR * 500.0;
            double y2 = 255.0 + ResonanceAP.this.aR * 500.0;
            CanvasAP.arrow(g, 95.0, y1, 95.0, y2);
            CanvasAP.arrow(g, 95.0, y2, 95.0, y1);
            CanvasAP.line(g, 93.0, 255.0, 97.0, 255.0);
            if (ResonanceAP.this.reskat) {
                g.drawString(ResonanceAP.this.text15, 30, 300);
                g.drawString(ResonanceAP.this.text16, 30, 320);
            }
        }

        void diagram1(Graphics2D g, int x, int y) {
            double f = 50.0 / (ResonanceAP.this.aR > 0.02 ? ResonanceAP.this.aR : 0.02);
            double fT = 20.0;
            if (f < 500.0) {
                f = 500.0;
            }
            double t0 = ResonanceAP.this.t < 100.0 / fT ? 0.0 : ResonanceAP.this.t - 100.0 / fT;
            g.setColor(Color.black);
            CanvasAP.arrow(g, x - 10, y, x + 220, y);
            CanvasAP.arrow(g, x, y + 100, x, y - 100);
            g.setColor(ResonanceAP.this.colorExciter);
            double x0 = x;
            double yyE = 0.02 * Math.cos(ResonanceAP.this.omega * t0);
            double y0 = (double)y - yyE * f;
            while (x0 < (double)(x + 200)) {
                double x1 = x0 + 1.0;
                double tt = t0 + (x1 - (double)x) / fT;
                yyE = 0.02 * Math.cos(ResonanceAP.this.omega * tt);
                double y1 = (double)y - yyE * f;
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
            x0 = (double)x + (ResonanceAP.this.t - t0) * fT;
            y0 = (double)y - ResonanceAP.this.yE * f;
            CanvasAP.circle(g, x0, y0, 2.0, ResonanceAP.this.colorExciter, true);
            g.setColor(ResonanceAP.this.colorResonator);
            x0 = x;
            double yyR = ResonanceAP.this.elongation(t0);
            y0 = (double)y - yyR * f;
            while (x0 < (double)(x + 200)) {
                double x1 = x0 + 1.0;
                double tt = t0 + (x1 - (double)x) / fT;
                yyR = ResonanceAP.this.elongation(tt);
                double y1 = (double)y - yyR * f;
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
            x0 = (double)x + (ResonanceAP.this.t - t0) * fT;
            y0 = (double)y - ResonanceAP.this.yR * f;
            CanvasAP.circle(g, x0, y0, 2.0, ResonanceAP.this.colorResonator, true);
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(Color.black);
            g.drawString("t", x + 215, y + 15);
            g.setColor(ResonanceAP.this.colorExciter);
            g.drawString("y", x - 20, y - 92);
            g.drawString("E", x - 12, y - 87);
            g.setColor(ResonanceAP.this.colorResonator);
            g.drawString("y", x - 20, y - 75);
            g.drawString("R", x - 12, y - 70);
            CanvasAP.setAntiAliasing(g, true);
        }

        void omegaAxis(Graphics2D g, int x, int y) {
            CanvasAP.arrow(g, x - 10, y, x + 220, y);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString("\u03c9", x + 209, y + 14);
            g.drawLine(x + 50, y - 3, x + 50, y + 3);
            g.drawString("\u03c9", x + 46, y + 14);
            g.drawString("0", x + 57, y + 19);
            CanvasAP.setAntiAliasing(g, true);
        }

        void diagram2(Graphics2D g, int x, int y) {
            double f = 500.0;
            this.omegaAxis(g, x, y);
            CanvasAP.arrow(g, x, y + 10, x, y - 180);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString("A", x - 15, y - 170);
            CanvasAP.setAntiAliasing(g, true);
            double a0 = 0.02 * ResonanceAP.this.d / ResonanceAP.this.m;
            double b = ResonanceAP.this.gamma * ResonanceAP.this.gamma;
            double q0 = ResonanceAP.this.omega0 * ResonanceAP.this.omega0;
            double om0 = ResonanceAP.this.omega0 / 50.0;
            double x0 = x;
            double y0 = (double)y - 0.02 * f;
            while (x0 < (double)(x + 220)) {
                double x1 = x0 + 1.0;
                double o = om0 * (x1 - (double)x);
                double q = o * o;
                double diff = q0 - q;
                double a = a0 / Math.sqrt(diff * diff + b * q);
                double y1 = (double)y - a * f;
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
            x0 = (double)x + ResonanceAP.this.omega / om0;
            y0 = (double)y - ResonanceAP.this.aR * f;
            CanvasAP.circle(g, x0, y0, 2.0, Color.red, true);
        }

        void diagram3(Graphics2D g, int x, int y) {
            double f = 38.197186342054884;
            this.omegaAxis(g, x, y);
            CanvasAP.arrow(g, x, y + 10, x, y - 180);
            CanvasAP.line(g, x - 3, y - 60, x + 3, y - 60);
            CanvasAP.line(g, x - 14, y - 60, x - 6, y - 60);
            CanvasAP.line(g, x - 3, y - 120, x + 3, y - 120);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString("\u0394\u03c6", x - 22, y - 170);
            g.drawString("\u03c0", x - 14, y - 62);
            g.drawString("2", x - 13, y - 48);
            g.drawString("\u03c0", x - 14, y - 117);
            CanvasAP.setAntiAliasing(g, true);
            double q0 = ResonanceAP.this.omega0 * ResonanceAP.this.omega0;
            double om0 = ResonanceAP.this.omega0 / 50.0;
            double x0 = x;
            double y0 = y;
            if (ResonanceAP.this.gamma > 0.0) {
                while (x0 < (double)(x + 220)) {
                    double x1 = x0 + 1.0;
                    double o = om0 * (x1 - (double)x);
                    double dphi = Math.atan(ResonanceAP.this.gamma * o / (q0 - o * o));
                    if (dphi < 0.0) {
                        dphi += Math.PI;
                    }
                    double y1 = (double)y - dphi * f;
                    CanvasAP.line(g, x0, y0, x1, y1);
                    x0 = x1;
                    y0 = y1;
                }
            } else {
                CanvasAP.line(g, x + 50, y, x + 50, y - 120);
                CanvasAP.line(g, x + 50, y - 120, x + 230, y - 120);
            }
            x0 = (double)x + ResonanceAP.this.omega / om0;
            y0 = (double)y - ResonanceAP.this.dPhi * f;
            CanvasAP.circle(g, x0, y0, 2.0, Color.red, true);
        }

        void writeValues(Graphics2D g) {
            int y0 = 280;
            int x0 = 280;
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(ResonanceAP.this.colorExciter);
            String s = "\u03c9 ";
            int l = ResonanceAP.this.fmH.stringWidth(s);
            s = s + "= " + ResonanceAP.this.toString2(ResonanceAP.this.omega, 3, 1.0E-6) + " rad/s";
            g.drawString(s, 280 - l, 280);
            s = "AE ";
            l = ResonanceAP.this.fmH.stringWidth(s);
            g.drawString("A", 280 - l, 300);
            l = ResonanceAP.this.fmH.stringWidth("E ");
            g.drawString("E", 280 - l, 305);
            g.drawString("= " + ResonanceAP.this.toString2(2.0, 3, 1.0E-6) + " " + ResonanceAP.this.centimeter, 280, 300);
            g.setColor(ResonanceAP.this.colorResonator);
            l = ResonanceAP.this.fmH.stringWidth("\u03c90 ");
            g.drawString("\u03c9", 280 - l, 320);
            l = ResonanceAP.this.fmH.stringWidth("0 ");
            g.drawString("0", 280 - l, 325);
            g.drawString("= " + ResonanceAP.this.toString2(ResonanceAP.this.omega0, 3, 1.0E-6) + " rad/s", 280, 320);
            s = "A ";
            l = ResonanceAP.this.fmH.stringWidth(s);
            s = ResonanceAP.this.aR < 1000000.0 ? s + "= " + ResonanceAP.this.toString2(ResonanceAP.this.aR * 100.0, 3, 1.0E-6) + " " + ResonanceAP.this.centimeter : s + "= \u221e";
            g.drawString(s, 280 - l, 340);
            g.setColor(Color.black);
            s = "\u0394\u03c6 ";
            l = ResonanceAP.this.fmH.stringWidth(s);
            g.drawString(s, 280 - l, 360);
            s = this.frame.toString(ResonanceAP.this.dPhi / Math.PI, 3);
            l = ResonanceAP.this.fmH.stringWidth(s);
            g.drawString("= " + s + " \u03c0", 280, 360);
            CanvasAP.setAntiAliasing(g, true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            g.setClip(0, 20, 450, 380);
            this.pendulum(g2);
            this.writeValues(g2);
            if (ResonanceAP.this.nrSize == 1) {
                this.diagram1(g2, 180, 130);
            } else if (ResonanceAP.this.nrSize == 2) {
                this.diagram2(g2, 180, 210);
            } else if (ResonanceAP.this.nrSize == 3) {
                this.diagram3(g2, 180, 210);
            }
        }
    }
}

