/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class CoupledPendulaAP
extends AP6 {
    static final String[][] text = new String[][]{{"de", "Gekoppelte Pendel", "Zur\u00fcck", "Start", "Pause", "Weiter", "Zeitlupe", "Anfangspositionen:", "Pendel 1", "Pendel 2", ""}, {"en", "Coupled Pendula", "Reset", "Start", "Pause", "Resume", "Slow motion", "Initial positions:", "Pendulum 1", "Pendulum 2", ""}};
    private int[] gaps = new int[]{10, 5, 10, 10, 10, 0, 20, 0, 10};
    final int width = 760;
    final int height = 400;
    final int width0 = 560;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    ResetButton bReset;
    StartButton bStart;
    JCheckBox cbSlow;
    JTextField tfAlpha01;
    JTextField tfAlpha02;
    Color bgCanvas;
    Color bgPanel;
    Color color1;
    Color color2;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    final double g = 9.81;
    final double l = 1.0;
    final double lPix = 240.0;
    final double D = 1.0;
    final double m = 1.0;
    final int ay = 40;
    double t;
    double tU;
    double omega1;
    double omega2;
    double alpha1;
    double alpha2;
    double alpha01;
    double alpha02;
    double a1;
    double a2;
    boolean on;
    boolean slow;
    double px;
    double py;
    double fx1;
    double fy1;
    double fx2;
    double fy2;
    double[] p1x;
    double[] p1y;
    double[] p2x;
    double[] p2y;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(760, 400);
    }

    @Override
    protected void initAttributes() {
        this.p1x = new double[4];
        this.p1y = new double[4];
        this.p2x = new double[4];
        this.p2y = new double[4];
        this.tU = 0.0;
        this.t = 0.0;
        this.slow = false;
        this.on = false;
        this.alpha01 = -0.17453292519943295;
        this.alpha02 = 0.0;
        this.calculation();
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.color1 = this.getColor(Color.blue, "color1");
        this.color2 = this.getColor(Color.red, "color2");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.coauthor = this.getText(t[10], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 560, 400);
        this.add(this.cv);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(560, 0, 200, 400);
        this.bReset = new ResetButton(this.text01);
        this.pan.add(this.bReset, Color.cyan, Color.black);
        this.bStart = new StartButton(this.text02, this.text03, this.text04);
        this.pan.add(this.bStart, Color.yellow, Color.black);
        this.cbSlow = new JCheckBox(this.text05);
        this.pan.add(this.cbSlow, this.bgPanel, Color.black);
        this.pan.add(this.text06);
        this.tfAlpha01 = this.pan.newInputField("", this.degree, Color.white, Color.black, 2);
        this.tfAlpha01.setText(this.toString(this.alpha01 / (Math.PI / 180), 1));
        this.tfAlpha02 = this.pan.newInputField("", this.degree, Color.white, Color.black, 2);
        this.tfAlpha02.setText(this.toString(this.alpha02 / (Math.PI / 180), 1));
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.bReset.addActionListener(this);
        this.bStart.addActionListener(this);
        this.cbSlow.addActionListener(this);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            if (this.on) {
                this.cv.repaint();
            }
            try {
                Thread.sleep(this.on ? 50L : 100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            if (this.on) {
                double dt = (double)(t1 - t0) / 1000.0;
                if (this.slow) {
                    dt /= 10.0;
                }
                this.t += dt;
            }
            t0 = t1;
            this.tU = Math.max(this.t - 5.0, 0.0);
        }
    }

    void setPoint(double[] pX, double[] pY, int i, double x, double y) {
        pX[i] = x;
        pY[i] = y;
    }

    void calculation() {
        this.omega1 = Math.sqrt(9.81);
        this.omega2 = Math.sqrt(11.81);
        this.a1 = (this.alpha01 + this.alpha02) / 2.0;
        this.a2 = (this.alpha01 - this.alpha02) / 2.0;
    }

    void enableTF(boolean flag) {
        this.tfAlpha01.setEnabled(flag);
        this.tfAlpha02.setEnabled(flag);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.slow = this.cbSlow.isSelected();
        this.alpha01 = this.inputTF2(this.tfAlpha01, -10.0, 10.0, 3, 1.0E-6) * (Math.PI / 180);
        this.alpha02 = this.inputTF2(this.tfAlpha02, -10.0, 10.0, 3, 1.0E-6) * (Math.PI / 180);
        this.calculation();
        Object o = ae.getSource();
        if (o == this.bReset) {
            this.bStart.setState(0);
            this.enableTF(true);
            this.t = 0.0;
        } else if (o == this.bStart) {
            this.bStart.setState();
            this.enableTF(false);
        }
        this.on = this.bStart.getState() == 1;
        this.repaint();
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, CoupledPendulaAP.this.bgCanvas);
            CoupledPendulaAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void pendulum(Graphics2D g, int ax, double alpha, double[] pX, double[] pY, Color c) {
            double cos = Math.cos(alpha);
            double sin = Math.sin(alpha);
            CoupledPendulaAP.this.px = (double)ax + 240.0 * sin;
            CoupledPendulaAP.this.py = 40.0 + 240.0 * cos;
            g.setColor(Color.black);
            CanvasAP.line(g, ax, 40.0, CoupledPendulaAP.this.px, CoupledPendulaAP.this.py);
            double c10 = 10.0 * cos;
            double s10 = 10.0 * sin;
            double c30 = 30.0 * cos;
            double s30 = 30.0 * sin;
            CoupledPendulaAP.this.setPoint(pX, pY, 0, CoupledPendulaAP.this.px - c10, CoupledPendulaAP.this.py + s10);
            CoupledPendulaAP.this.setPoint(pX, pY, 1, CoupledPendulaAP.this.px - c10 + s30, CoupledPendulaAP.this.py + s10 + c30);
            CoupledPendulaAP.this.setPoint(pX, pY, 2, CoupledPendulaAP.this.px + c10 + s30, CoupledPendulaAP.this.py - s10 + c30);
            CoupledPendulaAP.this.setPoint(pX, pY, 3, CoupledPendulaAP.this.px + c10, CoupledPendulaAP.this.py - s10);
            CanvasAP.polygon(g, pX, pY, c, true);
        }

        void spring(Graphics2D g, double x0, double y0, double x1, double y1) {
            double v00;
            double u00;
            g.setColor(Color.black);
            double dx = x1 - x0;
            double dy = y1 - y0;
            double l = Math.sqrt(dx * dx + dy * dy);
            if (l < 20.0) {
                return;
            }
            l = 10.0 / l;
            double u0 = u00 = x0 + l * dx;
            double v0 = v00 = y0 + l * dy;
            double u1 = x1 - l * dx;
            double v1 = y1 - l * dy;
            CanvasAP.line(g, x0, y0, u0, v0);
            CanvasAP.line(g, u1, v1, x1, y1);
            double du = u1 - u0;
            double dv = v1 - v0;
            l = Math.sqrt(du * du + dv * dv);
            int n = 10;
            int m = 5;
            int iMax = n * 360 / m;
            int br = 10;
            for (int i = 1; i <= iMax; ++i) {
                double a = (double)i / (double)iMax;
                double b = (double)br / l * Math.sin((double)(i * m) * (Math.PI / 180));
                u1 = u00 + a * du + b * dv;
                v1 = v00 + a * dv - b * du;
                CanvasAP.line(g, u0, v0, u1, v1);
                u0 = u1;
                v0 = v1;
            }
        }

        void diagram(Graphics2D g, int x, int y, int nr) {
            double t0;
            int width = 200;
            int height = 100;
            double dt = 20.0;
            double pixT = (double)width / (2.0 * dt);
            double a = CoupledPendulaAP.this.a1;
            double b = nr == 1 ? CoupledPendulaAP.this.a2 : -CoupledPendulaAP.this.a2;
            g.setColor(Color.black);
            CanvasAP.arrow(g, x, y, x + width, y);
            if (CoupledPendulaAP.this.t < dt) {
                CanvasAP.arrow(g, x, y + height / 2, x, y - height / 2);
            }
            double tt = t0 = CoupledPendulaAP.this.t - Math.min(CoupledPendulaAP.this.t, dt);
            double yy = a * Math.cos(CoupledPendulaAP.this.omega1 * tt) + b * Math.cos(CoupledPendulaAP.this.omega2 * tt);
            double pixY = 200.0;
            double x0 = x;
            double y0 = (double)y - pixY * yy;
            while (x0 < (double)(x + width - 20)) {
                double x1 = x0 + 1.0;
                tt = (x1 - (double)x) / pixT + t0;
                yy = a * Math.cos(CoupledPendulaAP.this.omega1 * tt) + b * Math.cos(CoupledPendulaAP.this.omega2 * tt);
                double y1 = (double)y - pixY * yy;
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
            Color c = nr == 1 ? CoupledPendulaAP.this.color1 : CoupledPendulaAP.this.color2;
            CanvasAP.rectangle(g, x - 10, y - height / 2 - 10, width + 20, height + 20, c, false);
            yy = a * Math.cos(CoupledPendulaAP.this.omega1 * CoupledPendulaAP.this.t) + b * Math.cos(CoupledPendulaAP.this.omega2 * CoupledPendulaAP.this.t);
            CanvasAP.circle(g, (double)x + Math.min((double)(width / 2), CoupledPendulaAP.this.t * pixT), (double)y - pixY * yy, 2.5, c);
            CanvasAP.setAntiAliasing(g, false);
            g.setColor(Color.black);
            g.drawString("t", x + width - 8, y + 14);
            CanvasAP.setAntiAliasing(g, true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            g.setFont(this.fH);
            double cos1 = Math.cos(CoupledPendulaAP.this.omega1 * CoupledPendulaAP.this.t);
            double cos2 = Math.cos(CoupledPendulaAP.this.omega2 * CoupledPendulaAP.this.t);
            CoupledPendulaAP.this.alpha1 = CoupledPendulaAP.this.a1 * cos1 + CoupledPendulaAP.this.a2 * cos2;
            CoupledPendulaAP.this.alpha2 = CoupledPendulaAP.this.a1 * cos1 - CoupledPendulaAP.this.a2 * cos2;
            g.setColor(Color.black);
            g.fillRect(30, 30, 240, 10);
            this.pendulum(g2, 80, CoupledPendulaAP.this.alpha1, CoupledPendulaAP.this.p1x, CoupledPendulaAP.this.p1y, CoupledPendulaAP.this.color1);
            this.pendulum(g2, 220, CoupledPendulaAP.this.alpha2, CoupledPendulaAP.this.p2x, CoupledPendulaAP.this.p2y, CoupledPendulaAP.this.color2);
            CoupledPendulaAP.this.fx1 = (CoupledPendulaAP.this.p1x[2] + CoupledPendulaAP.this.p1x[3]) / 2.0;
            CoupledPendulaAP.this.fy1 = (CoupledPendulaAP.this.p1y[2] + CoupledPendulaAP.this.p1y[3]) / 2.0;
            CoupledPendulaAP.this.fx2 = (CoupledPendulaAP.this.p2x[0] + CoupledPendulaAP.this.p2x[1]) / 2.0;
            CoupledPendulaAP.this.fy2 = (CoupledPendulaAP.this.p2y[0] + CoupledPendulaAP.this.p2y[1]) / 2.0;
            this.spring(g2, CoupledPendulaAP.this.fx1, CoupledPendulaAP.this.fy1, CoupledPendulaAP.this.fx2, CoupledPendulaAP.this.fy2);
            this.diagram(g2, 320, 125, 1);
            this.diagram(g2, 320, 290, 2);
            CanvasAP.setAntiAliasing(g2, false);
            g.setColor(CoupledPendulaAP.this.color1);
            g.drawString(CoupledPendulaAP.this.text07, 40, 340);
            g.drawString(CoupledPendulaAP.this.text07, 315, 55);
            g.setColor(CoupledPendulaAP.this.color2);
            g.drawString(CoupledPendulaAP.this.text08, 180, 340);
            g.drawString(CoupledPendulaAP.this.text08, 315, 220);
        }
    }
}

