/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class StandingLongitudinalWavesAP
extends AP6
implements MouseListener {
    static final String[][] text = new String[][]{{"de", "Stehende L\u00e4ngswellen in einem Rohr", "Rohrform:", "beidseitig offen", "einseitig offen", "beidseitig geschlossen", "Eigenschwingung:", "Grundschwingung", "1. Oberschwingung", "2. Oberschwingung", "3. Oberschwingung", "4. Oberschwingung", "5. Oberschwingung", "Tiefer", "H\u00f6her", "Rohrl\u00e4nge:", "Wellenl\u00e4nge:", "Frequenz:", "K", "B", "Elongation der Teilchen", "Abweichung vom mittleren Druck", ""}, {"en", "Standing Longitudinal Waves in a Tube", "Form of tube:", "both sides open", "one side open", "both sides closed", "Vibrational mode:", "fundamental", "1st overtone", "2nd overtone", "3rd overtone", "4th overtone", "5th overtone", "Lower", "Higher", "Length of tube:", "Wavelength:", "Frequency:", "N", "A", "Displacement of particles", "Divergence from average pressure", ""}};
    private int[] gaps = new int[]{10, 5, 5, 5, 10, 5, 10, 5, 10, 5, 5, 20, 5, 10};
    final int width = 660;
    final int height = 420;
    final int width0 = 450;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JRadioButton rbOpen;
    JRadioButton rbHalfOpen;
    JRadioButton rbClosed;
    JLabel lbOscillation;
    JLabel lbWavelength;
    JLabel lbFrequency;
    JButton buHigher;
    JButton buLower;
    JTextField tfLength;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton1;
    Color colorButton2;
    Color colorParticle;
    Color colorElongation;
    Color colorPressure;
    String coauthor;
    String text01;
    String text02;
    String text03;
    String text04;
    String text05;
    String text06;
    String text07;
    String text08;
    String text09;
    String text10;
    String text11;
    String text12;
    String text13;
    String text14;
    String text15;
    String text16;
    String text17;
    String text18;
    String text19;
    String text20;
    double t;
    int type;
    int nrOsc;
    final double cReal = 343.5;
    final double c = 2000.0;
    double lengthReal;
    final int length = 300;
    final int left = 60;
    double lambdaReal;
    double lambda;
    double lambda4;
    double nyReal;
    double omega;
    double k;
    double aMax;
    double cos;
    int xT;
    int yT;
    final double eps = 1.0E-6;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(660, 420);
    }

    @Override
    protected void initAttributes() {
        this.nrOsc = 0;
        this.type = 0;
        this.lengthReal = 1.0;
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorButton1 = this.getColor(Color.cyan, "colorButton1");
        this.colorButton2 = this.getColor(Color.orange, "colorButton2");
        this.colorParticle = this.getColor(Color.blue, "colorParticle");
        this.colorElongation = this.getColor(Color.red, "colorElongation");
        this.colorPressure = this.getColor(Color.magenta, "colorPressure");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.text02 = this.getText(t[3], "text02");
        this.text03 = this.getText(t[4], "text03");
        this.text04 = this.getText(t[5], "text04");
        this.text05 = this.getText(t[6], "text05");
        this.text06 = this.getText(t[7], "text06");
        this.text07 = this.getText(t[8], "text07");
        this.text08 = this.getText(t[9], "text08");
        this.text09 = this.getText(t[10], "text09");
        this.text10 = this.getText(t[11], "text10");
        this.text11 = this.getText(t[12], "text11");
        this.text12 = this.getText(t[13], "text12");
        this.text13 = this.getText(t[14], "text13");
        this.text14 = this.getText(t[15], "text14");
        this.text15 = this.getText(t[16], "text15");
        this.text16 = this.getText(t[17], "text16");
        this.text17 = this.getText(t[18], "text17");
        this.text18 = this.getText(t[19], "text18");
        this.text19 = this.getText(t[20], "text19");
        this.text20 = this.getText(t[21], "text20");
        this.coauthor = this.getText(t[22], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 450, 420);
        this.add(this.cv);
        this.cv.addMouseListener(this);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 3, this.gaps);
        this.pan.setBounds(450, 0, 210, 420);
        this.pan.add(this.text01);
        ButtonGroup bg = new ButtonGroup();
        this.rbOpen = this.newRadioButton(this.text02, true, bg);
        this.rbHalfOpen = this.newRadioButton(this.text03, false, bg);
        this.rbClosed = this.newRadioButton(this.text04, false, bg);
        this.pan.add(this.text05);
        this.lbOscillation = new JLabel(this.text06);
        this.pan.add(this.lbOscillation, this.bgPanel, 0, 3, 10, 10);
        this.lbOscillation.setForeground(Color.red);
        this.buLower = this.pan.newButton(this.text12, this.colorButton1);
        this.buHigher = this.pan.newButton(this.text13, this.colorButton2);
        this.tfLength = this.pan.newInputField(this.text14, this.meter, Color.white, Color.black, 3);
        this.lbWavelength = this.pan.newOutputField(this.text15, this.meter, this.bgPanel, Color.black, 3);
        this.lbFrequency = this.pan.newOutputField(this.text16, this.hertz, this.bgPanel, Color.black, 3);
        this.buLower.setEnabled(false);
        this.pan.add(1998);
        this.pan.add(this.coauthor);
        this.add(this.pan);
        this.calculation();
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            this.t += (double)(t1 - t0) / 1000.0;
            t0 = t1;
        }
    }

    JRadioButton newRadioButton(String text, boolean s, ButtonGroup bg) {
        JRadioButton rb = new JRadioButton(text, s);
        bg.add(rb);
        this.pan.add(rb, this.bgPanel, 0, 3, 20, 10);
        rb.addActionListener(this);
        return rb;
    }

    double position(double x0) {
        double arg = (x0 - 60.0) * this.k;
        double a = this.aMax * (this.type == 0 ? Math.cos(arg) : Math.sin(arg));
        return x0 + a * this.cos;
    }

    double dpPixel(double x0) {
        double arg = (x0 - 60.0) * this.k;
        double a = this.aMax * (this.type == 0 ? Math.sin(arg) : -Math.cos(arg));
        return a * this.cos;
    }

    void newOscillation() {
        String s = "";
        switch (this.nrOsc) {
            case 0: {
                s = this.text06;
                break;
            }
            case 1: {
                s = this.text07;
                break;
            }
            case 2: {
                s = this.text08;
                break;
            }
            case 3: {
                s = this.text09;
                break;
            }
            case 4: {
                s = this.text10;
                break;
            }
            case 5: {
                s = this.text11;
            }
        }
        this.lbOscillation.setText(s);
        this.buLower.setEnabled(this.nrOsc != 0);
        this.buHigher.setEnabled(this.nrOsc != 5);
    }

    void calculation() {
        double factor = this.type == 1 ? 4.0 / (double)(2 * this.nrOsc + 1) : 2.0 / (double)(this.nrOsc + 1);
        this.lambdaReal = factor * this.lengthReal;
        this.lambda = factor * 300.0;
        this.lambda4 = this.lambda / 4.0;
        this.omega = 2000.0 / (this.lambda * 2.0 * Math.PI);
        this.k = Math.PI * 2 / this.lambda;
        this.nyReal = 343.5 / this.lambdaReal;
        this.tfLength.setText(this.toString2(this.lengthReal, 3, 1.0E-6));
        this.lbWavelength.setText(this.toString2(this.lambdaReal, 3, 1.0E-6));
        if (this.nyReal < 1000.0) {
            this.lbFrequency.setText(this.toString2(this.nyReal, 3, 1.0E-6));
        } else {
            this.lbFrequency.setText(this.toString(this.nyReal, 0));
        }
        this.aMax = this.lambda / 24.0;
        this.yT = -1;
        this.xT = -1;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.rbOpen) {
            this.type = 0;
        } else if (o == this.rbHalfOpen) {
            this.type = 1;
        } else if (o == this.rbClosed) {
            this.type = 2;
        } else if (o == this.buLower && this.nrOsc > 0) {
            --this.nrOsc;
            this.newOscillation();
        } else if (o == this.buHigher && this.nrOsc < 5) {
            ++this.nrOsc;
            this.newOscillation();
        } else if (o instanceof JTextField) {
            this.lengthReal = this.toDouble(this.tfLength.getText());
            if (this.lengthReal > 10.0) {
                this.lengthReal = 10.0;
            }
            if (this.lengthReal < 0.1) {
                this.lengthReal = 0.1;
            }
        }
        this.calculation();
        this.pan.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        if (x < 60 || x > 360 || y < 30 || y > 90) {
            this.yT = -1;
            this.xT = -1;
        } else {
            this.xT = x;
            this.yT = y;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, StandingLongitudinalWavesAP.this.bgCanvas);
            StandingLongitudinalWavesAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void seriesParticles(Graphics2D g, double x, int yMin, int yMax) {
            double posX = StandingLongitudinalWavesAP.this.position(x);
            for (int y = yMin; y <= yMax; y += 20) {
                CanvasAP.circle(g, posX, y, 2.0, StandingLongitudinalWavesAP.this.colorParticle, true);
            }
        }

        void drawMarks(Graphics2D g, int art, int y) {
            if (StandingLongitudinalWavesAP.this.lambda <= 0.0) {
                return;
            }
            g.setColor(Color.black);
            int iMax = (int)Math.round(300.0 / StandingLongitudinalWavesAP.this.lambda4);
            for (int i = 0; i <= iMax; ++i) {
                double xxM = 60.0 + (double)i * StandingLongitudinalWavesAP.this.lambda4;
                CanvasAP.line(g, xxM, y - 2, xxM, y + 2);
                if (art == 0) continue;
                String node = StandingLongitudinalWavesAP.this.text17;
                String antinode = StandingLongitudinalWavesAP.this.text18;
                int xM = (int)Math.round(xxM) - 3;
                int yM = y + 13;
                if (StandingLongitudinalWavesAP.this.type >= 1 && i % 2 == 0 || StandingLongitudinalWavesAP.this.type == 0 && i % 2 == 1) {
                    g.drawString(art == 1 ? node : antinode, xM, yM);
                    continue;
                }
                g.drawString(art == 1 ? antinode : node, xM, yM);
            }
        }

        void drawTube(Graphics2D g) {
            int x;
            StandingLongitudinalWavesAP.this.cos = Math.cos(StandingLongitudinalWavesAP.this.omega * StandingLongitudinalWavesAP.this.t);
            g.setColor(Color.black);
            g.fillRect(60, 27, 300, 3);
            g.fillRect(60, 90, 300, 3);
            if (StandingLongitudinalWavesAP.this.type >= 1) {
                g.fillRect(57, 27, 3, 66);
            }
            if (StandingLongitudinalWavesAP.this.type == 2) {
                g.fillRect(360, 27, 3, 66);
            }
            this.drawMarks(g, 0, 27);
            this.drawMarks(g, 0, 92);
            g.setColor(StandingLongitudinalWavesAP.this.colorParticle);
            for (x = 60; x <= 360; x += 20) {
                this.seriesParticles(g, x, 50, 70);
            }
            for (x = 70; x <= 350; x += 20) {
                this.seriesParticles(g, x, 40, 80);
            }
            if (StandingLongitudinalWavesAP.this.yT < 0) {
                return;
            }
            double x2 = StandingLongitudinalWavesAP.this.position(StandingLongitudinalWavesAP.this.xT);
            g.setColor(StandingLongitudinalWavesAP.this.colorElongation);
            CanvasAP.line(g, StandingLongitudinalWavesAP.this.xT, StandingLongitudinalWavesAP.this.yT, x2, StandingLongitudinalWavesAP.this.yT);
            CanvasAP.circle(g, x2, StandingLongitudinalWavesAP.this.yT, 2.0, StandingLongitudinalWavesAP.this.colorElongation, true);
        }

        void drawSinus(Graphics2D g, double x, double y, double per, double ampl, double xMin, double xMax) {
            double k = Math.PI * 2 / per;
            double x0 = xMin;
            double y0 = y - ampl * Math.sin(k * (x0 - x));
            while (x0 < xMax) {
                double x1 = x0 + 1.0;
                double y1 = y - ampl * Math.sin(k * (x1 - x));
                CanvasAP.line(g, x0, y0, x1, y1);
                x0 = x1;
                y0 = y1;
            }
        }

        void drawDiagram(Graphics2D g, int art, double x0, int y0) {
            int right = 360;
            g.setColor(Color.black);
            CanvasAP.setAntiAliasing(g, false);
            g.drawString("x", right + 20, y0 + 12);
            String s = "\u0394" + (art == 1 ? "x" : "p");
            g.drawString(s, 40, y0 - 55);
            s = "";
            if (art == 1) {
                s = StandingLongitudinalWavesAP.this.text19;
            }
            if (art == 2) {
                s = StandingLongitudinalWavesAP.this.text20;
            }
            g.drawString(s, 110, y0 - 55);
            CanvasAP.setAntiAliasing(g, true);
            CanvasAP.arrow(g, 50.0, y0, right + 30, y0);
            CanvasAP.arrow(g, 60.0, y0 + 65, 60.0, y0 - 65);
            this.drawSinus(g, x0, y0, StandingLongitudinalWavesAP.this.lambda, StandingLongitudinalWavesAP.this.aMax, 60.0, right);
            this.drawSinus(g, x0, y0, StandingLongitudinalWavesAP.this.lambda, -StandingLongitudinalWavesAP.this.aMax, 60.0, right);
            Color c = art == 1 ? StandingLongitudinalWavesAP.this.colorElongation : StandingLongitudinalWavesAP.this.colorPressure;
            g.setColor(c);
            this.drawSinus(g, x0, y0, StandingLongitudinalWavesAP.this.lambda, StandingLongitudinalWavesAP.this.aMax * StandingLongitudinalWavesAP.this.cos, 60.0, right);
            this.drawMarks(g, art, y0);
            if (StandingLongitudinalWavesAP.this.xT < 0) {
                return;
            }
            double y = (double)y0 - (art == 1 ? StandingLongitudinalWavesAP.this.position(StandingLongitudinalWavesAP.this.xT) - (double)StandingLongitudinalWavesAP.this.xT : StandingLongitudinalWavesAP.this.dpPixel(StandingLongitudinalWavesAP.this.xT));
            if (art == 1) {
                CanvasAP.circle(g, StandingLongitudinalWavesAP.this.xT, y, 2.0, c, true);
            }
            g.setColor(c);
            CanvasAP.line(g, StandingLongitudinalWavesAP.this.xT, y0, StandingLongitudinalWavesAP.this.xT, y);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            if (StandingLongitudinalWavesAP.this.xT >= 60) {
                g.setColor(Color.lightGray);
                g.drawLine(StandingLongitudinalWavesAP.this.xT, 20, StandingLongitudinalWavesAP.this.xT, 400);
            }
            g.setFont(this.fH);
            this.drawTube(g2);
            double x0 = StandingLongitudinalWavesAP.this.type == 0 ? 60.0 - StandingLongitudinalWavesAP.this.lambda4 : 60.0;
            this.drawDiagram(g2, 1, x0, 185);
            x0 = StandingLongitudinalWavesAP.this.type == 0 ? 60.0 : 60.0 + StandingLongitudinalWavesAP.this.lambda4;
            this.drawDiagram(g2, 2, x0, 330);
        }
    }
}

